// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: xds/core/v3/resource_locator.proto

package com.github.xds.core.v3;

/**
 * <pre>
 * xDS resource locators identify a xDS resource name and instruct the
 * data-plane load balancer on how the resource may be located.
 * Resource locators have a canonical xdstp:// URI representation:
 *   xdstp://{authority}/{type_url}/{id}?{context_params}{#directive,*}
 * where context_params take the form of URI query parameters.
 * Resource locators have a similar canonical http:// URI representation:
 *   http://{authority}/{type_url}/{id}?{context_params}{#directive,*}
 * Resource locators also have a simplified file:// URI representation:
 *   file:///{id}{#directive,*}
 * </pre>
 *
 * Protobuf type {@code xds.core.v3.ResourceLocator}
 */
public final class ResourceLocator extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:xds.core.v3.ResourceLocator)
    ResourceLocatorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResourceLocator.newBuilder() to construct.
  private ResourceLocator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResourceLocator() {
    scheme_ = 0;
    id_ = "";
    authority_ = "";
    resourceType_ = "";
    directives_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ResourceLocator();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResourceLocator(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {
            int rawValue = input.readEnum();

            scheme_ = rawValue;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            authority_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            resourceType_ = s;
            break;
          }
          case 42: {
            com.github.xds.core.v3.ContextParams.Builder subBuilder = null;
            if (contextParamSpecifierCase_ == 5) {
              subBuilder = ((com.github.xds.core.v3.ContextParams) contextParamSpecifier_).toBuilder();
            }
            contextParamSpecifier_ =
                input.readMessage(com.github.xds.core.v3.ContextParams.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.github.xds.core.v3.ContextParams) contextParamSpecifier_);
              contextParamSpecifier_ = subBuilder.buildPartial();
            }
            contextParamSpecifierCase_ = 5;
            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              directives_ = new java.util.ArrayList<com.github.xds.core.v3.ResourceLocator.Directive>();
              mutable_bitField0_ |= 0x00000001;
            }
            directives_.add(
                input.readMessage(com.github.xds.core.v3.ResourceLocator.Directive.parser(), extensionRegistry));
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        directives_ = java.util.Collections.unmodifiableList(directives_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.github.xds.core.v3.ResourceLocator.class, com.github.xds.core.v3.ResourceLocator.Builder.class);
  }

  /**
   * Protobuf enum {@code xds.core.v3.ResourceLocator.Scheme}
   */
  public enum Scheme
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>XDSTP = 0;</code>
     */
    XDSTP(0),
    /**
     * <code>HTTP = 1;</code>
     */
    HTTP(1),
    /**
     * <code>FILE = 2;</code>
     */
    FILE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>XDSTP = 0;</code>
     */
    public static final int XDSTP_VALUE = 0;
    /**
     * <code>HTTP = 1;</code>
     */
    public static final int HTTP_VALUE = 1;
    /**
     * <code>FILE = 2;</code>
     */
    public static final int FILE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Scheme valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Scheme forNumber(int value) {
      switch (value) {
        case 0: return XDSTP;
        case 1: return HTTP;
        case 2: return FILE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Scheme>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Scheme> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Scheme>() {
            public Scheme findValueByNumber(int number) {
              return Scheme.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.github.xds.core.v3.ResourceLocator.getDescriptor().getEnumTypes().get(0);
    }

    private static final Scheme[] VALUES = values();

    public static Scheme valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Scheme(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:xds.core.v3.ResourceLocator.Scheme)
  }

  public interface DirectiveOrBuilder extends
      // @@protoc_insertion_point(interface_extends:xds.core.v3.ResourceLocator.Directive)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     * @return Whether the alt field is set.
     */
    boolean hasAlt();
    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     * @return The alt.
     */
    com.github.xds.core.v3.ResourceLocator getAlt();
    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     */
    com.github.xds.core.v3.ResourceLocatorOrBuilder getAltOrBuilder();

    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return Whether the entry field is set.
     */
    boolean hasEntry();
    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return The entry.
     */
    java.lang.String getEntry();
    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return The bytes for entry.
     */
    com.google.protobuf.ByteString
        getEntryBytes();

    public com.github.xds.core.v3.ResourceLocator.Directive.DirectiveCase getDirectiveCase();
  }
  /**
   * <pre>
   * Directives provide information to data-plane load balancers on how xDS
   * resource names are to be interpreted and potentially further resolved. For
   * example, they may provide alternative resource locators for when primary
   * resolution fails. Directives are not part of resource names and do not
   * appear in a xDS transport discovery request.
   * When encoding to URIs, directives take the form:
   * &lt;directive name&gt;=&lt;string representation of directive value&gt;
   * For example, we can have alt=xdstp://foo/bar or entry=some%20thing. Each
   * directive value type may have its own string encoding, in the case of
   * ResourceLocator there is a recursive URI encoding.
   * Percent encoding applies to the URI encoding of the directive value.
   * Multiple directives are comma-separated, so the reserved characters that
   * require percent encoding in a directive value are [',', '#', '[', ']',
   * '%']. These are the RFC3986 fragment reserved characters with the addition
   * of the xDS scheme specific ','. See
   * https://tools.ietf.org/html/rfc3986#page-49 for further details on URI ABNF
   * and reserved characters.
   * </pre>
   *
   * Protobuf type {@code xds.core.v3.ResourceLocator.Directive}
   */
  public static final class Directive extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:xds.core.v3.ResourceLocator.Directive)
      DirectiveOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Directive.newBuilder() to construct.
    private Directive(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Directive() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Directive();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Directive(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.github.xds.core.v3.ResourceLocator.Builder subBuilder = null;
              if (directiveCase_ == 1) {
                subBuilder = ((com.github.xds.core.v3.ResourceLocator) directive_).toBuilder();
              }
              directive_ =
                  input.readMessage(com.github.xds.core.v3.ResourceLocator.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.github.xds.core.v3.ResourceLocator) directive_);
                directive_ = subBuilder.buildPartial();
              }
              directiveCase_ = 1;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              directiveCase_ = 2;
              directive_ = s;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_Directive_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_Directive_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.github.xds.core.v3.ResourceLocator.Directive.class, com.github.xds.core.v3.ResourceLocator.Directive.Builder.class);
    }

    private int directiveCase_ = 0;
    private java.lang.Object directive_;
    public enum DirectiveCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ALT(1),
      ENTRY(2),
      DIRECTIVE_NOT_SET(0);
      private final int value;
      private DirectiveCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DirectiveCase valueOf(int value) {
        return forNumber(value);
      }

      public static DirectiveCase forNumber(int value) {
        switch (value) {
          case 1: return ALT;
          case 2: return ENTRY;
          case 0: return DIRECTIVE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public DirectiveCase
    getDirectiveCase() {
      return DirectiveCase.forNumber(
          directiveCase_);
    }

    public static final int ALT_FIELD_NUMBER = 1;
    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     * @return Whether the alt field is set.
     */
    @java.lang.Override
    public boolean hasAlt() {
      return directiveCase_ == 1;
    }
    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     * @return The alt.
     */
    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator getAlt() {
      if (directiveCase_ == 1) {
         return (com.github.xds.core.v3.ResourceLocator) directive_;
      }
      return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
    }
    /**
     * <pre>
     * An alternative resource locator for fallback if the resource is
     * unavailable. For example, take the resource locator:
     *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
     * If the data-plane load balancer is unable to reach `foo` to fetch the
     * resource, it will fallback to `bar`. Alternative resources do not need
     * to have equivalent content, but they should be functional substitutes.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
     */
    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocatorOrBuilder getAltOrBuilder() {
      if (directiveCase_ == 1) {
         return (com.github.xds.core.v3.ResourceLocator) directive_;
      }
      return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
    }

    public static final int ENTRY_FIELD_NUMBER = 2;
    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return Whether the entry field is set.
     */
    public boolean hasEntry() {
      return directiveCase_ == 2;
    }
    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return The entry.
     */
    public java.lang.String getEntry() {
      java.lang.Object ref = "";
      if (directiveCase_ == 2) {
        ref = directive_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (directiveCase_ == 2) {
          directive_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * List collections support inlining of resources via the entry field in
     * Resource. These inlined Resource objects may have an optional name
     * field specified. When specified, the entry directive allows
     * ResourceLocator to directly reference these inlined resources, e.g.
     * xdstp://.../foo#entry=bar.
     * </pre>
     *
     * <code>string entry = 2 [(.validate.rules) = { ... }</code>
     * @return The bytes for entry.
     */
    public com.google.protobuf.ByteString
        getEntryBytes() {
      java.lang.Object ref = "";
      if (directiveCase_ == 2) {
        ref = directive_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (directiveCase_ == 2) {
          directive_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (directiveCase_ == 1) {
        output.writeMessage(1, (com.github.xds.core.v3.ResourceLocator) directive_);
      }
      if (directiveCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, directive_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (directiveCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (com.github.xds.core.v3.ResourceLocator) directive_);
      }
      if (directiveCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, directive_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.github.xds.core.v3.ResourceLocator.Directive)) {
        return super.equals(obj);
      }
      com.github.xds.core.v3.ResourceLocator.Directive other = (com.github.xds.core.v3.ResourceLocator.Directive) obj;

      if (!getDirectiveCase().equals(other.getDirectiveCase())) return false;
      switch (directiveCase_) {
        case 1:
          if (!getAlt()
              .equals(other.getAlt())) return false;
          break;
        case 2:
          if (!getEntry()
              .equals(other.getEntry())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (directiveCase_) {
        case 1:
          hash = (37 * hash) + ALT_FIELD_NUMBER;
          hash = (53 * hash) + getAlt().hashCode();
          break;
        case 2:
          hash = (37 * hash) + ENTRY_FIELD_NUMBER;
          hash = (53 * hash) + getEntry().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.github.xds.core.v3.ResourceLocator.Directive parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.github.xds.core.v3.ResourceLocator.Directive prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Directives provide information to data-plane load balancers on how xDS
     * resource names are to be interpreted and potentially further resolved. For
     * example, they may provide alternative resource locators for when primary
     * resolution fails. Directives are not part of resource names and do not
     * appear in a xDS transport discovery request.
     * When encoding to URIs, directives take the form:
     * &lt;directive name&gt;=&lt;string representation of directive value&gt;
     * For example, we can have alt=xdstp://foo/bar or entry=some%20thing. Each
     * directive value type may have its own string encoding, in the case of
     * ResourceLocator there is a recursive URI encoding.
     * Percent encoding applies to the URI encoding of the directive value.
     * Multiple directives are comma-separated, so the reserved characters that
     * require percent encoding in a directive value are [',', '#', '[', ']',
     * '%']. These are the RFC3986 fragment reserved characters with the addition
     * of the xDS scheme specific ','. See
     * https://tools.ietf.org/html/rfc3986#page-49 for further details on URI ABNF
     * and reserved characters.
     * </pre>
     *
     * Protobuf type {@code xds.core.v3.ResourceLocator.Directive}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:xds.core.v3.ResourceLocator.Directive)
        com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_Directive_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_Directive_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.github.xds.core.v3.ResourceLocator.Directive.class, com.github.xds.core.v3.ResourceLocator.Directive.Builder.class);
      }

      // Construct using com.github.xds.core.v3.ResourceLocator.Directive.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        directiveCase_ = 0;
        directive_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_Directive_descriptor;
      }

      @java.lang.Override
      public com.github.xds.core.v3.ResourceLocator.Directive getDefaultInstanceForType() {
        return com.github.xds.core.v3.ResourceLocator.Directive.getDefaultInstance();
      }

      @java.lang.Override
      public com.github.xds.core.v3.ResourceLocator.Directive build() {
        com.github.xds.core.v3.ResourceLocator.Directive result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.github.xds.core.v3.ResourceLocator.Directive buildPartial() {
        com.github.xds.core.v3.ResourceLocator.Directive result = new com.github.xds.core.v3.ResourceLocator.Directive(this);
        if (directiveCase_ == 1) {
          if (altBuilder_ == null) {
            result.directive_ = directive_;
          } else {
            result.directive_ = altBuilder_.build();
          }
        }
        if (directiveCase_ == 2) {
          result.directive_ = directive_;
        }
        result.directiveCase_ = directiveCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.github.xds.core.v3.ResourceLocator.Directive) {
          return mergeFrom((com.github.xds.core.v3.ResourceLocator.Directive)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.github.xds.core.v3.ResourceLocator.Directive other) {
        if (other == com.github.xds.core.v3.ResourceLocator.Directive.getDefaultInstance()) return this;
        switch (other.getDirectiveCase()) {
          case ALT: {
            mergeAlt(other.getAlt());
            break;
          }
          case ENTRY: {
            directiveCase_ = 2;
            directive_ = other.directive_;
            onChanged();
            break;
          }
          case DIRECTIVE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.github.xds.core.v3.ResourceLocator.Directive parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.github.xds.core.v3.ResourceLocator.Directive) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int directiveCase_ = 0;
      private java.lang.Object directive_;
      public DirectiveCase
          getDirectiveCase() {
        return DirectiveCase.forNumber(
            directiveCase_);
      }

      public Builder clearDirective() {
        directiveCase_ = 0;
        directive_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          com.github.xds.core.v3.ResourceLocator, com.github.xds.core.v3.ResourceLocator.Builder, com.github.xds.core.v3.ResourceLocatorOrBuilder> altBuilder_;
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       * @return Whether the alt field is set.
       */
      @java.lang.Override
      public boolean hasAlt() {
        return directiveCase_ == 1;
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       * @return The alt.
       */
      @java.lang.Override
      public com.github.xds.core.v3.ResourceLocator getAlt() {
        if (altBuilder_ == null) {
          if (directiveCase_ == 1) {
            return (com.github.xds.core.v3.ResourceLocator) directive_;
          }
          return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
        } else {
          if (directiveCase_ == 1) {
            return altBuilder_.getMessage();
          }
          return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      public Builder setAlt(com.github.xds.core.v3.ResourceLocator value) {
        if (altBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          directive_ = value;
          onChanged();
        } else {
          altBuilder_.setMessage(value);
        }
        directiveCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      public Builder setAlt(
          com.github.xds.core.v3.ResourceLocator.Builder builderForValue) {
        if (altBuilder_ == null) {
          directive_ = builderForValue.build();
          onChanged();
        } else {
          altBuilder_.setMessage(builderForValue.build());
        }
        directiveCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      public Builder mergeAlt(com.github.xds.core.v3.ResourceLocator value) {
        if (altBuilder_ == null) {
          if (directiveCase_ == 1 &&
              directive_ != com.github.xds.core.v3.ResourceLocator.getDefaultInstance()) {
            directive_ = com.github.xds.core.v3.ResourceLocator.newBuilder((com.github.xds.core.v3.ResourceLocator) directive_)
                .mergeFrom(value).buildPartial();
          } else {
            directive_ = value;
          }
          onChanged();
        } else {
          if (directiveCase_ == 1) {
            altBuilder_.mergeFrom(value);
          } else {
            altBuilder_.setMessage(value);
          }
        }
        directiveCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      public Builder clearAlt() {
        if (altBuilder_ == null) {
          if (directiveCase_ == 1) {
            directiveCase_ = 0;
            directive_ = null;
            onChanged();
          }
        } else {
          if (directiveCase_ == 1) {
            directiveCase_ = 0;
            directive_ = null;
          }
          altBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      public com.github.xds.core.v3.ResourceLocator.Builder getAltBuilder() {
        return getAltFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      @java.lang.Override
      public com.github.xds.core.v3.ResourceLocatorOrBuilder getAltOrBuilder() {
        if ((directiveCase_ == 1) && (altBuilder_ != null)) {
          return altBuilder_.getMessageOrBuilder();
        } else {
          if (directiveCase_ == 1) {
            return (com.github.xds.core.v3.ResourceLocator) directive_;
          }
          return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * An alternative resource locator for fallback if the resource is
       * unavailable. For example, take the resource locator:
       *   xdstp://foo/some-type/some-route-table#alt=xdstp://bar/some-type/another-route-table
       * If the data-plane load balancer is unable to reach `foo` to fetch the
       * resource, it will fallback to `bar`. Alternative resources do not need
       * to have equivalent content, but they should be functional substitutes.
       * </pre>
       *
       * <code>.xds.core.v3.ResourceLocator alt = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.github.xds.core.v3.ResourceLocator, com.github.xds.core.v3.ResourceLocator.Builder, com.github.xds.core.v3.ResourceLocatorOrBuilder> 
          getAltFieldBuilder() {
        if (altBuilder_ == null) {
          if (!(directiveCase_ == 1)) {
            directive_ = com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
          }
          altBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.github.xds.core.v3.ResourceLocator, com.github.xds.core.v3.ResourceLocator.Builder, com.github.xds.core.v3.ResourceLocatorOrBuilder>(
                  (com.github.xds.core.v3.ResourceLocator) directive_,
                  getParentForChildren(),
                  isClean());
          directive_ = null;
        }
        directiveCase_ = 1;
        onChanged();;
        return altBuilder_;
      }

      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @return Whether the entry field is set.
       */
      @java.lang.Override
      public boolean hasEntry() {
        return directiveCase_ == 2;
      }
      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @return The entry.
       */
      @java.lang.Override
      public java.lang.String getEntry() {
        java.lang.Object ref = "";
        if (directiveCase_ == 2) {
          ref = directive_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (directiveCase_ == 2) {
            directive_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @return The bytes for entry.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getEntryBytes() {
        java.lang.Object ref = "";
        if (directiveCase_ == 2) {
          ref = directive_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (directiveCase_ == 2) {
            directive_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @param value The entry to set.
       * @return This builder for chaining.
       */
      public Builder setEntry(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  directiveCase_ = 2;
        directive_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearEntry() {
        if (directiveCase_ == 2) {
          directiveCase_ = 0;
          directive_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * List collections support inlining of resources via the entry field in
       * Resource. These inlined Resource objects may have an optional name
       * field specified. When specified, the entry directive allows
       * ResourceLocator to directly reference these inlined resources, e.g.
       * xdstp://.../foo#entry=bar.
       * </pre>
       *
       * <code>string entry = 2 [(.validate.rules) = { ... }</code>
       * @param value The bytes for entry to set.
       * @return This builder for chaining.
       */
      public Builder setEntryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        directiveCase_ = 2;
        directive_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:xds.core.v3.ResourceLocator.Directive)
    }

    // @@protoc_insertion_point(class_scope:xds.core.v3.ResourceLocator.Directive)
    private static final com.github.xds.core.v3.ResourceLocator.Directive DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.github.xds.core.v3.ResourceLocator.Directive();
    }

    public static com.github.xds.core.v3.ResourceLocator.Directive getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Directive>
        PARSER = new com.google.protobuf.AbstractParser<Directive>() {
      @java.lang.Override
      public Directive parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Directive(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Directive> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Directive> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator.Directive getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int contextParamSpecifierCase_ = 0;
  private java.lang.Object contextParamSpecifier_;
  public enum ContextParamSpecifierCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXACT_CONTEXT(5),
    CONTEXTPARAMSPECIFIER_NOT_SET(0);
    private final int value;
    private ContextParamSpecifierCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContextParamSpecifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContextParamSpecifierCase forNumber(int value) {
      switch (value) {
        case 5: return EXACT_CONTEXT;
        case 0: return CONTEXTPARAMSPECIFIER_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ContextParamSpecifierCase
  getContextParamSpecifierCase() {
    return ContextParamSpecifierCase.forNumber(
        contextParamSpecifierCase_);
  }

  public static final int SCHEME_FIELD_NUMBER = 1;
  private int scheme_;
  /**
   * <pre>
   * URI scheme.
   * </pre>
   *
   * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
   * @return The enum numeric value on the wire for scheme.
   */
  @java.lang.Override public int getSchemeValue() {
    return scheme_;
  }
  /**
   * <pre>
   * URI scheme.
   * </pre>
   *
   * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
   * @return The scheme.
   */
  @java.lang.Override public com.github.xds.core.v3.ResourceLocator.Scheme getScheme() {
    @SuppressWarnings("deprecation")
    com.github.xds.core.v3.ResourceLocator.Scheme result = com.github.xds.core.v3.ResourceLocator.Scheme.valueOf(scheme_);
    return result == null ? com.github.xds.core.v3.ResourceLocator.Scheme.UNRECOGNIZED : result;
  }

  public static final int ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * Opaque identifier for the resource. Any '/' will not be escaped during URI
   * encoding and will form part of the URI path. This may end
   * with ‘*’ for glob collection references.
   * </pre>
   *
   * <code>string id = 2;</code>
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Opaque identifier for the resource. Any '/' will not be escaped during URI
   * encoding and will form part of the URI path. This may end
   * with ‘*’ for glob collection references.
   * </pre>
   *
   * <code>string id = 2;</code>
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORITY_FIELD_NUMBER = 3;
  private volatile java.lang.Object authority_;
  /**
   * <pre>
   * Logical authority for resource (not necessarily transport network address).
   * Authorities are opaque in the xDS API, data-plane load balancers will map
   * them to concrete network transports such as an xDS management server, e.g.
   * via envoy.config.core.v3.ConfigSource.
   * </pre>
   *
   * <code>string authority = 3;</code>
   * @return The authority.
   */
  @java.lang.Override
  public java.lang.String getAuthority() {
    java.lang.Object ref = authority_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authority_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Logical authority for resource (not necessarily transport network address).
   * Authorities are opaque in the xDS API, data-plane load balancers will map
   * them to concrete network transports such as an xDS management server, e.g.
   * via envoy.config.core.v3.ConfigSource.
   * </pre>
   *
   * <code>string authority = 3;</code>
   * @return The bytes for authority.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAuthorityBytes() {
    java.lang.Object ref = authority_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      authority_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 4;
  private volatile java.lang.Object resourceType_;
  /**
   * <pre>
   * Fully qualified resource type (as in type URL without types.googleapis.com/
   * prefix).
   * </pre>
   *
   * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
   * @return The resourceType.
   */
  @java.lang.Override
  public java.lang.String getResourceType() {
    java.lang.Object ref = resourceType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceType_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Fully qualified resource type (as in type URL without types.googleapis.com/
   * prefix).
   * </pre>
   *
   * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
   * @return The bytes for resourceType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceTypeBytes() {
    java.lang.Object ref = resourceType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXACT_CONTEXT_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Additional parameters that can be used to select resource variants.
   * Matches must be exact, i.e. all context parameters must match exactly and
   * there must be no additional context parameters set on the matched
   * resource.
   * </pre>
   *
   * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
   * @return Whether the exactContext field is set.
   */
  @java.lang.Override
  public boolean hasExactContext() {
    return contextParamSpecifierCase_ == 5;
  }
  /**
   * <pre>
   * Additional parameters that can be used to select resource variants.
   * Matches must be exact, i.e. all context parameters must match exactly and
   * there must be no additional context parameters set on the matched
   * resource.
   * </pre>
   *
   * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
   * @return The exactContext.
   */
  @java.lang.Override
  public com.github.xds.core.v3.ContextParams getExactContext() {
    if (contextParamSpecifierCase_ == 5) {
       return (com.github.xds.core.v3.ContextParams) contextParamSpecifier_;
    }
    return com.github.xds.core.v3.ContextParams.getDefaultInstance();
  }
  /**
   * <pre>
   * Additional parameters that can be used to select resource variants.
   * Matches must be exact, i.e. all context parameters must match exactly and
   * there must be no additional context parameters set on the matched
   * resource.
   * </pre>
   *
   * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
   */
  @java.lang.Override
  public com.github.xds.core.v3.ContextParamsOrBuilder getExactContextOrBuilder() {
    if (contextParamSpecifierCase_ == 5) {
       return (com.github.xds.core.v3.ContextParams) contextParamSpecifier_;
    }
    return com.github.xds.core.v3.ContextParams.getDefaultInstance();
  }

  public static final int DIRECTIVES_FIELD_NUMBER = 6;
  private java.util.List<com.github.xds.core.v3.ResourceLocator.Directive> directives_;
  /**
   * <pre>
   * A list of directives that appear in the xDS resource locator #fragment.
   * When encoding to URI form, directives are percent encoded with comma
   * separation.
   * </pre>
   *
   * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.github.xds.core.v3.ResourceLocator.Directive> getDirectivesList() {
    return directives_;
  }
  /**
   * <pre>
   * A list of directives that appear in the xDS resource locator #fragment.
   * When encoding to URI form, directives are percent encoded with comma
   * separation.
   * </pre>
   *
   * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder> 
      getDirectivesOrBuilderList() {
    return directives_;
  }
  /**
   * <pre>
   * A list of directives that appear in the xDS resource locator #fragment.
   * When encoding to URI form, directives are percent encoded with comma
   * separation.
   * </pre>
   *
   * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
   */
  @java.lang.Override
  public int getDirectivesCount() {
    return directives_.size();
  }
  /**
   * <pre>
   * A list of directives that appear in the xDS resource locator #fragment.
   * When encoding to URI form, directives are percent encoded with comma
   * separation.
   * </pre>
   *
   * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
   */
  @java.lang.Override
  public com.github.xds.core.v3.ResourceLocator.Directive getDirectives(int index) {
    return directives_.get(index);
  }
  /**
   * <pre>
   * A list of directives that appear in the xDS resource locator #fragment.
   * When encoding to URI form, directives are percent encoded with comma
   * separation.
   * </pre>
   *
   * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
   */
  @java.lang.Override
  public com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder getDirectivesOrBuilder(
      int index) {
    return directives_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (scheme_ != com.github.xds.core.v3.ResourceLocator.Scheme.XDSTP.getNumber()) {
      output.writeEnum(1, scheme_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authority_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, authority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceType_);
    }
    if (contextParamSpecifierCase_ == 5) {
      output.writeMessage(5, (com.github.xds.core.v3.ContextParams) contextParamSpecifier_);
    }
    for (int i = 0; i < directives_.size(); i++) {
      output.writeMessage(6, directives_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (scheme_ != com.github.xds.core.v3.ResourceLocator.Scheme.XDSTP.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, scheme_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authority_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, authority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceType_);
    }
    if (contextParamSpecifierCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.github.xds.core.v3.ContextParams) contextParamSpecifier_);
    }
    for (int i = 0; i < directives_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, directives_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.github.xds.core.v3.ResourceLocator)) {
      return super.equals(obj);
    }
    com.github.xds.core.v3.ResourceLocator other = (com.github.xds.core.v3.ResourceLocator) obj;

    if (scheme_ != other.scheme_) return false;
    if (!getId()
        .equals(other.getId())) return false;
    if (!getAuthority()
        .equals(other.getAuthority())) return false;
    if (!getResourceType()
        .equals(other.getResourceType())) return false;
    if (!getDirectivesList()
        .equals(other.getDirectivesList())) return false;
    if (!getContextParamSpecifierCase().equals(other.getContextParamSpecifierCase())) return false;
    switch (contextParamSpecifierCase_) {
      case 5:
        if (!getExactContext()
            .equals(other.getExactContext())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCHEME_FIELD_NUMBER;
    hash = (53 * hash) + scheme_;
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + AUTHORITY_FIELD_NUMBER;
    hash = (53 * hash) + getAuthority().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getResourceType().hashCode();
    if (getDirectivesCount() > 0) {
      hash = (37 * hash) + DIRECTIVES_FIELD_NUMBER;
      hash = (53 * hash) + getDirectivesList().hashCode();
    }
    switch (contextParamSpecifierCase_) {
      case 5:
        hash = (37 * hash) + EXACT_CONTEXT_FIELD_NUMBER;
        hash = (53 * hash) + getExactContext().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.github.xds.core.v3.ResourceLocator parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.github.xds.core.v3.ResourceLocator parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.github.xds.core.v3.ResourceLocator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.github.xds.core.v3.ResourceLocator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * xDS resource locators identify a xDS resource name and instruct the
   * data-plane load balancer on how the resource may be located.
   * Resource locators have a canonical xdstp:// URI representation:
   *   xdstp://{authority}/{type_url}/{id}?{context_params}{#directive,*}
   * where context_params take the form of URI query parameters.
   * Resource locators have a similar canonical http:// URI representation:
   *   http://{authority}/{type_url}/{id}?{context_params}{#directive,*}
   * Resource locators also have a simplified file:// URI representation:
   *   file:///{id}{#directive,*}
   * </pre>
   *
   * Protobuf type {@code xds.core.v3.ResourceLocator}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:xds.core.v3.ResourceLocator)
      com.github.xds.core.v3.ResourceLocatorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.github.xds.core.v3.ResourceLocator.class, com.github.xds.core.v3.ResourceLocator.Builder.class);
    }

    // Construct using com.github.xds.core.v3.ResourceLocator.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getDirectivesFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      scheme_ = 0;

      id_ = "";

      authority_ = "";

      resourceType_ = "";

      if (directivesBuilder_ == null) {
        directives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        directivesBuilder_.clear();
      }
      contextParamSpecifierCase_ = 0;
      contextParamSpecifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.github.xds.core.v3.ResourceLocatorProto.internal_static_xds_core_v3_ResourceLocator_descriptor;
    }

    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator getDefaultInstanceForType() {
      return com.github.xds.core.v3.ResourceLocator.getDefaultInstance();
    }

    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator build() {
      com.github.xds.core.v3.ResourceLocator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator buildPartial() {
      com.github.xds.core.v3.ResourceLocator result = new com.github.xds.core.v3.ResourceLocator(this);
      int from_bitField0_ = bitField0_;
      result.scheme_ = scheme_;
      result.id_ = id_;
      result.authority_ = authority_;
      result.resourceType_ = resourceType_;
      if (contextParamSpecifierCase_ == 5) {
        if (exactContextBuilder_ == null) {
          result.contextParamSpecifier_ = contextParamSpecifier_;
        } else {
          result.contextParamSpecifier_ = exactContextBuilder_.build();
        }
      }
      if (directivesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          directives_ = java.util.Collections.unmodifiableList(directives_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.directives_ = directives_;
      } else {
        result.directives_ = directivesBuilder_.build();
      }
      result.contextParamSpecifierCase_ = contextParamSpecifierCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.github.xds.core.v3.ResourceLocator) {
        return mergeFrom((com.github.xds.core.v3.ResourceLocator)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.github.xds.core.v3.ResourceLocator other) {
      if (other == com.github.xds.core.v3.ResourceLocator.getDefaultInstance()) return this;
      if (other.scheme_ != 0) {
        setSchemeValue(other.getSchemeValue());
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getAuthority().isEmpty()) {
        authority_ = other.authority_;
        onChanged();
      }
      if (!other.getResourceType().isEmpty()) {
        resourceType_ = other.resourceType_;
        onChanged();
      }
      if (directivesBuilder_ == null) {
        if (!other.directives_.isEmpty()) {
          if (directives_.isEmpty()) {
            directives_ = other.directives_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDirectivesIsMutable();
            directives_.addAll(other.directives_);
          }
          onChanged();
        }
      } else {
        if (!other.directives_.isEmpty()) {
          if (directivesBuilder_.isEmpty()) {
            directivesBuilder_.dispose();
            directivesBuilder_ = null;
            directives_ = other.directives_;
            bitField0_ = (bitField0_ & ~0x00000001);
            directivesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDirectivesFieldBuilder() : null;
          } else {
            directivesBuilder_.addAllMessages(other.directives_);
          }
        }
      }
      switch (other.getContextParamSpecifierCase()) {
        case EXACT_CONTEXT: {
          mergeExactContext(other.getExactContext());
          break;
        }
        case CONTEXTPARAMSPECIFIER_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.github.xds.core.v3.ResourceLocator parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.github.xds.core.v3.ResourceLocator) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int contextParamSpecifierCase_ = 0;
    private java.lang.Object contextParamSpecifier_;
    public ContextParamSpecifierCase
        getContextParamSpecifierCase() {
      return ContextParamSpecifierCase.forNumber(
          contextParamSpecifierCase_);
    }

    public Builder clearContextParamSpecifier() {
      contextParamSpecifierCase_ = 0;
      contextParamSpecifier_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int scheme_ = 0;
    /**
     * <pre>
     * URI scheme.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for scheme.
     */
    @java.lang.Override public int getSchemeValue() {
      return scheme_;
    }
    /**
     * <pre>
     * URI scheme.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
     * @param value The enum numeric value on the wire for scheme to set.
     * @return This builder for chaining.
     */
    public Builder setSchemeValue(int value) {
      
      scheme_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * URI scheme.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
     * @return The scheme.
     */
    @java.lang.Override
    public com.github.xds.core.v3.ResourceLocator.Scheme getScheme() {
      @SuppressWarnings("deprecation")
      com.github.xds.core.v3.ResourceLocator.Scheme result = com.github.xds.core.v3.ResourceLocator.Scheme.valueOf(scheme_);
      return result == null ? com.github.xds.core.v3.ResourceLocator.Scheme.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * URI scheme.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
     * @param value The scheme to set.
     * @return This builder for chaining.
     */
    public Builder setScheme(com.github.xds.core.v3.ResourceLocator.Scheme value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      scheme_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * URI scheme.
     * </pre>
     *
     * <code>.xds.core.v3.ResourceLocator.Scheme scheme = 1 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearScheme() {
      
      scheme_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * Opaque identifier for the resource. Any '/' will not be escaped during URI
     * encoding and will form part of the URI path. This may end
     * with ‘*’ for glob collection references.
     * </pre>
     *
     * <code>string id = 2;</code>
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Opaque identifier for the resource. Any '/' will not be escaped during URI
     * encoding and will form part of the URI path. This may end
     * with ‘*’ for glob collection references.
     * </pre>
     *
     * <code>string id = 2;</code>
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Opaque identifier for the resource. Any '/' will not be escaped during URI
     * encoding and will form part of the URI path. This may end
     * with ‘*’ for glob collection references.
     * </pre>
     *
     * <code>string id = 2;</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Opaque identifier for the resource. Any '/' will not be escaped during URI
     * encoding and will form part of the URI path. This may end
     * with ‘*’ for glob collection references.
     * </pre>
     *
     * <code>string id = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Opaque identifier for the resource. Any '/' will not be escaped during URI
     * encoding and will form part of the URI path. This may end
     * with ‘*’ for glob collection references.
     * </pre>
     *
     * <code>string id = 2;</code>
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object authority_ = "";
    /**
     * <pre>
     * Logical authority for resource (not necessarily transport network address).
     * Authorities are opaque in the xDS API, data-plane load balancers will map
     * them to concrete network transports such as an xDS management server, e.g.
     * via envoy.config.core.v3.ConfigSource.
     * </pre>
     *
     * <code>string authority = 3;</code>
     * @return The authority.
     */
    public java.lang.String getAuthority() {
      java.lang.Object ref = authority_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authority_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Logical authority for resource (not necessarily transport network address).
     * Authorities are opaque in the xDS API, data-plane load balancers will map
     * them to concrete network transports such as an xDS management server, e.g.
     * via envoy.config.core.v3.ConfigSource.
     * </pre>
     *
     * <code>string authority = 3;</code>
     * @return The bytes for authority.
     */
    public com.google.protobuf.ByteString
        getAuthorityBytes() {
      java.lang.Object ref = authority_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        authority_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Logical authority for resource (not necessarily transport network address).
     * Authorities are opaque in the xDS API, data-plane load balancers will map
     * them to concrete network transports such as an xDS management server, e.g.
     * via envoy.config.core.v3.ConfigSource.
     * </pre>
     *
     * <code>string authority = 3;</code>
     * @param value The authority to set.
     * @return This builder for chaining.
     */
    public Builder setAuthority(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      authority_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Logical authority for resource (not necessarily transport network address).
     * Authorities are opaque in the xDS API, data-plane load balancers will map
     * them to concrete network transports such as an xDS management server, e.g.
     * via envoy.config.core.v3.ConfigSource.
     * </pre>
     *
     * <code>string authority = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearAuthority() {
      
      authority_ = getDefaultInstance().getAuthority();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Logical authority for resource (not necessarily transport network address).
     * Authorities are opaque in the xDS API, data-plane load balancers will map
     * them to concrete network transports such as an xDS management server, e.g.
     * via envoy.config.core.v3.ConfigSource.
     * </pre>
     *
     * <code>string authority = 3;</code>
     * @param value The bytes for authority to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorityBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      authority_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object resourceType_ = "";
    /**
     * <pre>
     * Fully qualified resource type (as in type URL without types.googleapis.com/
     * prefix).
     * </pre>
     *
     * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
     * @return The resourceType.
     */
    public java.lang.String getResourceType() {
      java.lang.Object ref = resourceType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Fully qualified resource type (as in type URL without types.googleapis.com/
     * prefix).
     * </pre>
     *
     * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
     * @return The bytes for resourceType.
     */
    public com.google.protobuf.ByteString
        getResourceTypeBytes() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Fully qualified resource type (as in type URL without types.googleapis.com/
     * prefix).
     * </pre>
     *
     * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      resourceType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fully qualified resource type (as in type URL without types.googleapis.com/
     * prefix).
     * </pre>
     *
     * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      
      resourceType_ = getDefaultInstance().getResourceType();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fully qualified resource type (as in type URL without types.googleapis.com/
     * prefix).
     * </pre>
     *
     * <code>string resource_type = 4 [(.validate.rules) = { ... }</code>
     * @param value The bytes for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      resourceType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.github.xds.core.v3.ContextParams, com.github.xds.core.v3.ContextParams.Builder, com.github.xds.core.v3.ContextParamsOrBuilder> exactContextBuilder_;
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     * @return Whether the exactContext field is set.
     */
    @java.lang.Override
    public boolean hasExactContext() {
      return contextParamSpecifierCase_ == 5;
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     * @return The exactContext.
     */
    @java.lang.Override
    public com.github.xds.core.v3.ContextParams getExactContext() {
      if (exactContextBuilder_ == null) {
        if (contextParamSpecifierCase_ == 5) {
          return (com.github.xds.core.v3.ContextParams) contextParamSpecifier_;
        }
        return com.github.xds.core.v3.ContextParams.getDefaultInstance();
      } else {
        if (contextParamSpecifierCase_ == 5) {
          return exactContextBuilder_.getMessage();
        }
        return com.github.xds.core.v3.ContextParams.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    public Builder setExactContext(com.github.xds.core.v3.ContextParams value) {
      if (exactContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contextParamSpecifier_ = value;
        onChanged();
      } else {
        exactContextBuilder_.setMessage(value);
      }
      contextParamSpecifierCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    public Builder setExactContext(
        com.github.xds.core.v3.ContextParams.Builder builderForValue) {
      if (exactContextBuilder_ == null) {
        contextParamSpecifier_ = builderForValue.build();
        onChanged();
      } else {
        exactContextBuilder_.setMessage(builderForValue.build());
      }
      contextParamSpecifierCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    public Builder mergeExactContext(com.github.xds.core.v3.ContextParams value) {
      if (exactContextBuilder_ == null) {
        if (contextParamSpecifierCase_ == 5 &&
            contextParamSpecifier_ != com.github.xds.core.v3.ContextParams.getDefaultInstance()) {
          contextParamSpecifier_ = com.github.xds.core.v3.ContextParams.newBuilder((com.github.xds.core.v3.ContextParams) contextParamSpecifier_)
              .mergeFrom(value).buildPartial();
        } else {
          contextParamSpecifier_ = value;
        }
        onChanged();
      } else {
        if (contextParamSpecifierCase_ == 5) {
          exactContextBuilder_.mergeFrom(value);
        } else {
          exactContextBuilder_.setMessage(value);
        }
      }
      contextParamSpecifierCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    public Builder clearExactContext() {
      if (exactContextBuilder_ == null) {
        if (contextParamSpecifierCase_ == 5) {
          contextParamSpecifierCase_ = 0;
          contextParamSpecifier_ = null;
          onChanged();
        }
      } else {
        if (contextParamSpecifierCase_ == 5) {
          contextParamSpecifierCase_ = 0;
          contextParamSpecifier_ = null;
        }
        exactContextBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    public com.github.xds.core.v3.ContextParams.Builder getExactContextBuilder() {
      return getExactContextFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    @java.lang.Override
    public com.github.xds.core.v3.ContextParamsOrBuilder getExactContextOrBuilder() {
      if ((contextParamSpecifierCase_ == 5) && (exactContextBuilder_ != null)) {
        return exactContextBuilder_.getMessageOrBuilder();
      } else {
        if (contextParamSpecifierCase_ == 5) {
          return (com.github.xds.core.v3.ContextParams) contextParamSpecifier_;
        }
        return com.github.xds.core.v3.ContextParams.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Additional parameters that can be used to select resource variants.
     * Matches must be exact, i.e. all context parameters must match exactly and
     * there must be no additional context parameters set on the matched
     * resource.
     * </pre>
     *
     * <code>.xds.core.v3.ContextParams exact_context = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.github.xds.core.v3.ContextParams, com.github.xds.core.v3.ContextParams.Builder, com.github.xds.core.v3.ContextParamsOrBuilder> 
        getExactContextFieldBuilder() {
      if (exactContextBuilder_ == null) {
        if (!(contextParamSpecifierCase_ == 5)) {
          contextParamSpecifier_ = com.github.xds.core.v3.ContextParams.getDefaultInstance();
        }
        exactContextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.github.xds.core.v3.ContextParams, com.github.xds.core.v3.ContextParams.Builder, com.github.xds.core.v3.ContextParamsOrBuilder>(
                (com.github.xds.core.v3.ContextParams) contextParamSpecifier_,
                getParentForChildren(),
                isClean());
        contextParamSpecifier_ = null;
      }
      contextParamSpecifierCase_ = 5;
      onChanged();;
      return exactContextBuilder_;
    }

    private java.util.List<com.github.xds.core.v3.ResourceLocator.Directive> directives_ =
      java.util.Collections.emptyList();
    private void ensureDirectivesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        directives_ = new java.util.ArrayList<com.github.xds.core.v3.ResourceLocator.Directive>(directives_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.github.xds.core.v3.ResourceLocator.Directive, com.github.xds.core.v3.ResourceLocator.Directive.Builder, com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder> directivesBuilder_;

    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public java.util.List<com.github.xds.core.v3.ResourceLocator.Directive> getDirectivesList() {
      if (directivesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(directives_);
      } else {
        return directivesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public int getDirectivesCount() {
      if (directivesBuilder_ == null) {
        return directives_.size();
      } else {
        return directivesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public com.github.xds.core.v3.ResourceLocator.Directive getDirectives(int index) {
      if (directivesBuilder_ == null) {
        return directives_.get(index);
      } else {
        return directivesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder setDirectives(
        int index, com.github.xds.core.v3.ResourceLocator.Directive value) {
      if (directivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectivesIsMutable();
        directives_.set(index, value);
        onChanged();
      } else {
        directivesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder setDirectives(
        int index, com.github.xds.core.v3.ResourceLocator.Directive.Builder builderForValue) {
      if (directivesBuilder_ == null) {
        ensureDirectivesIsMutable();
        directives_.set(index, builderForValue.build());
        onChanged();
      } else {
        directivesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder addDirectives(com.github.xds.core.v3.ResourceLocator.Directive value) {
      if (directivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectivesIsMutable();
        directives_.add(value);
        onChanged();
      } else {
        directivesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder addDirectives(
        int index, com.github.xds.core.v3.ResourceLocator.Directive value) {
      if (directivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectivesIsMutable();
        directives_.add(index, value);
        onChanged();
      } else {
        directivesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder addDirectives(
        com.github.xds.core.v3.ResourceLocator.Directive.Builder builderForValue) {
      if (directivesBuilder_ == null) {
        ensureDirectivesIsMutable();
        directives_.add(builderForValue.build());
        onChanged();
      } else {
        directivesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder addDirectives(
        int index, com.github.xds.core.v3.ResourceLocator.Directive.Builder builderForValue) {
      if (directivesBuilder_ == null) {
        ensureDirectivesIsMutable();
        directives_.add(index, builderForValue.build());
        onChanged();
      } else {
        directivesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder addAllDirectives(
        java.lang.Iterable<? extends com.github.xds.core.v3.ResourceLocator.Directive> values) {
      if (directivesBuilder_ == null) {
        ensureDirectivesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, directives_);
        onChanged();
      } else {
        directivesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder clearDirectives() {
      if (directivesBuilder_ == null) {
        directives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        directivesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public Builder removeDirectives(int index) {
      if (directivesBuilder_ == null) {
        ensureDirectivesIsMutable();
        directives_.remove(index);
        onChanged();
      } else {
        directivesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public com.github.xds.core.v3.ResourceLocator.Directive.Builder getDirectivesBuilder(
        int index) {
      return getDirectivesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder getDirectivesOrBuilder(
        int index) {
      if (directivesBuilder_ == null) {
        return directives_.get(index);  } else {
        return directivesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public java.util.List<? extends com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder> 
         getDirectivesOrBuilderList() {
      if (directivesBuilder_ != null) {
        return directivesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(directives_);
      }
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public com.github.xds.core.v3.ResourceLocator.Directive.Builder addDirectivesBuilder() {
      return getDirectivesFieldBuilder().addBuilder(
          com.github.xds.core.v3.ResourceLocator.Directive.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public com.github.xds.core.v3.ResourceLocator.Directive.Builder addDirectivesBuilder(
        int index) {
      return getDirectivesFieldBuilder().addBuilder(
          index, com.github.xds.core.v3.ResourceLocator.Directive.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of directives that appear in the xDS resource locator #fragment.
     * When encoding to URI form, directives are percent encoded with comma
     * separation.
     * </pre>
     *
     * <code>repeated .xds.core.v3.ResourceLocator.Directive directives = 6;</code>
     */
    public java.util.List<com.github.xds.core.v3.ResourceLocator.Directive.Builder> 
         getDirectivesBuilderList() {
      return getDirectivesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.github.xds.core.v3.ResourceLocator.Directive, com.github.xds.core.v3.ResourceLocator.Directive.Builder, com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder> 
        getDirectivesFieldBuilder() {
      if (directivesBuilder_ == null) {
        directivesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.github.xds.core.v3.ResourceLocator.Directive, com.github.xds.core.v3.ResourceLocator.Directive.Builder, com.github.xds.core.v3.ResourceLocator.DirectiveOrBuilder>(
                directives_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        directives_ = null;
      }
      return directivesBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:xds.core.v3.ResourceLocator)
  }

  // @@protoc_insertion_point(class_scope:xds.core.v3.ResourceLocator)
  private static final com.github.xds.core.v3.ResourceLocator DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.github.xds.core.v3.ResourceLocator();
  }

  public static com.github.xds.core.v3.ResourceLocator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceLocator>
      PARSER = new com.google.protobuf.AbstractParser<ResourceLocator>() {
    @java.lang.Override
    public ResourceLocator parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResourceLocator(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResourceLocator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceLocator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.github.xds.core.v3.ResourceLocator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

