// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/filter/http/jwt_authn/v2alpha/config.proto

// Protobuf Java Version: 3.25.1
package io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha;

/**
 * <pre>
 * Please see following for JWT authentication flow:
 *
 * * `JSON Web Token (JWT) &lt;https://tools.ietf.org/html/rfc7519&gt;`_
 * * `The OAuth 2.0 Authorization Framework &lt;https://tools.ietf.org/html/rfc6749&gt;`_
 * * `OpenID Connect &lt;http://openid.net/connect&gt;`_
 *
 * A JwtProvider message specifies how a JSON Web Token (JWT) can be verified. It specifies:
 *
 * * issuer: the principal that issues the JWT. It has to match the one from the token.
 * * allowed audiences: the ones in the token have to be listed here.
 * * how to fetch public key JWKS to verify the token signature.
 * * how to extract JWT token in the request.
 * * how to pass successfully verified token payload.
 *
 * Example:
 *
 * .. code-block:: yaml
 *
 *     issuer: https://example.com
 *     audiences:
 *     - bookstore_android.apps.googleusercontent.com
 *     - bookstore_web.apps.googleusercontent.com
 *     remote_jwks:
 *       http_uri:
 *         uri: https://example.com/.well-known/jwks.json
 *         cluster: example_jwks_cluster
 *       cache_duration:
 *         seconds: 300
 *
 * [#next-free-field: 10]
 * </pre>
 *
 * Protobuf type {@code envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider}
 */
public final class JwtProvider extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)
    JwtProviderOrBuilder {
private static final long serialVersionUID = 0L;
  // Use JwtProvider.newBuilder() to construct.
  private JwtProvider(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private JwtProvider() {
    issuer_ = "";
    audiences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    fromHeaders_ = java.util.Collections.emptyList();
    fromParams_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    forwardPayloadHeader_ = "";
    payloadInMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new JwtProvider();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.ConfigProto.internal_static_envoy_config_filter_http_jwt_authn_v2alpha_JwtProvider_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.ConfigProto.internal_static_envoy_config_filter_http_jwt_authn_v2alpha_JwtProvider_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.class, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.Builder.class);
  }

  private int jwksSourceSpecifierCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object jwksSourceSpecifier_;
  public enum JwksSourceSpecifierCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REMOTE_JWKS(3),
    LOCAL_JWKS(4),
    JWKSSOURCESPECIFIER_NOT_SET(0);
    private final int value;
    private JwksSourceSpecifierCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JwksSourceSpecifierCase valueOf(int value) {
      return forNumber(value);
    }

    public static JwksSourceSpecifierCase forNumber(int value) {
      switch (value) {
        case 3: return REMOTE_JWKS;
        case 4: return LOCAL_JWKS;
        case 0: return JWKSSOURCESPECIFIER_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public JwksSourceSpecifierCase
  getJwksSourceSpecifierCase() {
    return JwksSourceSpecifierCase.forNumber(
        jwksSourceSpecifierCase_);
  }

  public static final int ISSUER_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object issuer_ = "";
  /**
   * <pre>
   * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
   * the JWT, usually a URL or an email address.
   *
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
   * @return The issuer.
   */
  @java.lang.Override
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
   * the JWT, usually a URL or an email address.
   *
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
   * @return The bytes for issuer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCES_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList audiences_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   * @return A list containing the audiences.
   */
  public com.google.protobuf.ProtocolStringList
      getAudiencesList() {
    return audiences_;
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   * @return The count of audiences.
   */
  public int getAudiencesCount() {
    return audiences_.size();
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   * @param index The index of the element to return.
   * @return The audiences at the given index.
   */
  public java.lang.String getAudiences(int index) {
    return audiences_.get(index);
  }
  /**
   * <pre>
   * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
   * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
   * will not check audiences in the token.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>repeated string audiences = 2;</code>
   * @param index The index of the value to return.
   * @return The bytes of the audiences at the given index.
   */
  public com.google.protobuf.ByteString
      getAudiencesBytes(int index) {
    return audiences_.getByteString(index);
  }

  public static final int REMOTE_JWKS_FIELD_NUMBER = 3;
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
   * @return Whether the remoteJwks field is set.
   */
  @java.lang.Override
  public boolean hasRemoteJwks() {
    return jwksSourceSpecifierCase_ == 3;
  }
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
   * @return The remoteJwks.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks getRemoteJwks() {
    if (jwksSourceSpecifierCase_ == 3) {
       return (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
  }
  /**
   * <pre>
   * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
   * URI and how the fetched JWKS should be cached.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *    remote_jwks:
   *      http_uri:
   *        uri: https://www.googleapis.com/oauth2/v1/certs
   *        cluster: jwt.www.googleapis.com|443
   *      cache_duration:
   *        seconds: 300
   * </pre>
   *
   * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwksOrBuilder getRemoteJwksOrBuilder() {
    if (jwksSourceSpecifierCase_ == 3) {
       return (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
  }

  public static final int LOCAL_JWKS_FIELD_NUMBER = 4;
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   *
   * Example: local file
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   *
   * Example: inline_string
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
   * @return Whether the localJwks field is set.
   */
  @java.lang.Override
  public boolean hasLocalJwks() {
    return jwksSourceSpecifierCase_ == 4;
  }
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   *
   * Example: local file
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   *
   * Example: inline_string
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
   * @return The localJwks.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.api.v2.core.DataSource getLocalJwks() {
    if (jwksSourceSpecifierCase_ == 4) {
       return (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
  }
  /**
   * <pre>
   * JWKS is in local data source. It could be either in a local file or embedded in the
   * inline_string.
   *
   * Example: local file
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      filename: /etc/envoy/jwks/jwks1.txt
   *
   * Example: inline_string
   *
   * .. code-block:: yaml
   *
   *    local_jwks:
   *      inline_string: ACADADADADA
   * </pre>
   *
   * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.api.v2.core.DataSourceOrBuilder getLocalJwksOrBuilder() {
    if (jwksSourceSpecifierCase_ == 4) {
       return (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_;
    }
    return io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
  }

  public static final int FORWARD_FIELD_NUMBER = 5;
  private boolean forward_ = false;
  /**
   * <pre>
   * If false, the JWT is removed in the request after a success verification. If true, the JWT is
   * not removed in the request. Default value is false.
   * </pre>
   *
   * <code>bool forward = 5;</code>
   * @return The forward.
   */
  @java.lang.Override
  public boolean getForward() {
    return forward_;
  }

  public static final int FROM_HEADERS_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader> fromHeaders_;
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   *
   * If no explicit location is specified, the following default locations are tried in order:
   *
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *
   *    Authorization: Bearer &lt;token&gt;.
   *
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   *
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   *
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   *
   * .. code-block:: yaml
   *
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   *
   * can be used to extract token from header::
   *
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader> getFromHeadersList() {
    return fromHeaders_;
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   *
   * If no explicit location is specified, the following default locations are tried in order:
   *
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *
   *    Authorization: Bearer &lt;token&gt;.
   *
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   *
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   *
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   *
   * .. code-block:: yaml
   *
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   *
   * can be used to extract token from header::
   *
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder> 
      getFromHeadersOrBuilderList() {
    return fromHeaders_;
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   *
   * If no explicit location is specified, the following default locations are tried in order:
   *
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *
   *    Authorization: Bearer &lt;token&gt;.
   *
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   *
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   *
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   *
   * .. code-block:: yaml
   *
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   *
   * can be used to extract token from header::
   *
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
   */
  @java.lang.Override
  public int getFromHeadersCount() {
    return fromHeaders_.size();
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   *
   * If no explicit location is specified, the following default locations are tried in order:
   *
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *
   *    Authorization: Bearer &lt;token&gt;.
   *
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   *
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   *
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   *
   * .. code-block:: yaml
   *
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   *
   * can be used to extract token from header::
   *
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader getFromHeaders(int index) {
    return fromHeaders_.get(index);
  }
  /**
   * <pre>
   * Two fields below define where to extract the JWT from an HTTP request.
   *
   * If no explicit location is specified, the following default locations are tried in order:
   *
   * 1. The Authorization header using the `Bearer schema
   * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
   *
   *    Authorization: Bearer &lt;token&gt;.
   *
   * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
   *
   * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
   * its provider specified or from the default locations.
   *
   * Specify the HTTP headers to extract JWT token. For examples, following config:
   *
   * .. code-block:: yaml
   *
   *   from_headers:
   *   - name: x-goog-iap-jwt-assertion
   *
   * can be used to extract token from header::
   *
   *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
   * </pre>
   *
   * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder getFromHeadersOrBuilder(
      int index) {
    return fromHeaders_.get(index);
  }

  public static final int FROM_PARAMS_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList fromParams_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   *
   * For example, if config is:
   *
   * .. code-block:: yaml
   *
   *   from_params:
   *   - jwt_token
   *
   * The JWT format in query parameter is::
   *
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   * @return A list containing the fromParams.
   */
  public com.google.protobuf.ProtocolStringList
      getFromParamsList() {
    return fromParams_;
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   *
   * For example, if config is:
   *
   * .. code-block:: yaml
   *
   *   from_params:
   *   - jwt_token
   *
   * The JWT format in query parameter is::
   *
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   * @return The count of fromParams.
   */
  public int getFromParamsCount() {
    return fromParams_.size();
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   *
   * For example, if config is:
   *
   * .. code-block:: yaml
   *
   *   from_params:
   *   - jwt_token
   *
   * The JWT format in query parameter is::
   *
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   * @param index The index of the element to return.
   * @return The fromParams at the given index.
   */
  public java.lang.String getFromParams(int index) {
    return fromParams_.get(index);
  }
  /**
   * <pre>
   * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
   *
   * For example, if config is:
   *
   * .. code-block:: yaml
   *
   *   from_params:
   *   - jwt_token
   *
   * The JWT format in query parameter is::
   *
   *    /path?jwt_token=&lt;JWT&gt;
   * </pre>
   *
   * <code>repeated string from_params = 7;</code>
   * @param index The index of the value to return.
   * @return The bytes of the fromParams at the given index.
   */
  public com.google.protobuf.ByteString
      getFromParamsBytes(int index) {
    return fromParams_.getByteString(index);
  }

  public static final int FORWARD_PAYLOAD_HEADER_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private volatile java.lang.Object forwardPayloadHeader_ = "";
  /**
   * <pre>
   * This field specifies the header name to forward a successfully verified JWT payload to the
   * backend. The forwarded data is::
   *
   *    base64url_encoded(jwt_payload_in_JSON)
   *
   * If it is not specified, the payload will not be forwarded.
   * </pre>
   *
   * <code>string forward_payload_header = 8;</code>
   * @return The forwardPayloadHeader.
   */
  @java.lang.Override
  public java.lang.String getForwardPayloadHeader() {
    java.lang.Object ref = forwardPayloadHeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      forwardPayloadHeader_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * This field specifies the header name to forward a successfully verified JWT payload to the
   * backend. The forwarded data is::
   *
   *    base64url_encoded(jwt_payload_in_JSON)
   *
   * If it is not specified, the payload will not be forwarded.
   * </pre>
   *
   * <code>string forward_payload_header = 8;</code>
   * @return The bytes for forwardPayloadHeader.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getForwardPayloadHeaderBytes() {
    java.lang.Object ref = forwardPayloadHeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      forwardPayloadHeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOAD_IN_METADATA_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object payloadInMetadata_ = "";
  /**
   * <pre>
   * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
   * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
   * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
   * and the value is the *protobuf::Struct* converted from JWT JSON payload.
   *
   * For example, if payload_in_metadata is *my_payload*:
   *
   * .. code-block:: yaml
   *
   *   envoy.filters.http.jwt_authn:
   *     my_payload:
   *       iss: https://example.com
   *       sub: test&#64;example.com
   *       aud: https://example.com
   *       exp: 1501281058
   * </pre>
   *
   * <code>string payload_in_metadata = 9;</code>
   * @return The payloadInMetadata.
   */
  @java.lang.Override
  public java.lang.String getPayloadInMetadata() {
    java.lang.Object ref = payloadInMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      payloadInMetadata_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
   * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
   * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
   * and the value is the *protobuf::Struct* converted from JWT JSON payload.
   *
   * For example, if payload_in_metadata is *my_payload*:
   *
   * .. code-block:: yaml
   *
   *   envoy.filters.http.jwt_authn:
   *     my_payload:
   *       iss: https://example.com
   *       sub: test&#64;example.com
   *       aud: https://example.com
   *       exp: 1501281058
   * </pre>
   *
   * <code>string payload_in_metadata = 9;</code>
   * @return The bytes for payloadInMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPayloadInMetadataBytes() {
    java.lang.Object ref = payloadInMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      payloadInMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issuer_);
    }
    for (int i = 0; i < audiences_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audiences_.getRaw(i));
    }
    if (jwksSourceSpecifierCase_ == 3) {
      output.writeMessage(3, (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_);
    }
    if (jwksSourceSpecifierCase_ == 4) {
      output.writeMessage(4, (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_);
    }
    if (forward_ != false) {
      output.writeBool(5, forward_);
    }
    for (int i = 0; i < fromHeaders_.size(); i++) {
      output.writeMessage(6, fromHeaders_.get(i));
    }
    for (int i = 0; i < fromParams_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, fromParams_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(forwardPayloadHeader_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, forwardPayloadHeader_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payloadInMetadata_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, payloadInMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issuer_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < audiences_.size(); i++) {
        dataSize += computeStringSizeNoTag(audiences_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAudiencesList().size();
    }
    if (jwksSourceSpecifierCase_ == 3) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_);
    }
    if (jwksSourceSpecifierCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_);
    }
    if (forward_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, forward_);
    }
    for (int i = 0; i < fromHeaders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, fromHeaders_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fromParams_.size(); i++) {
        dataSize += computeStringSizeNoTag(fromParams_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFromParamsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(forwardPayloadHeader_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, forwardPayloadHeader_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payloadInMetadata_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, payloadInMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider other = (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider) obj;

    if (!getIssuer()
        .equals(other.getIssuer())) return false;
    if (!getAudiencesList()
        .equals(other.getAudiencesList())) return false;
    if (getForward()
        != other.getForward()) return false;
    if (!getFromHeadersList()
        .equals(other.getFromHeadersList())) return false;
    if (!getFromParamsList()
        .equals(other.getFromParamsList())) return false;
    if (!getForwardPayloadHeader()
        .equals(other.getForwardPayloadHeader())) return false;
    if (!getPayloadInMetadata()
        .equals(other.getPayloadInMetadata())) return false;
    if (!getJwksSourceSpecifierCase().equals(other.getJwksSourceSpecifierCase())) return false;
    switch (jwksSourceSpecifierCase_) {
      case 3:
        if (!getRemoteJwks()
            .equals(other.getRemoteJwks())) return false;
        break;
      case 4:
        if (!getLocalJwks()
            .equals(other.getLocalJwks())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    if (getAudiencesCount() > 0) {
      hash = (37 * hash) + AUDIENCES_FIELD_NUMBER;
      hash = (53 * hash) + getAudiencesList().hashCode();
    }
    hash = (37 * hash) + FORWARD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getForward());
    if (getFromHeadersCount() > 0) {
      hash = (37 * hash) + FROM_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getFromHeadersList().hashCode();
    }
    if (getFromParamsCount() > 0) {
      hash = (37 * hash) + FROM_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getFromParamsList().hashCode();
    }
    hash = (37 * hash) + FORWARD_PAYLOAD_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + getForwardPayloadHeader().hashCode();
    hash = (37 * hash) + PAYLOAD_IN_METADATA_FIELD_NUMBER;
    hash = (53 * hash) + getPayloadInMetadata().hashCode();
    switch (jwksSourceSpecifierCase_) {
      case 3:
        hash = (37 * hash) + REMOTE_JWKS_FIELD_NUMBER;
        hash = (53 * hash) + getRemoteJwks().hashCode();
        break;
      case 4:
        hash = (37 * hash) + LOCAL_JWKS_FIELD_NUMBER;
        hash = (53 * hash) + getLocalJwks().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Please see following for JWT authentication flow:
   *
   * * `JSON Web Token (JWT) &lt;https://tools.ietf.org/html/rfc7519&gt;`_
   * * `The OAuth 2.0 Authorization Framework &lt;https://tools.ietf.org/html/rfc6749&gt;`_
   * * `OpenID Connect &lt;http://openid.net/connect&gt;`_
   *
   * A JwtProvider message specifies how a JSON Web Token (JWT) can be verified. It specifies:
   *
   * * issuer: the principal that issues the JWT. It has to match the one from the token.
   * * allowed audiences: the ones in the token have to be listed here.
   * * how to fetch public key JWKS to verify the token signature.
   * * how to extract JWT token in the request.
   * * how to pass successfully verified token payload.
   *
   * Example:
   *
   * .. code-block:: yaml
   *
   *     issuer: https://example.com
   *     audiences:
   *     - bookstore_android.apps.googleusercontent.com
   *     - bookstore_web.apps.googleusercontent.com
   *     remote_jwks:
   *       http_uri:
   *         uri: https://example.com/.well-known/jwks.json
   *         cluster: example_jwks_cluster
   *       cache_duration:
   *         seconds: 300
   *
   * [#next-free-field: 10]
   * </pre>
   *
   * Protobuf type {@code envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)
      io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProviderOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.ConfigProto.internal_static_envoy_config_filter_http_jwt_authn_v2alpha_JwtProvider_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.ConfigProto.internal_static_envoy_config_filter_http_jwt_authn_v2alpha_JwtProvider_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.class, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      issuer_ = "";
      audiences_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      if (remoteJwksBuilder_ != null) {
        remoteJwksBuilder_.clear();
      }
      if (localJwksBuilder_ != null) {
        localJwksBuilder_.clear();
      }
      forward_ = false;
      if (fromHeadersBuilder_ == null) {
        fromHeaders_ = java.util.Collections.emptyList();
      } else {
        fromHeaders_ = null;
        fromHeadersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      fromParams_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      forwardPayloadHeader_ = "";
      payloadInMetadata_ = "";
      jwksSourceSpecifierCase_ = 0;
      jwksSourceSpecifier_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.ConfigProto.internal_static_envoy_config_filter_http_jwt_authn_v2alpha_JwtProvider_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider build() {
      io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider buildPartial() {
      io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider result = new io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider result) {
      if (fromHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          fromHeaders_ = java.util.Collections.unmodifiableList(fromHeaders_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.fromHeaders_ = fromHeaders_;
      } else {
        result.fromHeaders_ = fromHeadersBuilder_.build();
      }
    }

    private void buildPartial0(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.issuer_ = issuer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        audiences_.makeImmutable();
        result.audiences_ = audiences_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.forward_ = forward_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        fromParams_.makeImmutable();
        result.fromParams_ = fromParams_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.forwardPayloadHeader_ = forwardPayloadHeader_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.payloadInMetadata_ = payloadInMetadata_;
      }
    }

    private void buildPartialOneofs(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider result) {
      result.jwksSourceSpecifierCase_ = jwksSourceSpecifierCase_;
      result.jwksSourceSpecifier_ = this.jwksSourceSpecifier_;
      if (jwksSourceSpecifierCase_ == 3 &&
          remoteJwksBuilder_ != null) {
        result.jwksSourceSpecifier_ = remoteJwksBuilder_.build();
      }
      if (jwksSourceSpecifierCase_ == 4 &&
          localJwksBuilder_ != null) {
        result.jwksSourceSpecifier_ = localJwksBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider) {
        return mergeFrom((io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider other) {
      if (other == io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider.getDefaultInstance()) return this;
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.audiences_.isEmpty()) {
        if (audiences_.isEmpty()) {
          audiences_ = other.audiences_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAudiencesIsMutable();
          audiences_.addAll(other.audiences_);
        }
        onChanged();
      }
      if (other.getForward() != false) {
        setForward(other.getForward());
      }
      if (fromHeadersBuilder_ == null) {
        if (!other.fromHeaders_.isEmpty()) {
          if (fromHeaders_.isEmpty()) {
            fromHeaders_ = other.fromHeaders_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureFromHeadersIsMutable();
            fromHeaders_.addAll(other.fromHeaders_);
          }
          onChanged();
        }
      } else {
        if (!other.fromHeaders_.isEmpty()) {
          if (fromHeadersBuilder_.isEmpty()) {
            fromHeadersBuilder_.dispose();
            fromHeadersBuilder_ = null;
            fromHeaders_ = other.fromHeaders_;
            bitField0_ = (bitField0_ & ~0x00000020);
            fromHeadersBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getFromHeadersFieldBuilder() : null;
          } else {
            fromHeadersBuilder_.addAllMessages(other.fromHeaders_);
          }
        }
      }
      if (!other.fromParams_.isEmpty()) {
        if (fromParams_.isEmpty()) {
          fromParams_ = other.fromParams_;
          bitField0_ |= 0x00000040;
        } else {
          ensureFromParamsIsMutable();
          fromParams_.addAll(other.fromParams_);
        }
        onChanged();
      }
      if (!other.getForwardPayloadHeader().isEmpty()) {
        forwardPayloadHeader_ = other.forwardPayloadHeader_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getPayloadInMetadata().isEmpty()) {
        payloadInMetadata_ = other.payloadInMetadata_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      switch (other.getJwksSourceSpecifierCase()) {
        case REMOTE_JWKS: {
          mergeRemoteJwks(other.getRemoteJwks());
          break;
        }
        case LOCAL_JWKS: {
          mergeLocalJwks(other.getLocalJwks());
          break;
        }
        case JWKSSOURCESPECIFIER_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              issuer_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureAudiencesIsMutable();
              audiences_.add(s);
              break;
            } // case 18
            case 26: {
              input.readMessage(
                  getRemoteJwksFieldBuilder().getBuilder(),
                  extensionRegistry);
              jwksSourceSpecifierCase_ = 3;
              break;
            } // case 26
            case 34: {
              input.readMessage(
                  getLocalJwksFieldBuilder().getBuilder(),
                  extensionRegistry);
              jwksSourceSpecifierCase_ = 4;
              break;
            } // case 34
            case 40: {
              forward_ = input.readBool();
              bitField0_ |= 0x00000010;
              break;
            } // case 40
            case 50: {
              io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.parser(),
                      extensionRegistry);
              if (fromHeadersBuilder_ == null) {
                ensureFromHeadersIsMutable();
                fromHeaders_.add(m);
              } else {
                fromHeadersBuilder_.addMessage(m);
              }
              break;
            } // case 50
            case 58: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureFromParamsIsMutable();
              fromParams_.add(s);
              break;
            } // case 58
            case 66: {
              forwardPayloadHeader_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 66
            case 74: {
              payloadInMetadata_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 74
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int jwksSourceSpecifierCase_ = 0;
    private java.lang.Object jwksSourceSpecifier_;
    public JwksSourceSpecifierCase
        getJwksSourceSpecifierCase() {
      return JwksSourceSpecifierCase.forNumber(
          jwksSourceSpecifierCase_);
    }

    public Builder clearJwksSourceSpecifier() {
      jwksSourceSpecifierCase_ = 0;
      jwksSourceSpecifier_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object issuer_ = "";
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     * @return The issuer.
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for issuer.
     */
    public com.google.protobuf.ByteString
        getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     * @param value The issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuer(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearIssuer() {
      issuer_ = getDefaultInstance().getIssuer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify the `principal &lt;https://tools.ietf.org/html/rfc7519#section-4.1.1&gt;`_ that issued
     * the JWT, usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 1 [(.validate.rules) = { ... }</code>
     * @param value The bytes for issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuerBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList audiences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureAudiencesIsMutable() {
      if (!audiences_.isModifiable()) {
        audiences_ = new com.google.protobuf.LazyStringArrayList(audiences_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @return A list containing the audiences.
     */
    public com.google.protobuf.ProtocolStringList
        getAudiencesList() {
      audiences_.makeImmutable();
      return audiences_;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @return The count of audiences.
     */
    public int getAudiencesCount() {
      return audiences_.size();
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param index The index of the element to return.
     * @return The audiences at the given index.
     */
    public java.lang.String getAudiences(int index) {
      return audiences_.get(index);
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the audiences at the given index.
     */
    public com.google.protobuf.ByteString
        getAudiencesBytes(int index) {
      return audiences_.getByteString(index);
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param index The index to set the value at.
     * @param value The audiences to set.
     * @return This builder for chaining.
     */
    public Builder setAudiences(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureAudiencesIsMutable();
      audiences_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param value The audiences to add.
     * @return This builder for chaining.
     */
    public Builder addAudiences(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureAudiencesIsMutable();
      audiences_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param values The audiences to add.
     * @return This builder for chaining.
     */
    public Builder addAllAudiences(
        java.lang.Iterable<java.lang.String> values) {
      ensureAudiencesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, audiences_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearAudiences() {
      audiences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of JWT `audiences &lt;https://tools.ietf.org/html/rfc7519#section-4.1.3&gt;`_ are
     * allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
     * will not check audiences in the token.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *     audiences:
     *     - bookstore_android.apps.googleusercontent.com
     *     - bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>repeated string audiences = 2;</code>
     * @param value The bytes of the audiences to add.
     * @return This builder for chaining.
     */
    public Builder addAudiencesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureAudiencesIsMutable();
      audiences_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwksOrBuilder> remoteJwksBuilder_;
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     * @return Whether the remoteJwks field is set.
     */
    @java.lang.Override
    public boolean hasRemoteJwks() {
      return jwksSourceSpecifierCase_ == 3;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     * @return The remoteJwks.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks getRemoteJwks() {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3) {
          return (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          return remoteJwksBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder setRemoteJwks(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks value) {
      if (remoteJwksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jwksSourceSpecifier_ = value;
        onChanged();
      } else {
        remoteJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder setRemoteJwks(
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.Builder builderForValue) {
      if (remoteJwksBuilder_ == null) {
        jwksSourceSpecifier_ = builderForValue.build();
        onChanged();
      } else {
        remoteJwksBuilder_.setMessage(builderForValue.build());
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder mergeRemoteJwks(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks value) {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3 &&
            jwksSourceSpecifier_ != io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance()) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.newBuilder((io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_)
              .mergeFrom(value).buildPartial();
        } else {
          jwksSourceSpecifier_ = value;
        }
        onChanged();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          remoteJwksBuilder_.mergeFrom(value);
        } else {
          remoteJwksBuilder_.setMessage(value);
        }
      }
      jwksSourceSpecifierCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    public Builder clearRemoteJwks() {
      if (remoteJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 3) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
          onChanged();
        }
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
        }
        remoteJwksBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.Builder getRemoteJwksBuilder() {
      return getRemoteJwksFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwksOrBuilder getRemoteJwksOrBuilder() {
      if ((jwksSourceSpecifierCase_ == 3) && (remoteJwksBuilder_ != null)) {
        return remoteJwksBuilder_.getMessageOrBuilder();
      } else {
        if (jwksSourceSpecifierCase_ == 3) {
          return (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS can be fetched from remote server via HTTP/HTTPS. This field specifies the remote HTTP
     * URI and how the fetched JWKS should be cached.
     *
     * Example:
     *
     * .. code-block:: yaml
     *
     *    remote_jwks:
     *      http_uri:
     *        uri: https://www.googleapis.com/oauth2/v1/certs
     *        cluster: jwt.www.googleapis.com|443
     *      cache_duration:
     *        seconds: 300
     * </pre>
     *
     * <code>.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks remote_jwks = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwksOrBuilder> 
        getRemoteJwksFieldBuilder() {
      if (remoteJwksBuilder_ == null) {
        if (!(jwksSourceSpecifierCase_ == 3)) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.getDefaultInstance();
        }
        remoteJwksBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwksOrBuilder>(
                (io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks) jwksSourceSpecifier_,
                getParentForChildren(),
                isClean());
        jwksSourceSpecifier_ = null;
      }
      jwksSourceSpecifierCase_ = 3;
      onChanged();
      return remoteJwksBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.api.v2.core.DataSource, io.envoyproxy.envoy.api.v2.core.DataSource.Builder, io.envoyproxy.envoy.api.v2.core.DataSourceOrBuilder> localJwksBuilder_;
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     * @return Whether the localJwks field is set.
     */
    @java.lang.Override
    public boolean hasLocalJwks() {
      return jwksSourceSpecifierCase_ == 4;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     * @return The localJwks.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.core.DataSource getLocalJwks() {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4) {
          return (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          return localJwksBuilder_.getMessage();
        }
        return io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    public Builder setLocalJwks(io.envoyproxy.envoy.api.v2.core.DataSource value) {
      if (localJwksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jwksSourceSpecifier_ = value;
        onChanged();
      } else {
        localJwksBuilder_.setMessage(value);
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    public Builder setLocalJwks(
        io.envoyproxy.envoy.api.v2.core.DataSource.Builder builderForValue) {
      if (localJwksBuilder_ == null) {
        jwksSourceSpecifier_ = builderForValue.build();
        onChanged();
      } else {
        localJwksBuilder_.setMessage(builderForValue.build());
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    public Builder mergeLocalJwks(io.envoyproxy.envoy.api.v2.core.DataSource value) {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4 &&
            jwksSourceSpecifier_ != io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance()) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.api.v2.core.DataSource.newBuilder((io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_)
              .mergeFrom(value).buildPartial();
        } else {
          jwksSourceSpecifier_ = value;
        }
        onChanged();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          localJwksBuilder_.mergeFrom(value);
        } else {
          localJwksBuilder_.setMessage(value);
        }
      }
      jwksSourceSpecifierCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    public Builder clearLocalJwks() {
      if (localJwksBuilder_ == null) {
        if (jwksSourceSpecifierCase_ == 4) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
          onChanged();
        }
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          jwksSourceSpecifierCase_ = 0;
          jwksSourceSpecifier_ = null;
        }
        localJwksBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    public io.envoyproxy.envoy.api.v2.core.DataSource.Builder getLocalJwksBuilder() {
      return getLocalJwksFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.api.v2.core.DataSourceOrBuilder getLocalJwksOrBuilder() {
      if ((jwksSourceSpecifierCase_ == 4) && (localJwksBuilder_ != null)) {
        return localJwksBuilder_.getMessageOrBuilder();
      } else {
        if (jwksSourceSpecifierCase_ == 4) {
          return (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_;
        }
        return io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * JWKS is in local data source. It could be either in a local file or embedded in the
     * inline_string.
     *
     * Example: local file
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      filename: /etc/envoy/jwks/jwks1.txt
     *
     * Example: inline_string
     *
     * .. code-block:: yaml
     *
     *    local_jwks:
     *      inline_string: ACADADADADA
     * </pre>
     *
     * <code>.envoy.api.v2.core.DataSource local_jwks = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.api.v2.core.DataSource, io.envoyproxy.envoy.api.v2.core.DataSource.Builder, io.envoyproxy.envoy.api.v2.core.DataSourceOrBuilder> 
        getLocalJwksFieldBuilder() {
      if (localJwksBuilder_ == null) {
        if (!(jwksSourceSpecifierCase_ == 4)) {
          jwksSourceSpecifier_ = io.envoyproxy.envoy.api.v2.core.DataSource.getDefaultInstance();
        }
        localJwksBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.api.v2.core.DataSource, io.envoyproxy.envoy.api.v2.core.DataSource.Builder, io.envoyproxy.envoy.api.v2.core.DataSourceOrBuilder>(
                (io.envoyproxy.envoy.api.v2.core.DataSource) jwksSourceSpecifier_,
                getParentForChildren(),
                isClean());
        jwksSourceSpecifier_ = null;
      }
      jwksSourceSpecifierCase_ = 4;
      onChanged();
      return localJwksBuilder_;
    }

    private boolean forward_ ;
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     * @return The forward.
     */
    @java.lang.Override
    public boolean getForward() {
      return forward_;
    }
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     * @param value The forward to set.
     * @return This builder for chaining.
     */
    public Builder setForward(boolean value) {

      forward_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If false, the JWT is removed in the request after a success verification. If true, the JWT is
     * not removed in the request. Default value is false.
     * </pre>
     *
     * <code>bool forward = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearForward() {
      bitField0_ = (bitField0_ & ~0x00000010);
      forward_ = false;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader> fromHeaders_ =
      java.util.Collections.emptyList();
    private void ensureFromHeadersIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        fromHeaders_ = new java.util.ArrayList<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader>(fromHeaders_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder> fromHeadersBuilder_;

    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader> getFromHeadersList() {
      if (fromHeadersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fromHeaders_);
      } else {
        return fromHeadersBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public int getFromHeadersCount() {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.size();
      } else {
        return fromHeadersBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader getFromHeaders(int index) {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.get(index);
      } else {
        return fromHeadersBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder setFromHeaders(
        int index, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.set(index, value);
        onChanged();
      } else {
        fromHeadersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder setFromHeaders(
        int index, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.set(index, builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.add(value);
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        int index, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader value) {
      if (fromHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFromHeadersIsMutable();
        fromHeaders_.add(index, value);
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.add(builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder addFromHeaders(
        int index, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder builderForValue) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.add(index, builderForValue.build());
        onChanged();
      } else {
        fromHeadersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder addAllFromHeaders(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader> values) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, fromHeaders_);
        onChanged();
      } else {
        fromHeadersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder clearFromHeaders() {
      if (fromHeadersBuilder_ == null) {
        fromHeaders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        fromHeadersBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public Builder removeFromHeaders(int index) {
      if (fromHeadersBuilder_ == null) {
        ensureFromHeadersIsMutable();
        fromHeaders_.remove(index);
        onChanged();
      } else {
        fromHeadersBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder getFromHeadersBuilder(
        int index) {
      return getFromHeadersFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder getFromHeadersOrBuilder(
        int index) {
      if (fromHeadersBuilder_ == null) {
        return fromHeaders_.get(index);  } else {
        return fromHeadersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder> 
         getFromHeadersOrBuilderList() {
      if (fromHeadersBuilder_ != null) {
        return fromHeadersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fromHeaders_);
      }
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder addFromHeadersBuilder() {
      return getFromHeadersFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.getDefaultInstance());
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder addFromHeadersBuilder(
        int index) {
      return getFromHeadersFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.getDefaultInstance());
    }
    /**
     * <pre>
     * Two fields below define where to extract the JWT from an HTTP request.
     *
     * If no explicit location is specified, the following default locations are tried in order:
     *
     * 1. The Authorization header using the `Bearer schema
     * &lt;https://tools.ietf.org/html/rfc6750#section-2.1&gt;`_. Example::
     *
     *    Authorization: Bearer &lt;token&gt;.
     *
     * 2. `access_token &lt;https://tools.ietf.org/html/rfc6750#section-2.3&gt;`_ query parameter.
     *
     * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations
     * its provider specified or from the default locations.
     *
     * Specify the HTTP headers to extract JWT token. For examples, following config:
     *
     * .. code-block:: yaml
     *
     *   from_headers:
     *   - name: x-goog-iap-jwt-assertion
     *
     * can be used to extract token from header::
     *
     *   ``x-goog-iap-jwt-assertion: &lt;JWT&gt;``.
     * </pre>
     *
     * <code>repeated .envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader from_headers = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder> 
         getFromHeadersBuilderList() {
      return getFromHeadersFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder> 
        getFromHeadersFieldBuilder() {
      if (fromHeadersBuilder_ == null) {
        fromHeadersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader.Builder, io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtHeaderOrBuilder>(
                fromHeaders_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        fromHeaders_ = null;
      }
      return fromHeadersBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList fromParams_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFromParamsIsMutable() {
      if (!fromParams_.isModifiable()) {
        fromParams_ = new com.google.protobuf.LazyStringArrayList(fromParams_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @return A list containing the fromParams.
     */
    public com.google.protobuf.ProtocolStringList
        getFromParamsList() {
      fromParams_.makeImmutable();
      return fromParams_;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @return The count of fromParams.
     */
    public int getFromParamsCount() {
      return fromParams_.size();
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param index The index of the element to return.
     * @return The fromParams at the given index.
     */
    public java.lang.String getFromParams(int index) {
      return fromParams_.get(index);
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param index The index of the value to return.
     * @return The bytes of the fromParams at the given index.
     */
    public com.google.protobuf.ByteString
        getFromParamsBytes(int index) {
      return fromParams_.getByteString(index);
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param index The index to set the value at.
     * @param value The fromParams to set.
     * @return This builder for chaining.
     */
    public Builder setFromParams(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFromParamsIsMutable();
      fromParams_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param value The fromParams to add.
     * @return This builder for chaining.
     */
    public Builder addFromParams(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFromParamsIsMutable();
      fromParams_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param values The fromParams to add.
     * @return This builder for chaining.
     */
    public Builder addAllFromParams(
        java.lang.Iterable<java.lang.String> values) {
      ensureFromParamsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, fromParams_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearFromParams() {
      fromParams_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
     *
     * For example, if config is:
     *
     * .. code-block:: yaml
     *
     *   from_params:
     *   - jwt_token
     *
     * The JWT format in query parameter is::
     *
     *    /path?jwt_token=&lt;JWT&gt;
     * </pre>
     *
     * <code>repeated string from_params = 7;</code>
     * @param value The bytes of the fromParams to add.
     * @return This builder for chaining.
     */
    public Builder addFromParamsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureFromParamsIsMutable();
      fromParams_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object forwardPayloadHeader_ = "";
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *
     *    base64url_encoded(jwt_payload_in_JSON)
     *
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8;</code>
     * @return The forwardPayloadHeader.
     */
    public java.lang.String getForwardPayloadHeader() {
      java.lang.Object ref = forwardPayloadHeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        forwardPayloadHeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *
     *    base64url_encoded(jwt_payload_in_JSON)
     *
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8;</code>
     * @return The bytes for forwardPayloadHeader.
     */
    public com.google.protobuf.ByteString
        getForwardPayloadHeaderBytes() {
      java.lang.Object ref = forwardPayloadHeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        forwardPayloadHeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *
     *    base64url_encoded(jwt_payload_in_JSON)
     *
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8;</code>
     * @param value The forwardPayloadHeader to set.
     * @return This builder for chaining.
     */
    public Builder setForwardPayloadHeader(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      forwardPayloadHeader_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *
     *    base64url_encoded(jwt_payload_in_JSON)
     *
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearForwardPayloadHeader() {
      forwardPayloadHeader_ = getDefaultInstance().getForwardPayloadHeader();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field specifies the header name to forward a successfully verified JWT payload to the
     * backend. The forwarded data is::
     *
     *    base64url_encoded(jwt_payload_in_JSON)
     *
     * If it is not specified, the payload will not be forwarded.
     * </pre>
     *
     * <code>string forward_payload_header = 8;</code>
     * @param value The bytes for forwardPayloadHeader to set.
     * @return This builder for chaining.
     */
    public Builder setForwardPayloadHeaderBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      forwardPayloadHeader_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object payloadInMetadata_ = "";
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     *
     * For example, if payload_in_metadata is *my_payload*:
     *
     * .. code-block:: yaml
     *
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     * @return The payloadInMetadata.
     */
    public java.lang.String getPayloadInMetadata() {
      java.lang.Object ref = payloadInMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payloadInMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     *
     * For example, if payload_in_metadata is *my_payload*:
     *
     * .. code-block:: yaml
     *
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     * @return The bytes for payloadInMetadata.
     */
    public com.google.protobuf.ByteString
        getPayloadInMetadataBytes() {
      java.lang.Object ref = payloadInMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        payloadInMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     *
     * For example, if payload_in_metadata is *my_payload*:
     *
     * .. code-block:: yaml
     *
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     * @param value The payloadInMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadInMetadata(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      payloadInMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     *
     * For example, if payload_in_metadata is *my_payload*:
     *
     * .. code-block:: yaml
     *
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearPayloadInMetadata() {
      payloadInMetadata_ = getDefaultInstance().getPayloadInMetadata();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non empty, successfully verified JWT payloads will be written to StreamInfo DynamicMetadata
     * in the format as: *namespace* is the jwt_authn filter name as **envoy.filters.http.jwt_authn**
     * The value is the *protobuf::Struct*. The value of this field will be the key for its *fields*
     * and the value is the *protobuf::Struct* converted from JWT JSON payload.
     *
     * For example, if payload_in_metadata is *my_payload*:
     *
     * .. code-block:: yaml
     *
     *   envoy.filters.http.jwt_authn:
     *     my_payload:
     *       iss: https://example.com
     *       sub: test&#64;example.com
     *       aud: https://example.com
     *       exp: 1501281058
     * </pre>
     *
     * <code>string payload_in_metadata = 9;</code>
     * @param value The bytes for payloadInMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadInMetadataBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      payloadInMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider)
  private static final io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider();
  }

  public static io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JwtProvider>
      PARSER = new com.google.protobuf.AbstractParser<JwtProvider>() {
    @java.lang.Override
    public JwtProvider parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<JwtProvider> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JwtProvider> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.filter.http.jwt_authn.v2alpha.JwtProvider getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

