/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class CRDUtils {
    private CRDUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static SpecAndStatus resolveSpecAndStatusTypes(Class<?> definition) {
        SerializationConfig config = new ObjectMapper().getSerializationConfig();
        BeanDescription description = config.introspect(config.constructType(definition));
        String specClassName = null;
        String statusClassName = null;
        for (BeanPropertyDefinition bpd : description.findProperties()) {
            if (bpd.getName().equals("spec") && bpd.getRawPrimaryType() != Void.class) {
                specClassName = bpd.getRawPrimaryType().getName();
                continue;
            }
            if (!bpd.getName().equals("status") || bpd.getRawPrimaryType() == Void.class) continue;
            statusClassName = bpd.getRawPrimaryType().getName();
        }
        return new SpecAndStatus(specClassName, statusClassName);
    }

    public static Map<String, String> toMap(String[] arr) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (arr != null) {
            for (String e : arr) {
                String[] splitted = e.split("=");
                if (splitted.length < 2) {
                    throw new IllegalArgumentException("Invalid value: " + e + " cannot be parsed as a key-value pair. Expected format is 'key=value'.");
                }
                res.put(splitted[0], e.substring(splitted[0].length() + 1));
            }
        }
        return res;
    }

    static Object toTargetType(JavaType type, String value) {
        if (type == null || value == null) {
            return null;
        }
        try {
            if (Number.class.isAssignableFrom(type.getRawClass()) || Integer.TYPE.isAssignableFrom(type.getRawClass()) || Long.TYPE.isAssignableFrom(type.getRawClass()) || Float.TYPE.isAssignableFrom(type.getRawClass()) || Double.TYPE.isAssignableFrom(type.getRawClass())) {
                return NumberFormat.getInstance().parse(value);
            }
            if (Boolean.class.isAssignableFrom(type.getRawClass()) || Boolean.TYPE.isAssignableFrom(type.getRawClass())) {
                return Boolean.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static class SpecAndStatus {
        private final String specClassName;
        private final String statusClassName;
        private final boolean unreliable;

        public SpecAndStatus(String specClassName, String statusClassName) {
            this.specClassName = specClassName;
            this.statusClassName = statusClassName;
            this.unreliable = specClassName == null || statusClassName == null;
        }

        public String getSpecClassName() {
            return this.specClassName;
        }

        public String getStatusClassName() {
            return this.statusClassName;
        }

        public boolean isUnreliable() {
            return this.unreliable;
        }
    }
}

