/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler;

import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

@Component(role=ImageConfigResolver.class, instantiationStrategy="per-lookup")
public class ImageConfigResolver
implements Initializable {
    private Map<String, ExternalConfigHandler> registry;
    @Requirement(role=ExternalConfigHandler.class)
    private List<ExternalConfigHandler> handlers;

    public void initialize() throws InitializationException {
        this.registry = new HashMap<String, ExternalConfigHandler>();
        if (this.handlers != null) {
            for (ExternalConfigHandler handler : this.handlers) {
                this.registry.put(handler.getType(), handler);
            }
        }
    }

    public List<ImageConfiguration> resolve(ImageConfiguration unresolvedConfig, Properties properties) {
        Map<String, String> referenceConfig = unresolvedConfig.getExternalConfig();
        if (referenceConfig != null) {
            String type = referenceConfig.get("type");
            if (type == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No config type given");
            }
            ExternalConfigHandler handler = this.registry.get(type);
            if (handler == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No handler for type " + type + " given");
            }
            return handler.resolve(unresolvedConfig, properties);
        }
        return Collections.singletonList(unresolvedConfig);
    }
}

