/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc.http;

import io.fabric8.maven.docker.access.KeyStoreUtil;
import io.fabric8.maven.docker.access.hc.util.ClientBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class HttpClientBuilder
implements ClientBuilder {
    private final String certPath;
    private final int maxConnections;

    public HttpClientBuilder(String certPath, int maxConnections) {
        this.certPath = certPath;
        this.maxConnections = maxConnections;
    }

    @Override
    public CloseableHttpClient buildPooledClient() throws IOException {
        org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager manager = HttpClientBuilder.getPooledConnectionFactory(this.certPath, this.maxConnections);
        builder.setConnectionManager(manager);
        return builder.build();
    }

    @Override
    public CloseableHttpClient buildBasicClient() throws IOException {
        return HttpClients.custom().setConnectionManager(HttpClientBuilder.getBasicConnectionFactory(this.certPath)).build();
    }

    private static HttpClientConnectionManager getPooledConnectionFactory(String certPath, int maxConnections) throws IOException {
        PoolingHttpClientConnectionManager ret = certPath != null ? new PoolingHttpClientConnectionManager(HttpClientBuilder.getSslFactoryRegistry(certPath)) : new PoolingHttpClientConnectionManager();
        ret.setDefaultMaxPerRoute(maxConnections);
        ret.setMaxTotal(maxConnections);
        return ret;
    }

    private static HttpClientConnectionManager getBasicConnectionFactory(String certPath) throws IOException {
        return certPath != null ? new BasicHttpClientConnectionManager(HttpClientBuilder.getSslFactoryRegistry(certPath)) : new BasicHttpClientConnectionManager();
    }

    private static Registry<ConnectionSocketFactory> getSslFactoryRegistry(String certPath) throws IOException {
        try {
            KeyStore keyStore = KeyStoreUtil.createDockerKeyStore(certPath);
            SSLContext sslContext = SSLContexts.custom().useProtocol("TLS").loadKeyMaterial(keyStore, "docker".toCharArray()).loadTrustMaterial(keyStore, null).build();
            String tlsVerify = System.getenv("DOCKER_TLS_VERIFY");
            SSLConnectionSocketFactory sslsf = tlsVerify != null && !tlsVerify.equals("0") && !tlsVerify.equals("false") ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return RegistryBuilder.create().register("https", (Object)sslsf).build();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

