/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="save")
public class SaveMojo
extends AbstractDockerMojo {
    private static final ArchiveCompression STANDARD_ARCHIVE_COMPRESSION = ArchiveCompression.gzip;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="docker.save.name")
    private String saveName;
    @Parameter(property="docker.save.alias")
    private String saveAlias;
    @Parameter
    private String saveFile;
    @Parameter(property="docker.skip.save", defaultValue="false")
    private boolean skipSave;

    @Override
    protected void executeInternal(ServiceHub serviceHub) throws DockerAccessException, MojoExecutionException {
        if (this.skipSave) {
            return;
        }
        String imageName = this.getImageName();
        String fileName = this.getFileName(imageName);
        this.log.info("Saving image %s to %s", imageName, fileName);
        if (!serviceHub.getQueryService().hasImage(imageName)) {
            throw new MojoExecutionException("No image " + imageName + " exists");
        }
        serviceHub.getDockerAccess().saveImage(imageName, fileName, ArchiveCompression.fromFileName(fileName));
    }

    private String getFileName(String iName) throws MojoExecutionException {
        String configuredFileName = this.getConfiguredFileName();
        if (configuredFileName != null) {
            return configuredFileName;
        }
        if (this.saveAlias != null) {
            return this.completeCalculatedFileName(this.saveAlias + "-" + this.project.getVersion() + "." + STANDARD_ARCHIVE_COMPRESSION.getFileSuffix());
        }
        ImageName imageName = new ImageName(iName);
        return this.completeCalculatedFileName(imageName.getSimpleName() + "-" + imageName.getTag()) + "." + STANDARD_ARCHIVE_COMPRESSION.getFileSuffix();
    }

    private String getConfiguredFileName() {
        Properties[] propsList = new Properties[]{System.getProperties(), this.project.getProperties()};
        for (String key : new String[]{"docker.save.file", "docker.file", "file"}) {
            for (Properties props : propsList) {
                if (!props.containsKey(key)) continue;
                return props.getProperty(key);
            }
        }
        return this.saveFile;
    }

    private String completeCalculatedFileName(String file) throws MojoExecutionException {
        this.ensureBuildDir();
        return this.project.getBuild().getDirectory() + "/" + file.replace("/", "-");
    }

    private void ensureBuildDir() throws MojoExecutionException {
        File buildDir = new File(this.project.getBuild().getDirectory());
        if (!buildDir.exists() && !buildDir.mkdirs()) {
            throw new MojoExecutionException("Can not create directory " + buildDir + " for storing save file");
        }
    }

    private String getImageName() throws MojoExecutionException {
        List<ImageConfiguration> images = this.getResolvedImages();
        if (this.saveName == null && this.saveAlias == null) {
            List<ImageConfiguration> buildImages = this.getImagesWithBuildConfig(images);
            if (buildImages.size() == 1) {
                return buildImages.get(0).getName();
            }
            throw new MojoExecutionException("More than one image with build configuration is defined. Please specify the image with 'docker.name' or 'docker.alias'.");
        }
        if (this.saveName != null && this.saveAlias != null) {
            throw new MojoExecutionException("Cannot specify both name and alias.");
        }
        for (ImageConfiguration ic : images) {
            if (!this.equalName(ic) && !this.equalAlias(ic)) continue;
            return ic.getName();
        }
        throw new MojoExecutionException(this.saveName != null ? "Can not find image with name '" + this.saveName + "'" : "Can not find image with alias '" + this.saveAlias + "'");
    }

    private List<ImageConfiguration> getImagesWithBuildConfig(List<ImageConfiguration> images) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration image : images) {
            if (image.getBuildConfiguration() == null) continue;
            ret.add(image);
        }
        return ret;
    }

    private boolean equalAlias(ImageConfiguration ic) {
        return this.saveAlias != null && this.saveAlias.equals(ic.getAlias());
    }

    private boolean equalName(ImageConfiguration ic) {
        return this.saveName != null && this.saveName.equals(ic.getName());
    }
}

