/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc.unix;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

final class UnixSocket
extends Socket {
    private final Object connectLock = new Object();
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private final UnixSocketChannel channel = UnixSocketChannel.open();

    UnixSocket() throws IOException {
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout may not be negative: " + timeout);
        }
        if (!(endpoint instanceof UnixSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type: " + endpoint.getClass().getName());
        }
        Object object = this.connectLock;
        synchronized (object) {
            this.channel.connect((UnixSocketAddress)endpoint);
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Bind is not supported");
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteSocketAddress() {
        Object object = this.connectLock;
        synchronized (object) {
            return this.channel.getRemoteSocketAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalSocketAddress() {
        Object object = this.connectLock;
        synchronized (object) {
            return this.channel.getLocalSocketAddress();
        }
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.channel.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.inputShutdown) {
            throw new SocketException("Socket input is shutdown");
        }
        return new FilterInputStream(Channels.newInputStream((ReadableByteChannel)this.channel)){

            @Override
            public void close() throws IOException {
                UnixSocket.this.shutdownInput();
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.channel.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.outputShutdown) {
            throw new SocketException("Socket output is shutdown");
        }
        return new FilterOutputStream(Channels.newOutputStream((WritableByteChannel)this.channel)){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                UnixSocket.this.shutdownOutput();
            }
        };
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.channel.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.channel.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Send buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the send buffer size is not supported");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the receive buffer size is not supported");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.channel.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.channel.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException("Traffic class is not in range 0 -- 255: " + tc);
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public int getTrafficClass() throws SocketException {
        throw new UnsupportedOperationException("Getting the traffic class is not supported");
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        throw new UnsupportedOperationException("Getting the SO_REUSEADDR option is not supported");
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.inputShutdown = true;
        this.outputShutdown = true;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.channel.shutdownInput();
        this.inputShutdown = true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.channel.shutdownOutput();
        this.outputShutdown = true;
    }

    @Override
    public String toString() {
        if (this.isConnected()) {
            return "UnixSocket[addr=" + this.channel.getRemoteSocketAddress() + ']';
        }
        return "UnixSocket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public boolean isBound() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

