/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.log;

import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.log.SharedPrintStream;
import io.fabric8.maven.docker.util.Timestamp;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class DefaultLogCallback
implements LogCallback {
    private static Map<String, SharedPrintStream> printStreamMap = new HashMap<String, SharedPrintStream>();
    private final LogOutputSpec outputSpec;
    private SharedPrintStream sps;

    public DefaultLogCallback(LogOutputSpec outputSpec) {
        this.outputSpec = outputSpec;
    }

    @Override
    public synchronized void open() throws IOException {
        if (this.sps == null) {
            String file = this.outputSpec.getFile();
            if (this.outputSpec.isLogStdout() || file == null) {
                this.sps = new SharedPrintStream(System.out);
            } else {
                SharedPrintStream cachedPs = printStreamMap.get(file);
                if (cachedPs == null) {
                    PrintStream ps = new PrintStream(new FileOutputStream(file), true);
                    cachedPs = new SharedPrintStream(ps);
                    printStreamMap.put(file, cachedPs);
                } else {
                    cachedPs.allocate();
                }
                this.sps = cachedPs;
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.sps != null && this.sps.close()) {
            String file = this.outputSpec.getFile();
            if (file != null) {
                printStreamMap.remove(file);
            }
            this.sps = null;
        }
    }

    private PrintStream ps() {
        return this.sps.getPrintStream();
    }

    @Override
    public void log(int type, Timestamp timestamp, String txt) {
        this.addLogEntry(this.ps(), new LogEntry(type, timestamp, txt));
    }

    @Override
    public void error(String error) {
        this.ps().println(error);
    }

    private void addLogEntry(PrintStream ps, LogEntry logEntry) {
        LogOutputSpec spec = this.outputSpec;
        if (spec == null) {
            spec = LogOutputSpec.DEFAULT;
        }
        String text = logEntry.getText();
        ps.println(spec.getPrompt(spec.isUseColor(), logEntry.getTimestamp()) + text);
    }

    private static class LogEntry
    implements Comparable<LogEntry> {
        private final int type;
        private final Timestamp timestamp;
        private final String text;

        public LogEntry(int type, Timestamp timestamp, String text) {
            this.type = type;
            this.timestamp = timestamp;
            this.text = text;
        }

        public int getType() {
            return this.type;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public int compareTo(LogEntry entry) {
            return this.timestamp.compareTo(entry.timestamp);
        }
    }
}

