/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.access.DockerMachine;
import io.fabric8.maven.docker.access.hc.DockerAccessWithHcClient;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=DockerAccessFactory.class, instantiationStrategy="singleton")
public class DockerAccessFactory {
    public static final String API_VERSION = "1.18";

    public DockerAccess createDockerAccess(DockerAccessContext dockerAccessContext) throws MojoExecutionException, MojoFailureException {
        try {
            DockerConnectionDetector dockerConnectionDetector = this.createDockerConnectionDetector(dockerAccessContext, dockerAccessContext.getLog());
            DockerConnectionDetector.ConnectionParameter connectionParam = dockerConnectionDetector.detectConnectionParameter(dockerAccessContext.getDockerHost(), dockerAccessContext.getCertPath());
            String version = dockerAccessContext.getMinimalApiVersion() != null ? dockerAccessContext.getMinimalApiVersion() : API_VERSION;
            DockerAccessWithHcClient access = new DockerAccessWithHcClient("v" + version, connectionParam.getUrl(), connectionParam.getCertPath(), dockerAccessContext.getMaxConnections(), dockerAccessContext.getLog());
            access.start();
            this.setDockerHostAddressProperty(dockerAccessContext, connectionParam.getUrl());
            String serverVersion = access.getServerApiVersion();
            if (!EnvUtil.greaterOrEqualsVersion(serverVersion, version)) {
                throw new MojoExecutionException(String.format("Server API version %s is smaller than required API version %s", serverVersion, version));
            }
            return access;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create docker access object ", (Exception)e);
        }
    }

    private DockerConnectionDetector createDockerConnectionDetector(DockerAccessContext dockerAccessContext, Logger log) {
        return new DockerConnectionDetector(this.getDockerHostProviders(dockerAccessContext, log));
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders(DockerAccessContext dockerAccessContext, Logger log) {
        if (dockerAccessContext.getDockerHostProviders() != null) {
            return dockerAccessContext.getDockerHostProviders();
        }
        return this.getDefaultDockerHostProviders(dockerAccessContext, log);
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDefaultDockerHostProviders(DockerAccessContext dockerAccessContext, Logger log) {
        Properties projectProps;
        DockerMachineConfiguration config = dockerAccessContext.getMachine();
        if (dockerAccessContext.isSkipMachine()) {
            config = null;
        } else if (config == null && (projectProps = dockerAccessContext.getProjectProperties()).containsKey("docker.machine.name")) {
            config = new DockerMachineConfiguration(projectProps.getProperty("docker.machine.name"), projectProps.getProperty("docker.machine.autoCreate"));
        }
        ArrayList<DockerConnectionDetector.DockerHostProvider> ret = new ArrayList<DockerConnectionDetector.DockerHostProvider>();
        ret.add(new DockerMachine(log, config));
        return ret;
    }

    private void setDockerHostAddressProperty(DockerAccessContext dockerAccessContext, String dockerUrl) throws MojoFailureException {
        Properties props = dockerAccessContext.getProjectProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && (uri.getScheme().equals("unix") || uri.getScheme().equals("npipe")) ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new MojoFailureException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), (Throwable)e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public static class DockerAccessContext
    implements Serializable {
        private Properties projectProperties;
        private DockerMachineConfiguration machine;
        private List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders;
        private boolean skipMachine;
        private String minimalApiVersion;
        private String dockerHost;
        private String certPath;
        private int maxConnections;
        private Logger log;

        public Properties getProjectProperties() {
            return this.projectProperties;
        }

        public DockerMachineConfiguration getMachine() {
            return this.machine;
        }

        public List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders() {
            return this.dockerHostProviders;
        }

        public boolean isSkipMachine() {
            return this.skipMachine;
        }

        public String getMinimalApiVersion() {
            return this.minimalApiVersion;
        }

        public String getDockerHost() {
            return this.dockerHost;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public Logger getLog() {
            return this.log;
        }

        public static class Builder {
            private DockerAccessContext context = new DockerAccessContext();

            public Builder() {
                this.context = new DockerAccessContext();
            }

            public Builder(DockerAccessContext context) {
                this.context = context;
            }

            public Builder projectProperties(Properties projectProperties) {
                this.context.projectProperties = projectProperties;
                return this;
            }

            public Builder machine(DockerMachineConfiguration machine) {
                this.context.machine = machine;
                return this;
            }

            public Builder dockerHostProviders(List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders) {
                this.context.dockerHostProviders = dockerHostProviders;
                return this;
            }

            public Builder skipMachine(boolean skipMachine) {
                this.context.skipMachine = skipMachine;
                return this;
            }

            public Builder minimalApiVersion(String minimalApiVersion) {
                this.context.minimalApiVersion = minimalApiVersion;
                return this;
            }

            public Builder dockerHost(String dockerHost) {
                this.context.dockerHost = dockerHost;
                return this;
            }

            public Builder certPath(String certPath) {
                this.context.certPath = certPath;
                return this;
            }

            public Builder maxConnections(int maxConnections) {
                this.context.maxConnections = maxConnections;
                return this;
            }

            public Builder log(Logger log) {
                this.context.log = log;
                return this;
            }

            public DockerAccessContext build() {
                return this.context;
            }
        }
    }
}

