/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.service.QueryService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;

public class StartOrderResolver {
    public static final int MAX_RESOLVE_RETRIES = 10;
    private final QueryService queryService;
    private final List<Resolvable> secondPass;
    private final Set<String> processedImages;

    public static List<Resolvable> resolve(QueryService queryService, List<Resolvable> convertToResolvables) {
        return new StartOrderResolver(queryService).resolve(convertToResolvables);
    }

    private StartOrderResolver(QueryService queryService) {
        this.queryService = queryService;
        this.secondPass = new ArrayList<Resolvable>();
        this.processedImages = new HashSet<String>();
    }

    private List<Resolvable> resolve(List<Resolvable> images) {
        ArrayList<Resolvable> resolved = new ArrayList<Resolvable>();
        for (Resolvable config : images) {
            List<String> volumesOrLinks = this.extractDependentImagesFor(config);
            if (volumesOrLinks == null) {
                this.updateProcessedImages(config);
                resolved.add(config);
                continue;
            }
            this.secondPass.add(config);
        }
        return this.secondPass.size() > 0 ? this.resolveRemaining(resolved) : resolved;
    }

    private List<Resolvable> resolveRemaining(List<Resolvable> ret) {
        int retries = 10;
        String error = null;
        try {
            do {
                this.resolveImageDependencies(ret);
            } while (this.secondPass.size() > 0 && retries-- > 0);
        }
        catch (DockerAccessException | ResolveSteadyStateException e) {
            error = "Cannot resolve image dependencies for start order\n" + this.remainingImagesDescription();
        }
        if (retries == 0 && this.secondPass.size() > 0) {
            error = "Cannot resolve image dependencies after 10 passes\n" + this.remainingImagesDescription();
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return ret;
    }

    private void updateProcessedImages(Resolvable config) {
        this.processedImages.add(config.getName());
        if (config.getAlias() != null) {
            this.processedImages.add(config.getAlias());
        }
    }

    private String remainingImagesDescription() {
        StringBuffer ret = new StringBuffer();
        ret.append("Unresolved images:\n");
        for (Resolvable config : this.secondPass) {
            ret.append("* ").append(config.getAlias()).append(" depends on ").append(StringUtils.join((Object[])config.getDependencies().toArray(), (String)",")).append("\n");
        }
        return ret.toString();
    }

    private void resolveImageDependencies(List<Resolvable> resolved) throws DockerAccessException, ResolveSteadyStateException {
        boolean changed = false;
        Iterator<Resolvable> iterator = this.secondPass.iterator();
        while (iterator.hasNext()) {
            Resolvable config = iterator.next();
            if (!this.hasRequiredDependencies(config)) continue;
            this.updateProcessedImages(config);
            resolved.add(config);
            changed = true;
            iterator.remove();
        }
        if (!changed) {
            throw new ResolveSteadyStateException();
        }
    }

    private boolean hasRequiredDependencies(Resolvable config) throws DockerAccessException {
        List<String> dependencies = this.extractDependentImagesFor(config);
        if (dependencies == null) {
            return false;
        }
        for (String dependency : dependencies) {
            if (this.processedImages.contains(dependency) || this.queryService.hasContainer(dependency)) continue;
            return false;
        }
        return true;
    }

    private List<String> extractDependentImagesFor(Resolvable config) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (String id : config.getDependencies()) {
            ret.add(id);
        }
        return ret.isEmpty() ? null : new ArrayList(ret);
    }

    public static interface Resolvable {
        public String getName();

        public String getAlias();

        public List<String> getDependencies();
    }

    private static class ResolveSteadyStateException
    extends Throwable {
        private ResolveSteadyStateException() {
        }
    }
}

