/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.Timestamp;
import io.fabric8.maven.docker.wait.WaitChecker;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class LogWaitChecker
implements WaitChecker {
    private final String logPattern;
    private final String containerId;
    private final Logger log;
    private final DockerAccess dockerAccess;
    private boolean first;
    private LogGetHandle logHandle;
    private AtomicBoolean detected;

    public LogWaitChecker(String pattern, DockerAccess dockerAccess, String containerId, Logger log) {
        this.log = log;
        this.dockerAccess = dockerAccess;
        this.logPattern = pattern;
        this.containerId = containerId;
        this.first = true;
        this.detected = new AtomicBoolean(false);
    }

    @Override
    public boolean check() {
        if (this.first) {
            Pattern pattern = Pattern.compile(this.logPattern);
            this.log.debug("LogWaitChecker: Pattern to match '%s'", this.logPattern);
            this.logHandle = this.dockerAccess.getLogAsync(this.containerId, new LogMatchCallback(pattern));
            this.first = false;
        }
        return this.detected.get();
    }

    @Override
    public void cleanUp() {
        if (this.logHandle != null) {
            this.logHandle.finish();
        }
    }

    @Override
    public String getLogLabel() {
        return "on log out '" + this.logPattern + "'";
    }

    private class LogMatchCallback
    implements LogCallback {
        private final Pattern pattern;
        StringBuilder logBuffer;

        LogMatchCallback(Pattern pattern) {
            this.pattern = pattern;
            this.logBuffer = (pattern.flags() & 0x20) != 0 ? new StringBuilder() : null;
        }

        @Override
        public void log(int type, Timestamp timestamp, String txt) throws LogCallback.DoneException {
            String toMatch;
            LogWaitChecker.this.log.debug("LogWaitChecker: Trying to match '%s' [Pattern: %s] [thread: %d]", txt, LogWaitChecker.this.logPattern, Thread.currentThread().getId());
            if (this.logBuffer != null) {
                this.logBuffer.append(txt).append("\n");
                toMatch = this.logBuffer.toString();
            } else {
                toMatch = txt;
            }
            if (this.pattern.matcher(toMatch).find()) {
                LogWaitChecker.this.log.debug("Found log-wait pattern in log output", new Object[0]);
                LogWaitChecker.this.detected.set(true);
                throw new LogCallback.DoneException();
            }
        }

        @Override
        public void error(String error) {
            LogWaitChecker.this.log.error("%s", error);
        }

        @Override
        public void close() {
            LogWaitChecker.this.log.debug("Closing LogWaitChecker callback", new Object[0]);
        }

        @Override
        public void open() {
        }
    }
}

