/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.access.util.EnvCommand;
import io.fabric8.maven.docker.access.util.ExternalCommand;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class DockerMachine
implements DockerConnectionDetector.DockerHostProvider {
    private final Logger log;
    private final DockerMachineConfiguration machine;
    private boolean initialized = false;
    private Map<String, String> envMap;

    public DockerMachine(Logger log, DockerMachineConfiguration machine) {
        this.log = log;
        this.machine = machine;
    }

    @Override
    public synchronized DockerConnectionDetector.ConnectionParameter getConnectionParameter(String certPath) throws IOException {
        String value;
        if (this.machine == null) {
            return null;
        }
        if (this.envMap == null) {
            this.envMap = this.getEnvironment();
        }
        if ((value = this.envMap.get("DOCKER_HOST")) == null) {
            return null;
        }
        this.log.info("DOCKER_HOST from docker-machine \"%s\" : %s", this.machine.getName(), value);
        return new DockerConnectionDetector.ConnectionParameter(value, certPath != null ? certPath : this.envMap.get("DOCKER_CERT_PATH"));
    }

    @Override
    public int getPriority() {
        return 90;
    }

    private Map<String, String> getEnvironment() throws IOException {
        this.lazyInit();
        return new MachineEnvCommand().getEnvironment();
    }

    private synchronized void lazyInit() throws IOException {
        if (!this.initialized) {
            Status status = new StatusCommand().getStatus();
            switch (status) {
                case DoesNotExist: {
                    if (Boolean.TRUE == this.machine.getAutoCreate()) {
                        new CreateCommand().execute();
                        break;
                    }
                    throw new IllegalStateException(this.machine.getName() + " does not exist and docker.machine.autoCreate is false");
                }
                case Running: {
                    break;
                }
                case Stopped: {
                    new StartCommand().execute();
                    if (Boolean.TRUE != this.machine.getRegenerateCertsAfterStart()) break;
                    new RegenerateCertsCommand().execute();
                }
            }
        }
        this.initialized = true;
    }

    private class RegenerateCertsCommand
    extends ExternalCommand {
        private long start;

        RegenerateCertsCommand() {
            super(DockerMachine.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "regenerate-certs", "-f", DockerMachine.this.machine.getName()};
        }

        @Override
        protected void start() {
            this.log.info("Regenerating certificates for \"%s\"", DockerMachine.this.machine.getName());
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void end() {
            this.log.info("Regenerated certificates for \"%s\" in %d seconds", DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L);
        }
    }

    private class StartCommand
    extends ExternalCommand {
        private long start;

        StartCommand() {
            super(DockerMachine.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "start", DockerMachine.this.machine.getName()};
        }

        @Override
        protected void start() {
            this.log.info("Starting docker machine \"%s\"", DockerMachine.this.machine.getName());
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void end() {
            this.log.info("Started docker machine \"%s\" in %d seconds", DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L);
        }
    }

    private class CreateCommand
    extends ExternalCommand {
        private long start;

        CreateCommand() {
            super(DockerMachine.this.log);
        }

        @Override
        protected String[] getArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("docker-machine");
            args.add("create");
            if (DockerMachine.this.machine.getCreateOptions() != null) {
                for (Map.Entry<String, String> entry : DockerMachine.this.machine.getCreateOptions().entrySet()) {
                    args.add("--" + entry.getKey());
                    String value = entry.getValue();
                    if (value == null || value.isEmpty()) continue;
                    args.add(value);
                }
            }
            args.add(DockerMachine.this.machine.getName());
            return args.toArray(new String[args.size()]);
        }

        @Override
        protected void start() {
            this.log.info("Creating docker machine \"%s\" with args %s", DockerMachine.this.machine.getName(), DockerMachine.this.machine.getCreateOptions() != null ? DockerMachine.this.machine.getCreateOptions().toString() : "");
            this.log.info("This might take a while ...", new Object[0]);
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void end() {
            this.log.info("Created docker machine \"%s\" in %d seconds", DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L);
        }
    }

    private class StatusCommand
    extends ExternalCommand {
        private Status status;
        private String message;

        StatusCommand() {
            super(DockerMachine.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "status", DockerMachine.this.machine.getName()};
        }

        @Override
        protected void processLine(String line) {
            this.log.info("Docker machine \"%s\" is %s", DockerMachine.this.machine.getName(), line.toLowerCase());
            if ("Running".equals(line)) {
                this.status = Status.Running;
            } else if ("Stopped".equals(line)) {
                this.status = Status.Stopped;
            } else {
                this.message = "Unknown status - " + line;
            }
        }

        public Status getStatus() throws IOException {
            try {
                this.execute();
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    this.status = Status.DoesNotExist;
                }
                throw ex;
            }
            if (this.message != null) {
                throw new IOException(this.message);
            }
            return this.status;
        }
    }

    private class MachineEnvCommand
    extends EnvCommand {
        MachineEnvCommand() {
            super(DockerMachine.this.log, "SET ");
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "env", DockerMachine.this.machine.getName(), "--shell", "cmd"};
        }
    }

    static enum Status {
        DoesNotExist,
        Running,
        Stopped;

    }
}

