/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.StopMode;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.util.GavLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContainerTracker {
    private final Map<String, String> imageToContainerMap = new HashMap<String, String>();
    private final Map<String, String> aliasToContainerMap = new HashMap<String, String>();
    private final Map<String, ContainerShutdownDescriptor> shutdownDescriptorPerContainerMap = new LinkedHashMap<String, ContainerShutdownDescriptor>();
    private final Map<GavLabel, List<ContainerShutdownDescriptor>> shutdownDescriptorPerPomLabelMap = new HashMap<GavLabel, List<ContainerShutdownDescriptor>>();

    public synchronized void registerContainer(String containerId, ImageConfiguration imageConfig, GavLabel gavLabel) {
        ContainerShutdownDescriptor descriptor = new ContainerShutdownDescriptor(imageConfig, containerId);
        this.shutdownDescriptorPerContainerMap.put(containerId, descriptor);
        this.updatePomLabelMap(gavLabel, descriptor);
        this.updateImageToContainerMapping(imageConfig, containerId);
    }

    public synchronized ContainerShutdownDescriptor removeContainer(String containerId) {
        ContainerShutdownDescriptor descriptor = this.shutdownDescriptorPerContainerMap.remove(containerId);
        if (descriptor != null) {
            this.removeContainerIdFromLookupMaps(containerId);
            this.removeDescriptorFromPomLabelMap(descriptor);
        }
        return descriptor;
    }

    public synchronized String lookupContainer(String lookup) {
        if (this.aliasToContainerMap.containsKey(lookup)) {
            return this.aliasToContainerMap.get(lookup);
        }
        return this.imageToContainerMap.get(lookup);
    }

    public synchronized Collection<ContainerShutdownDescriptor> removeShutdownDescriptors(GavLabel gavLabel) {
        List<ContainerShutdownDescriptor> descriptors;
        if (gavLabel != null) {
            descriptors = this.removeFromPomLabelMap(gavLabel);
            this.removeFromPerContainerMap(descriptors);
        } else {
            descriptors = new ArrayList<ContainerShutdownDescriptor>(this.shutdownDescriptorPerContainerMap.values());
            this.clearAllMaps();
        }
        Collections.reverse(descriptors);
        return descriptors;
    }

    private void updatePomLabelMap(GavLabel gavLabel, ContainerShutdownDescriptor descriptor) {
        if (gavLabel != null) {
            List<ContainerShutdownDescriptor> descList = this.shutdownDescriptorPerPomLabelMap.get(gavLabel);
            if (descList == null) {
                descList = new ArrayList<ContainerShutdownDescriptor>();
                this.shutdownDescriptorPerPomLabelMap.put(gavLabel, descList);
            }
            descList.add(descriptor);
        }
    }

    private void removeDescriptorFromPomLabelMap(ContainerShutdownDescriptor descriptor) {
        Iterator<Map.Entry<GavLabel, List<ContainerShutdownDescriptor>>> mapIt = this.shutdownDescriptorPerPomLabelMap.entrySet().iterator();
        while (mapIt.hasNext()) {
            Map.Entry<GavLabel, List<ContainerShutdownDescriptor>> mapEntry = mapIt.next();
            List<ContainerShutdownDescriptor> descs = mapEntry.getValue();
            Iterator<ContainerShutdownDescriptor> it = descs.iterator();
            while (it.hasNext()) {
                ContainerShutdownDescriptor desc = it.next();
                if (!descriptor.equals(desc)) continue;
                it.remove();
            }
            if (descs.size() != 0) continue;
            mapIt.remove();
        }
    }

    private void removeContainerIdFromLookupMaps(String containerId) {
        this.removeValueFromMap(this.imageToContainerMap, containerId);
        this.removeValueFromMap(this.aliasToContainerMap, containerId);
    }

    private void removeValueFromMap(Map<String, String> map, String value) {
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getValue().equals(value)) continue;
            it.remove();
        }
    }

    private void updateImageToContainerMapping(ImageConfiguration imageConfig, String id) {
        this.imageToContainerMap.put(imageConfig.getName(), id);
        if (imageConfig.getAlias() != null) {
            this.aliasToContainerMap.put(imageConfig.getAlias(), id);
        }
    }

    private void removeFromPerContainerMap(List<ContainerShutdownDescriptor> descriptors) {
        Iterator<Map.Entry<String, ContainerShutdownDescriptor>> it = this.shutdownDescriptorPerContainerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ContainerShutdownDescriptor> entry = it.next();
            if (!descriptors.contains(entry.getValue())) continue;
            this.removeContainerIdFromLookupMaps(entry.getKey());
            it.remove();
        }
    }

    private List<ContainerShutdownDescriptor> removeFromPomLabelMap(GavLabel gavLabel) {
        List<ContainerShutdownDescriptor> descriptors = this.shutdownDescriptorPerPomLabelMap.remove(gavLabel);
        if (descriptors == null) {
            descriptors = new ArrayList<ContainerShutdownDescriptor>();
        }
        return descriptors;
    }

    private void clearAllMaps() {
        this.shutdownDescriptorPerContainerMap.clear();
        this.shutdownDescriptorPerPomLabelMap.clear();
        this.imageToContainerMap.clear();
        this.aliasToContainerMap.clear();
    }

    static class ContainerShutdownDescriptor {
        private final ImageConfiguration imageConfig;
        private final String containerId;
        private final int shutdownGracePeriod;
        private final int killGracePeriod;
        private final StopMode stopMode;
        private String preStop;
        private boolean breakOnError = false;

        ContainerShutdownDescriptor(ImageConfiguration imageConfig, String containerId) {
            this.imageConfig = imageConfig;
            this.containerId = containerId;
            RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
            WaitConfiguration waitConfig = runConfig != null ? runConfig.getWaitConfiguration() : null;
            this.shutdownGracePeriod = waitConfig != null && waitConfig.getShutdown() != null ? waitConfig.getShutdown() : 0;
            this.stopMode = runConfig != null ? runConfig.getStopMode() : StopMode.graceful;
            int n = this.killGracePeriod = waitConfig != null && waitConfig.getKill() != null ? waitConfig.getKill() : 0;
            if (waitConfig != null && waitConfig.getExec() != null) {
                this.preStop = waitConfig.getExec().getPreStop();
                this.breakOnError = waitConfig.getExec().isBreakOnError();
            }
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public String getImage() {
            return this.imageConfig.getName();
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getDescription() {
            return this.imageConfig.getDescription();
        }

        public int getShutdownGracePeriod() {
            return this.shutdownGracePeriod;
        }

        public int getKillGracePeriod() {
            return this.killGracePeriod;
        }

        public String getPreStop() {
            return this.preStop;
        }

        public boolean isBreakOnError() {
            return this.breakOnError;
        }

        public StopMode getStopMode() {
            return this.stopMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerShutdownDescriptor that = (ContainerShutdownDescriptor)o;
            return this.containerId.equals(that.containerId);
        }

        public int hashCode() {
            return this.containerId.hashCode();
        }
    }
}

