/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.JibBuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL)
public class BuildMojo
extends AbstractBuildSupportMojo {
    public static final String DMP_PLUGIN_DESCRIPTOR = "META-INF/maven/io.fabric8/dmp-plugin";
    public static final String DOCKER_EXTRA_DIR = "docker-extra";
    @Parameter(property="docker.skip.build", defaultValue="false")
    protected boolean skipBuild;
    @Parameter(property="docker.name", defaultValue="")
    protected String name;
    @Parameter(property="docker.buildArchiveOnly", defaultValue="false")
    protected String buildArchiveOnly;
    @Parameter(property="docker.skip.tag", defaultValue="false")
    protected boolean skipTag;

    @Override
    protected void executeInternal(ServiceHub hub) throws IOException, MojoExecutionException {
        if (this.skipBuild) {
            return;
        }
        this.executeBuildPlugins();
        for (ImageConfiguration imageConfig : this.getResolvedImages()) {
            this.processImageConfig(hub, imageConfig);
        }
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, IOException {
        EnvUtil.storeTimestamp(this.getBuildTimestampFile(), this.getBuildTimestamp());
        BuildService.BuildContext buildContext = this.getBuildContext();
        ImagePullManager pullManager = this.getImagePullManager(this.determinePullPolicy(imageConfig.getBuildConfiguration()), this.autoPull);
        this.proceedWithBuildProcess(hub, buildContext, imageConfig, pullManager);
    }

    private void proceedWithBuildProcess(ServiceHub hub, BuildService.BuildContext buildContext, ImageConfiguration imageConfig, ImagePullManager pullManager) throws MojoExecutionException, IOException {
        if (Boolean.TRUE.equals(this.jib)) {
            this.proceedWithJibBuild(hub, buildContext, imageConfig);
        } else {
            this.proceedWithDockerBuild(hub.getBuildService(), buildContext, imageConfig, pullManager);
        }
    }

    private void proceedWithJibBuild(ServiceHub hub, BuildService.BuildContext buildContext, ImageConfiguration imageConfig) throws MojoExecutionException {
        this.log.info("Building Container image with [[B]]JIB(Java Image Builder)[[B]] mode", new Object[0]);
        new JibBuildService(hub, this.createMojoParameters(), this.log).build(imageConfig, buildContext.getRegistryConfig());
    }

    private void proceedWithDockerBuild(BuildService buildService, BuildService.BuildContext buildContext, ImageConfiguration imageConfig, ImagePullManager pullManager) throws MojoExecutionException, IOException {
        File buildArchiveFile = buildService.buildArchive(imageConfig, buildContext, this.resolveBuildArchiveParameter());
        if (Boolean.FALSE.equals(this.shallBuildArchiveOnly())) {
            buildService.buildImage(imageConfig, pullManager, buildContext, buildArchiveFile);
        }
        if (!this.skipTag) {
            buildService.tagImage(imageConfig);
        }
    }

    @Override
    protected Date getReferenceDate() {
        return new Date();
    }

    private String resolveBuildArchiveParameter() {
        if (!(this.buildArchiveOnly == null || this.buildArchiveOnly.isEmpty() || this.buildArchiveOnly.equalsIgnoreCase("false") || this.buildArchiveOnly.equalsIgnoreCase("true"))) {
            return this.buildArchiveOnly;
        }
        return null;
    }

    private boolean shallBuildArchiveOnly() {
        if (this.buildArchiveOnly != null && !this.buildArchiveOnly.isEmpty() && (this.buildArchiveOnly.equalsIgnoreCase("false") || this.buildArchiveOnly.equalsIgnoreCase("true"))) {
            return Boolean.parseBoolean(this.buildArchiveOnly);
        }
        return false;
    }

    private String determinePullPolicy(BuildImageConfiguration buildConfig) {
        return buildConfig != null && buildConfig.getImagePullPolicy() != null ? buildConfig.getImagePullPolicy() : this.imagePullPolicy;
    }

    private void processImageConfig(ServiceHub hub, ImageConfiguration aImageConfig) throws IOException, MojoExecutionException {
        BuildImageConfiguration buildConfig = aImageConfig.getBuildConfiguration();
        if (buildConfig != null) {
            if (buildConfig.skip()) {
                this.log.info("%s : Skipped building", aImageConfig.getDescription());
            } else {
                this.buildAndTag(hub, aImageConfig);
            }
        }
    }

    private void executeBuildPlugins() {
        try {
            Enumeration<URL> dmpPlugins = Thread.currentThread().getContextClassLoader().getResources(DMP_PLUGIN_DESCRIPTOR);
            while (dmpPlugins.hasMoreElements()) {
                URL dmpPlugin = dmpPlugins.nextElement();
                File outputDir = this.getAndEnsureOutputDirectory();
                this.processDmpPluginDescription(dmpPlugin, outputDir);
            }
        }
        catch (IOException e) {
            this.log.error("Cannot load dmp-plugins from %s", DMP_PLUGIN_DESCRIPTOR);
        }
    }

    private void processDmpPluginDescription(URL pluginDesc, File outputDir) throws IOException {
        String line = null;
        try (LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(pluginDesc.openStream(), "UTF8"));){
            line = reader2.readLine();
            while (line != null) {
                if (line.matches("^\\s*#")) continue;
                this.callBuildPlugin(outputDir, line);
                line = reader2.readLine();
            }
        }
        catch (ClassNotFoundException reader2) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Found dmp-plugin %s but could not be called : %s", line, e.getMessage());
        }
    }

    private File getAndEnsureOutputDirectory() {
        File outputDir = new File(new File(this.project.getBuild().getDirectory()), DOCKER_EXTRA_DIR);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    private void callBuildPlugin(File outputDir, String buildPluginClass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> buildPlugin = Class.forName(buildPluginClass);
        try {
            Method method = buildPlugin.getMethod("addExtraFiles", File.class);
            method.invoke(null, outputDir);
            this.log.info("Extra files from %s extracted", buildPluginClass);
        }
        catch (NoSuchMethodException exp) {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Build plugin %s does not support 'addExtraFiles' method", buildPluginClass);
        }
    }
}

