/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.access;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ClusterConfiguration {
    private String username;
    private String password;
    private String masterUrl;
    private String apiVersion;
    private String namespace = KubernetesHelper.getDefaultNamespace();
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo;
    private String clientKeyPassphrase;
    private String trustStoreFile;
    private String trustStorePassphrase;
    private String keyStoreFile;
    private String keyStorePassphrase;

    private ClusterConfiguration() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfig() {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            configBuilder.withUsername(this.username);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            configBuilder.withPassword(this.password);
        }
        if (StringUtils.isNotBlank((CharSequence)this.masterUrl)) {
            configBuilder.withMasterUrl(this.masterUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiVersion)) {
            configBuilder.withApiVersion(this.apiVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)this.caCertData)) {
            configBuilder.withCaCertData(this.caCertData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.caCertFile)) {
            configBuilder.withCaCertFile(this.caCertFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientCertData)) {
            configBuilder.withClientCertData(this.clientCertData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientCertFile)) {
            configBuilder.withClientCertFile(this.clientCertFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyAlgo)) {
            configBuilder.withClientKeyAlgo(this.clientKeyAlgo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyData)) {
            configBuilder.withClientKeyData(this.clientKeyData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyFile)) {
            configBuilder.withClientKeyFile(this.clientKeyFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyPassphrase)) {
            configBuilder.withClientKeyPassphrase(this.clientKeyPassphrase);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStoreFile)) {
            configBuilder.withKeyStoreFile(this.keyStoreFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStorePassphrase)) {
            configBuilder.withKeyStorePassphrase(this.keyStorePassphrase);
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
            configBuilder.withNamespace(this.namespace);
        }
        if (StringUtils.isNotBlank((CharSequence)this.trustStoreFile)) {
            configBuilder.withTrustStoreFile(this.trustStoreFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.trustStorePassphrase)) {
            configBuilder.withTrustStorePassphrase(this.trustStorePassphrase);
        }
        return configBuilder.build();
    }

    public static class Builder {
        private ClusterConfiguration clusterConfiguration;

        public Builder() {
            this(new ClusterConfiguration());
        }

        public Builder(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
        }

        public Builder from(Properties properties) {
            Field[] fields;
            for (Field f : fields = ClusterConfiguration.class.getDeclaredFields()) {
                String propertyName = "fabric8." + f.getName();
                if (!properties.containsKey(propertyName)) continue;
                String value = (String)properties.get(propertyName);
                f.setAccessible(true);
                try {
                    f.set(this.clusterConfiguration, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        public Builder username(String username) {
            this.clusterConfiguration.username = username;
            return this;
        }

        public Builder password(String password) {
            this.clusterConfiguration.password = password;
            return this;
        }

        public Builder masterUrl(String masterUrl) {
            this.clusterConfiguration.masterUrl = masterUrl;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.clusterConfiguration.apiVersion = apiVersion;
            return this;
        }

        public Builder namespace(String ns) {
            if (StringUtils.isBlank((CharSequence)ns)) {
                ns = KubernetesHelper.getDefaultNamespace();
            }
            this.clusterConfiguration.namespace = ns;
            return this;
        }

        public Builder caCertFile(String caCertFile) {
            this.clusterConfiguration.caCertFile = caCertFile;
            return this;
        }

        public Builder caCertData(String caCertData) {
            this.clusterConfiguration.caCertData = caCertData;
            return this;
        }

        public Builder clientCertFile(String clientCertFile) {
            this.clusterConfiguration.clientCertFile = clientCertFile;
            return this;
        }

        public Builder clientCertData(String clientCertData) {
            this.clusterConfiguration.clientCertData = clientCertData;
            return this;
        }

        public Builder clientKeyFile(String clientKeyFile) {
            this.clusterConfiguration.clientKeyFile = clientKeyFile;
            return this;
        }

        public Builder clientKeyData(String clientKeyData) {
            this.clusterConfiguration.clientKeyData = clientKeyData;
            return this;
        }

        public Builder clientKeyAlgo(String clientKeyAlgo) {
            this.clusterConfiguration.clientKeyAlgo = clientKeyAlgo;
            return this;
        }

        public Builder clientKeyPassphrase(String clientKeyPassphrase) {
            this.clusterConfiguration.clientKeyPassphrase = clientKeyPassphrase;
            return this;
        }

        public Builder trustStoreFile(String trustStoreFile) {
            this.clusterConfiguration.trustStoreFile = trustStoreFile;
            return this;
        }

        public Builder trustStorePassphrase(String trustStorePassphrase) {
            this.clusterConfiguration.trustStorePassphrase = trustStorePassphrase;
            return this;
        }

        public Builder keyStoreFile(String keyStoreFile) {
            this.clusterConfiguration.keyStoreFile = keyStoreFile;
            return this;
        }

        public Builder keyStorePassphrase(String keyStorePassphrase) {
            this.clusterConfiguration.keyStorePassphrase = keyStorePassphrase;
            return this;
        }

        public ClusterConfiguration build() {
            return this.clusterConfiguration;
        }
    }
}

