/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.ConfigMap;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.MetricsConfig;
import io.fabric8.maven.core.config.ProbeConfig;
import io.fabric8.maven.core.config.SecretConfig;
import io.fabric8.maven.core.config.ServiceAccountConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.config.VolumeConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Parameter;

public class ResourceConfig {
    @Parameter
    private Map<String, String> env;
    @Parameter
    private MetaDataConfig labels = new MetaDataConfig();
    @Parameter
    private MetaDataConfig annotations = new MetaDataConfig();
    @Parameter
    private List<VolumeConfig> volumes;
    @Parameter
    private List<SecretConfig> secrets;
    @Parameter(defaultValue="${project.artifactId}")
    private String controllerName;
    @Parameter
    private List<ServiceConfig> services;
    @Parameter
    private List<String> remotes;
    @Parameter
    private ConfigMap configMap;
    @Parameter
    private ProbeConfig liveness;
    @Parameter
    private ProbeConfig readiness;
    @Parameter
    private MetricsConfig metrics;
    @Parameter
    private boolean containerPrivileged = false;
    @Parameter
    private String imagePullPolicy;
    @Parameter
    private Map<String, Integer> ports;
    @Parameter
    private int replicas = 1;
    @Parameter
    private String namespace;
    @Parameter
    private String serviceAccount;
    @Parameter
    private List<ServiceAccountConfig> serviceAccounts;

    public Optional<Map<String, String>> getEnv() {
        return Optional.ofNullable(this.env);
    }

    public MetaDataConfig getLabels() {
        return this.labels;
    }

    public MetaDataConfig getAnnotations() {
        return this.annotations;
    }

    public List<VolumeConfig> getVolumes() {
        return this.volumes;
    }

    public List<ServiceConfig> getServices() {
        return this.services;
    }

    public List<SecretConfig> getSecrets() {
        return this.secrets;
    }

    public ProbeConfig getLiveness() {
        return this.liveness;
    }

    public ProbeConfig getReadiness() {
        return this.readiness;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public List<ServiceAccountConfig> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    public List<String> getRemotes() {
        return this.remotes;
    }

    public static class Builder {
        private ResourceConfig config = new ResourceConfig();

        public Builder() {
        }

        public Builder(ResourceConfig config) {
            if (config != null) {
                this.config.env = config.getEnv().orElse(null);
                this.config.controllerName = config.getControllerName();
                this.config.imagePullPolicy = config.getImagePullPolicy();
                this.config.replicas = config.getReplicas();
                this.config.liveness = config.getLiveness();
                this.config.readiness = config.getReadiness();
                this.config.annotations = config.getAnnotations();
                this.config.serviceAccount = config.getServiceAccount();
                this.config.serviceAccounts = config.getServiceAccounts();
                this.config.configMap = config.getConfigMap();
                this.config.volumes = config.getVolumes();
                this.config.labels = config.getLabels();
                this.config.annotations = config.getAnnotations();
                this.config.secrets = config.getSecrets();
                this.config.services = config.getServices();
                this.config.metrics = config.getMetrics();
                this.config.namespace = config.getNamespace();
                this.config.remotes = config.remotes;
            }
        }

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder controllerName(String name) {
            this.config.controllerName = name;
            return this;
        }

        public Builder imagePullPolicy(String policy) {
            this.config.imagePullPolicy = policy;
            return this;
        }

        public Builder withReplicas(int replicas) {
            this.config.replicas = replicas;
            return this;
        }

        public Builder volumes(List<VolumeConfig> volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder withServiceAccount(String serviceAccount) {
            this.config.serviceAccount = serviceAccount;
            return this;
        }

        public Builder withServiceAccounts(List<ServiceAccountConfig> serviceAccounts) {
            this.config.serviceAccounts = serviceAccounts;
            return this;
        }

        public Builder withConfigMap(ConfigMap configMap) {
            this.config.configMap = configMap;
            return this;
        }

        public Builder withLiveness(ProbeConfig liveness) {
            this.config.liveness = liveness;
            return this;
        }

        public Builder withReadiness(ProbeConfig readiness) {
            this.config.readiness = readiness;
            return this;
        }

        public Builder withRemotes(List<String> remotes) {
            this.config.remotes = remotes;
            return this;
        }

        public ResourceConfig build() {
            return this.config;
        }
    }
}

