/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.maven.core.service.ClientToolsService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;

public class PortForwardService {
    private ClientToolsService clientToolsService;
    private Logger log;
    private KubernetesClient kubernetes;

    public PortForwardService(KubernetesClient kubernetes, Logger log) {
        this.clientToolsService = new ClientToolsService(log);
        this.log = Objects.requireNonNull(log, "log");
        this.kubernetes = Objects.requireNonNull(kubernetes, "kubernetes");
    }

    public Closeable forwardPortAsync(final Logger externalProcessLogger, LabelSelector podSelector, final int remotePort, final int localPort) throws Fabric8ServiceException {
        Pod newPod;
        final ReentrantLock monitor = new ReentrantLock(true);
        final Condition podChanged = monitor.newCondition();
        final Pod[] nextForwardedPod = new Pod[1];
        Thread forwarderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                currentPod = null;
                currentPortForward = null;
                try {
                    monitor.lock();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if (PortForwardService.access$000(PortForwardService.this, currentPod, nextForwardedPod[0])) {
                            podChanged.await();
                            continue;
                        }
                        nextPod = nextForwardedPod[0];
                        try {
                            monitor.unlock();
                            if (currentPortForward != null) {
                                PortForwardService.access$100(PortForwardService.this).info("Closing port-forward from pod %s", new Object[]{KubernetesHelper.getName(currentPod)});
                                currentPortForward.close();
                                currentPortForward = null;
                            }
                            if (nextPod != null) {
                                PortForwardService.access$100(PortForwardService.this).info("Starting port-forward to pod %s", new Object[]{KubernetesHelper.getName((HasMetadata)nextPod)});
                                currentPortForward = PortForwardService.this.forwardPortAsync(externalProcessLogger, KubernetesHelper.getName((HasMetadata)nextPod), remotePort, localPort);
                            } else {
                                PortForwardService.access$100(PortForwardService.this).info("Waiting for a pod to become ready before starting port-forward", new Object[0]);
                            }
                            currentPod = nextPod;
                        }
                        finally {
                            monitor.lock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    PortForwardService.access$100(PortForwardService.this).debug("Port-forwarding thread interrupted", new Object[]{e});
                    Thread.currentThread().interrupt();
                    monitor.unlock();
                    if (currentPortForward != null) {
                        try {
                            currentPortForward.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    try {
                        PortForwardService.access$100(PortForwardService.this).warn("Error while port-forwarding to pod", new Object[]{e});
                    }
                    catch (Throwable var5_9) {
                        throw var5_9;
                    }
                    finally {
                        monitor.unlock();
                        if (currentPortForward != null) {
                            try {
                                currentPortForward.close();
                            }
                            catch (Exception var3_7) {}
                        }
                    }
                }
                ** GOTO lbl-1000
            }
        };
        nextForwardedPod[0] = newPod = this.getNewestPod(podSelector);
        Watch watch = (Watch)KubernetesClientUtil.withSelector((NonNamespaceOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>>)this.kubernetes.pods(), podSelector, this.log).watch((Object)new Watcher<Pod>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(Watcher.Action action, Pod pod) {
                monitor.lock();
                try {
                    List<Pod> candidatePods;
                    if (nextForwardedPod[0] != null) {
                        candidatePods = new LinkedList<Pod>();
                        candidatePods.add(nextForwardedPod[0]);
                        candidatePods.add(pod);
                    } else {
                        candidatePods = Collections.singletonList(pod);
                    }
                    Pod newPod = PortForwardService.this.getNewestPod(candidatePods);
                    if (!PortForwardService.this.podEquals(nextForwardedPod[0], newPod)) {
                        nextForwardedPod[0] = newPod;
                        podChanged.signal();
                    }
                }
                finally {
                    monitor.unlock();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        forwarderThread.start();
        final Closeable handle = () -> {
            try {
                watch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                forwarderThread.interrupt();
                forwarderThread.join(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    handle.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return handle;
    }

    private boolean podEquals(Pod pod1, Pod pod2) {
        if (pod1 == pod2) {
            return true;
        }
        if (pod1 == null || pod2 == null) {
            return false;
        }
        return KubernetesHelper.getName((HasMetadata)pod1).equals(KubernetesHelper.getName((HasMetadata)pod2));
    }

    private Pod getNewestPod(LabelSelector selector) {
        FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods = KubernetesClientUtil.withSelector((NonNamespaceOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>>)this.kubernetes.pods(), selector, this.log);
        PodList list = (PodList)pods.list();
        if (list != null) {
            List items = list.getItems();
            return this.getNewestPod(items);
        }
        return null;
    }

    private Pod getNewestPod(List<Pod> items) {
        Pod targetPod = null;
        if (items != null) {
            for (Pod pod : items) {
                if (!KubernetesHelper.isPodWaiting(pod) && !KubernetesHelper.isPodRunning(pod) || targetPod != null && (!KubernetesHelper.isPodReady(pod) || !KubernetesResourceUtil.isNewerResource((HasMetadata)pod, (HasMetadata)targetPod))) continue;
                targetPod = pod;
            }
        }
        return targetPod;
    }

    public void forwardPort(Logger externalProcessLogger, String pod, int remotePort, int localPort) throws Fabric8ServiceException {
        this.forwardPortAsync(externalProcessLogger, pod, remotePort, localPort).await();
    }

    public ProcessUtil.ProcessExecutionContext forwardPortAsync(Logger externalProcessLogger, String pod, int remotePort, int localPort) throws Fabric8ServiceException {
        File command = this.clientToolsService.getKubeCtlExecutable(OpenshiftHelper.isOpenShiftClient(this.kubernetes));
        this.log.info("Port forwarding to port " + remotePort + " on pod " + pod + " using command " + command, new Object[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add("port-forward");
        args.add(pod);
        args.add(localPort + ":" + remotePort);
        String commandLine = command + " " + StringUtils.join(args, (String)" ");
        this.log.verbose("Executing command " + commandLine, new Object[0]);
        try {
            return ProcessUtil.runAsyncCommand(externalProcessLogger, command, args, true, false);
        }
        catch (IOException e) {
            throw new Fabric8ServiceException("Error while executing the port-forward command", e);
        }
    }

    static /* synthetic */ Logger access$100(PortForwardService x0) {
        return x0.log;
    }
}

