/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;

public class KindAndName {
    private final String kind;
    private final String name;

    public KindAndName(String kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public KindAndName(HasMetadata item) {
        this(KubernetesHelper.getKind(item), KubernetesHelper.getName(item));
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "KindAndName{kind='" + this.kind + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KindAndName that = (KindAndName)o;
        if (!this.kind.equals(that.kind)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

