/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.model.Configuration;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherConfig;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public abstract class BaseEnricher
implements Enricher {
    private final EnricherConfig config;
    private final String name;
    protected EnricherContext enricherContext;
    protected Logger log;

    public BaseEnricher(EnricherContext enricherContext, String name) {
        this.enricherContext = enricherContext;
        this.config = new EnricherConfig(name, enricherContext.getConfiguration());
        this.log = new PrefixedLogger(name, enricherContext.getLog());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    @Override
    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    protected Logger getLog() {
        return this.log;
    }

    protected Optional<List<ImageConfiguration>> getImages() {
        return this.enricherContext.getConfiguration().getImages();
    }

    protected boolean hasImageConfiguration() {
        return !this.enricherContext.getConfiguration().getImages().orElse(Collections.emptyList()).isEmpty();
    }

    protected Configuration getConfiguration() {
        return this.enricherContext.getConfiguration();
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected boolean hasConfig(Configs.Key key) {
        return this.config.get(key) != null;
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected Map<String, String> getRawConfig() {
        return this.config.getRawConfig();
    }

    protected EnricherContext getContext() {
        return this.enricherContext;
    }

    protected boolean isOpenShiftMode() {
        Properties properties = this.getContext().getConfiguration().getProperties();
        if (properties != null) {
            return RuntimeMode.isOpenShiftMode((Properties)properties);
        }
        return false;
    }
}

