/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.model.Configuration;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class VertxHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    static final String VERTX_MAVEN_PLUGIN_GROUP = "io.reactiverse";
    static final String VERTX_MAVEN_PLUGIN_ARTIFACT = "vertx-maven-plugin";
    static final String VERTX_GROUPID = "io.vertx";
    private static final int DEFAULT_MANAGEMENT_PORT = 8080;
    private static final String SCHEME_HTTP = "HTTP";
    private static final String VERTX_HEALTH = "vertx.health.";
    private static final Function<? super String, String> TRIM = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(@Nullable String input) {
            return input == null ? null : input.trim();
        }
    };
    public static final String ERROR_MESSAGE = "Location of %s should return a String but found %s with value %s";

    public VertxHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-vertx");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverVertxHealthCheck(true);
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverVertxHealthCheck(false);
    }

    private boolean isApplicable() {
        return this.getContext().hasPlugin(VERTX_MAVEN_PLUGIN_GROUP, VERTX_MAVEN_PLUGIN_ARTIFACT) || this.getContext().hasDependency(VERTX_GROUPID, null);
    }

    private String getSpecificPropertyName(boolean readiness, String attribute) {
        if (readiness) {
            return "vertx.health.readiness." + attribute;
        }
        return "vertx.health.liveness." + attribute;
    }

    private Probe discoverVertxHealthCheck(boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        String type = this.getStringValue("type", readiness).orElse("http").toUpperCase();
        Optional<Integer> port = this.getIntegerValue("port", readiness);
        Optional<String> portName = this.getStringValue("port-name", readiness);
        String path = this.getStringValue("path", readiness).map(input -> {
            if (input.isEmpty() || input.startsWith("/")) {
                return input;
            }
            return "/" + input;
        }).orElse(null);
        String scheme = this.getStringValue("scheme", readiness).orElse(SCHEME_HTTP).toUpperCase();
        Optional<Integer> initialDelay = this.getIntegerValue("initial-delay", readiness);
        Optional<Integer> period = this.getIntegerValue("period", readiness);
        Optional<Integer> timeout = this.getIntegerValue("timeout", readiness);
        Optional<Integer> successThreshold = this.getIntegerValue("success-threshold", readiness);
        Optional<Integer> failureThreshold = this.getIntegerValue("failure-threshold", readiness);
        List command = this.getListValue("command", readiness).orElse(Collections.emptyList());
        Map headers = this.getMapValue("headers", readiness).orElse(Collections.emptyMap());
        if (port.isPresent() && portName.isPresent()) {
            this.log.error("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used");
        }
        if (type.equalsIgnoreCase("TCP")) {
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("TCP health check disabled (port not set)", new Object[0]);
                return null;
            }
            if (port.isPresent() && port.get() <= 0) {
                this.log.info("TCP health check disabled (port set to a negative number)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase("EXEC")) {
            if (command.isEmpty()) {
                this.log.info("TCP health check disabled (command not set)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase(SCHEME_HTTP)) {
            if (port.isPresent() && port.get() <= 0) {
                this.log.info("HTTP health check disabled (port set to " + port.get(), new Object[0]);
                return null;
            }
            if (path == null) {
                this.log.info("HTTP health check disabled (path not set)", new Object[0]);
                return null;
            }
            if (path.isEmpty()) {
                this.log.info("HTTP health check disabled (the path is empty)", new Object[0]);
                return null;
            }
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("Using default management port (8080) for HTTP health check probe", new Object[0]);
                port = Optional.of(8080);
            }
        } else {
            this.log.error("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported");
        }
        ProbeBuilder builder = new ProbeBuilder();
        if (initialDelay.isPresent()) {
            builder.withInitialDelaySeconds(initialDelay.get());
        }
        if (period.isPresent()) {
            builder.withPeriodSeconds(period.get());
        }
        if (timeout.isPresent()) {
            builder.withTimeoutSeconds(timeout.get());
        }
        if (successThreshold.isPresent()) {
            builder.withSuccessThreshold(successThreshold.get());
        }
        if (failureThreshold.isPresent()) {
            builder.withFailureThreshold(failureThreshold.get());
        }
        switch (type) {
            case "HTTP": {
                ProbeFluent.HttpGetNested http = (ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)builder.withNewHttpGet().withScheme(scheme)).withPath(path);
                if (port.isPresent()) {
                    http.withNewPort(port.get());
                }
                if (portName.isPresent()) {
                    http.withNewPort(portName.get());
                }
                if (!headers.isEmpty()) {
                    ArrayList<HTTPHeader> list = new ArrayList<HTTPHeader>();
                    for (Map.Entry entry : headers.entrySet()) {
                        list.add(new HTTPHeader((String)entry.getKey(), (String)entry.getValue()));
                    }
                    http.withHttpHeaders(list);
                }
                http.endHttpGet();
                break;
            }
            case "TCP": {
                ProbeFluent.TcpSocketNested tcp = builder.withNewTcpSocket();
                if (port.isPresent()) {
                    tcp.withNewPort(port.get());
                }
                if (portName.isPresent()) {
                    tcp.withNewPort(portName.get());
                }
                tcp.endTcpSocket();
                break;
            }
            case "EXEC": {
                ((ProbeFluent.ExecNested)builder.withNewExec().withCommand(command)).endExec();
            }
        }
        return builder.build();
    }

    private Optional<String> getStringValue(String attribute, boolean readiness) {
        String specific = this.getSpecificPropertyName(readiness, attribute);
        String generic = VERTX_HEALTH + attribute;
        Configuration contextConfig = this.getContext().getConfiguration();
        String property = contextConfig.getProperty(specific);
        if (property != null) {
            return Optional.of(property).map(TRIM);
        }
        property = contextConfig.getProperty(generic);
        if (property != null) {
            return Optional.of(property).map(TRIM);
        }
        String[] specificPath = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional<String> config = this.getValueFromConfig(specificPath).map(TRIM);
        if (!config.isPresent()) {
            return this.getValueFromConfig(attribute).map(TRIM);
        }
        return config;
    }

    private Optional<List<String>> getListValue(String attribute, boolean readiness) {
        String[] path = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional<Object> element = this.getElement(path);
        if (!element.isPresent()) {
            element = this.getElement(attribute);
        }
        return element.map(input -> {
            if (input instanceof Map) {
                Collection values = ((Map)input).values();
                ArrayList<String> elements = new ArrayList<String>();
                for (Object value : values) {
                    if (value instanceof List) {
                        List currentValues = (List)value;
                        elements.addAll(currentValues);
                        continue;
                    }
                    elements.add((String)value);
                }
                return elements;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, attribute, input.getClass(), input.toString()));
        });
    }

    private Optional<Map<String, String>> getMapValue(String attribute, boolean readiness) {
        String[] path = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional<Object> element = this.getElement(path);
        if (!element.isPresent()) {
            element = this.getElement(attribute);
        }
        return element.map(input -> {
            if (input instanceof Map) {
                return (Map)input;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, attribute, input.getClass(), input.toString()));
        });
    }

    private Optional<Integer> getIntegerValue(String attribute, boolean readiness) {
        return this.getStringValue(attribute, readiness).map(Integer::parseInt);
    }

    private Optional<String> getValueFromConfig(String ... keys) {
        return this.getElement(keys).map(input -> {
            if (input instanceof String) {
                return (String)input;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, Arrays.toString(keys), input.getClass(), input.toString()));
        });
    }

    private Optional<Object> getElement(String ... path) {
        Optional configuration = this.getContext().getConfiguration().getPluginConfiguration("maven", "io.fabric8:fabric8-maven-plugin");
        if (!configuration.isPresent()) {
            return Optional.empty();
        }
        String[] roots = new String[]{"enricher", "config", "f8-healthcheck-vertx"};
        ArrayList<String> absolute = new ArrayList<String>();
        absolute.addAll(Arrays.asList(roots));
        absolute.addAll(Arrays.asList(path));
        Object root = configuration.get();
        for (String key : absolute) {
            Map rootMap;
            if (!(root instanceof Map) || (root = (rootMap = (Map)root).get(key)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(root);
    }
}

