/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import org.apache.commons.lang3.StringUtils;

public class NameEnricher
extends BaseEnricher {
    public NameEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-name");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final String defaultName = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        builder.accept((Visitor)new TypedVisitor<HasMetadata>(){

            public void visit(HasMetadata resource) {
                ObjectMeta metadata = NameEnricher.this.getOrCreateMetadata(resource);
                if (StringUtils.isBlank((CharSequence)metadata.getName())) {
                    metadata.setName(defaultName);
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder resource) {
                DeploymentFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((DeploymentFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (StringUtils.isBlank((CharSequence)metadata.getName())) {
                    ((DeploymentFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder resource) {
                ReplicationControllerFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((ReplicationControllerFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (StringUtils.isBlank((CharSequence)metadata.getName())) {
                    ((ReplicationControllerFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder resource) {
                ReplicaSetFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((ReplicaSetFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (StringUtils.isBlank((CharSequence)metadata.getName())) {
                    ((ReplicaSetFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
    }

    private ObjectMeta getOrCreateMetadata(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            resource.setMetadata(metadata);
        }
        return metadata;
    }

    private static enum Config implements Configs.Key
    {
        name;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

