/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.ianaservicehelper.Helper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PortNameEnricher
extends BaseEnricher {
    private static final Map<Integer, String> DEFAULT_PORT_MAPPING = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(8080, "http");
            this.put(8443, "https");
            this.put(8778, "jolokia");
            this.put(9779, "prometheus");
        }
    });

    public PortNameEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-portname");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ContainerPortBuilder>(){

            public void visit(ContainerPortBuilder portBuilder) {
                Integer port = portBuilder.getContainerPort();
                if (port != null && StringUtils.isBlank((CharSequence)portBuilder.getName())) {
                    PortNameEnricher.this.addPortName(portBuilder, port);
                }
            }
        });
    }

    private void addPortName(ContainerPortBuilder builder, Integer port) {
        String protocol = this.getProtocol(builder);
        try {
            String serviceName = this.getDefaultServiceName(port);
            if (serviceName == null) {
                serviceName = this.extractIANAServiceName(port, protocol);
            }
            if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                builder.withName(serviceName);
            }
        }
        catch (IOException e) {
            this.log.error("Internal: Failed to find IANA service names for port %d/%s : %s", new Object[]{port, protocol, e.getMessage()});
        }
    }

    private String getProtocol(ContainerPortBuilder builder) {
        return Optional.ofNullable(builder.getProtocol()).filter(StringUtils::isNotBlank).map(String::toLowerCase).orElse("tcp");
    }

    private String extractIANAServiceName(Integer port, String protocol) throws IOException {
        Set sn = Helper.serviceNames((int)port, (String)protocol);
        if (sn == null || sn.isEmpty()) {
            return null;
        }
        String serviceName = (String)sn.iterator().next();
        this.log.verbose("Adding IANA port name %s for port %d", new Object[]{serviceName, port});
        return serviceName;
    }

    private String getDefaultServiceName(Integer port) {
        String serviceName = DEFAULT_PORT_MAPPING.get(port);
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            return null;
        }
        this.log.verbose("Adding default port name %s for port %d", new Object[]{serviceName, port});
        return serviceName;
    }
}

