/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DeploymentConfigEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-openshift-deploymentconfig";
    private Boolean enableAutomaticTrigger;
    private Boolean enableImageChangeTrigger;
    private Long openshiftDeployTimeoutSeconds;

    public DeploymentConfigEnricher(MavenEnricherContext context) {
        super((EnricherContext)context, ENRICHER_NAME);
        this.enableAutomaticTrigger = this.isAutomaticTriggerEnabled(context, true);
        this.enableImageChangeTrigger = this.getImageChangeTriggerFlag(true);
        this.openshiftDeployTimeoutSeconds = this.getOpenshiftDeployTimeoutInSeconds(context, 3600L);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode == PlatformMode.openshift) {
            for (HasMetadata item : builder.buildItems()) {
                if (!(item instanceof Deployment)) continue;
                DeploymentConfig deploymentConfig = this.convert(item, this.isOpenShiftMode());
                this.removeItemFromBuilder(builder, item);
                builder.addToDeploymentConfigItems(new DeploymentConfig[]{deploymentConfig});
            }
        }
    }

    private void removeItemFromBuilder(KubernetesListBuilder builder, HasMetadata item) {
        List items = builder.buildItems();
        ArrayList<HasMetadata> newListItems = new ArrayList<HasMetadata>();
        for (HasMetadata listItem : items) {
            if (listItem.equals(item)) continue;
            newListItems.add(listItem);
        }
        builder.withItems(newListItems);
    }

    private DeploymentConfig convert(HasMetadata item, Boolean isOpenshiftBuildStrategy) {
        Deployment resource = (Deployment)item;
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        builder.withMetadata(resource.getMetadata());
        DeploymentSpec spec = resource.getSpec();
        if (spec != null) {
            Map matchLabels;
            LabelSelector selector;
            Integer revisionHistoryLimit;
            DeploymentConfigFluent.SpecNested specBuilder = builder.withNewSpec();
            Integer replicas = spec.getReplicas();
            if (replicas != null) {
                specBuilder.withReplicas(replicas);
            }
            if ((revisionHistoryLimit = spec.getRevisionHistoryLimit()) != null) {
                specBuilder.withRevisionHistoryLimit(revisionHistoryLimit);
            }
            if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                specBuilder.withSelector(matchLabels);
            }
            HashMap<String, String> containerToImageMap = new HashMap<String, String>();
            PodTemplateSpec template = spec.getTemplate();
            if (template != null) {
                specBuilder.withTemplate(template);
                PodSpec podSpec = template.getSpec();
                Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + template);
                List containers = podSpec.getContainers();
                Objects.requireNonNull(podSpec, "No containers for PodTemplate.spec: " + template);
                for (Container container : containers) {
                    this.validateContainer(container);
                    containerToImageMap.put(container.getName(), container.getImage());
                }
            }
            DeploymentStrategy strategy = spec.getStrategy();
            String strategyType = null;
            if (strategy != null) {
                strategyType = strategy.getType();
            }
            if (this.openshiftDeployTimeoutSeconds != null && this.openshiftDeployTimeoutSeconds > 0L) {
                if (StringUtils.isBlank((CharSequence)strategyType) || "Rolling".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
                } else if ("Recreate".equals(strategyType)) {
                    ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RecreateParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Recreate")).withNewRecreateParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRecreateParams()).endStrategy();
                } else {
                    ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
                }
            } else if (StringUtils.isNotBlank((CharSequence)strategyType)) {
                ((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType(strategyType)).endStrategy();
            }
            if (this.enableAutomaticTrigger.booleanValue()) {
                ((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ConfigChange")).endTrigger();
            }
            if (containerToImageMap.size() != 0 && this.enableImageChangeTrigger.booleanValue() && isOpenshiftBuildStrategy.booleanValue()) {
                for (Map.Entry entry : containerToImageMap.entrySet()) {
                    String containerName = (String)entry.getKey();
                    ImageName image = new ImageName((String)entry.getValue());
                    String tag = image.getTag() != null ? image.getTag() : "latest";
                    ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).withNamespace(image.getUser())).endFrom()).withContainerNames(new String[]{containerName})).endImageChangeParams()).endTrigger();
                }
            }
            specBuilder.endSpec();
        }
        return builder.build();
    }

    private Boolean isAutomaticTriggerEnabled(MavenEnricherContext enricherContext, Boolean defaultValue) {
        if (enricherContext.getProperty("fabric8.openshift.enableAutomaticTrigger") != null) {
            return Boolean.parseBoolean(enricherContext.getProperty("fabric8.openshift.enableAutomaticTrigger").toString());
        }
        return defaultValue;
    }

    private Long getOpenshiftDeployTimeoutInSeconds(MavenEnricherContext enricherContext, Long defaultValue) {
        if (enricherContext.getProperty("fabric8.openshift.deployTimeoutSeconds") != null) {
            return Long.parseLong(enricherContext.getProperty("fabric8.openshift.deployTimeoutSeconds").toString());
        }
        return defaultValue;
    }

    private Boolean getImageChangeTriggerFlag(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.imageChangeTriggers") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.openshift.imageChangeTriggers").toString());
        }
        return defaultValue;
    }

    private void validateContainer(Container container) {
        if (container.getImage() == null) {
            throw new IllegalArgumentException("Container " + container.getName() + " has no Docker image configured. Please check your Docker image configuration (including the generators which are supposed to run)");
        }
    }
}

