/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.webapp.handler;

import io.fabric8.maven.generator.api.DefaultImageLookup;
import io.fabric8.maven.generator.webapp.AppServerHandler;
import java.io.File;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public abstract class AbstractAppServerHandler
implements AppServerHandler {
    protected final DefaultImageLookup imageLookup;
    protected final MavenProject project;
    private final String name;

    protected AbstractAppServerHandler(String name, MavenProject project) {
        this.project = project;
        this.name = name;
        this.imageLookup = new DefaultImageLookup(this.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String[] scanFiles(String ... patterns) {
        String buildOutputDir = this.project.getBuild().getDirectory();
        if (buildOutputDir != null && new File(buildOutputDir).exists()) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(buildOutputDir);
            directoryScanner.setIncludes(patterns);
            directoryScanner.scan();
            return directoryScanner.getIncludedFiles();
        }
        return new String[0];
    }

    protected boolean hasOneOf(String ... patterns) {
        return this.scanFiles(patterns).length > 0;
    }
}

