/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.ianaservicehelper;

import io.fabric8.ianaservicehelper.PortAndProtocol;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Generator {
    public static final String SERVICES_NAMESPACE = "http://www.iana.org/assignments";
    public static final URL IANA_SERVICES_URL;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Missing destination file(s)");
            System.exit(1);
        }
        String servicePortsMapDestFile = args[0];
        String serviceNamesMapDestFile = args[1];
        URLConnection conn = IANA_SERVICES_URL.openConnection();
        try (InputStream in = conn.getInputStream();){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(in);
            HashMap<PortAndProtocol, HashSet<String>> servicePortMap = new HashMap<PortAndProtocol, HashSet<String>>();
            HashMap<String, HashSet<PortAndProtocol>> serviceNameMap = new HashMap<String, HashSet<PortAndProtocol>>();
            String previousName = null;
            while (reader.hasNext()) {
                StartElement se;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !new QName(SERVICES_NAMESPACE, "record").equals((se = event.asStartElement()).getName())) continue;
                Record record = Generator.readRecord(reader, previousName);
                if (record != null) {
                    previousName = record.getName();
                    if (record.getName() == null || record.getName().isEmpty() || record.getProtocol() == null || record.getProtocol().isEmpty() || record.getPort() <= 0) continue;
                    PortAndProtocol pp = new PortAndProtocol(record.getPort(), record.getProtocol().toLowerCase());
                    HashSet<String> serviceNames = (HashSet<String>)servicePortMap.get(pp);
                    if (serviceNames == null) {
                        serviceNames = new HashSet<String>();
                    }
                    serviceNames.add(record.getName());
                    servicePortMap.put(pp, serviceNames);
                    HashSet<PortAndProtocol> servicePorts = (HashSet<PortAndProtocol>)serviceNameMap.get(record.getName());
                    if (servicePorts == null) {
                        servicePorts = new HashSet<PortAndProtocol>();
                    }
                    servicePorts.add(pp);
                    serviceNameMap.put(record.getName(), servicePorts);
                    continue;
                }
                previousName = null;
            }
            FileOutputStream fos = new FileOutputStream(servicePortsMapDestFile);
            GZIPOutputStream gz = new GZIPOutputStream(fos);
            try (ObjectOutputStream oos = new ObjectOutputStream(gz);){
                oos.writeObject(servicePortMap);
            }
            fos = new FileOutputStream(serviceNamesMapDestFile);
            gz = new GZIPOutputStream(fos);
            oos = new ObjectOutputStream(gz);
            var14_16 = null;
            try {
                oos.writeObject(serviceNameMap);
            }
            catch (Throwable throwable) {
                var14_16 = throwable;
                throw throwable;
            }
            finally {
                if (oos != null) {
                    if (var14_16 != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable) {
                            var14_16.addSuppressed(throwable);
                        }
                    } else {
                        oos.close();
                    }
                }
            }
        }
    }

    private static Record readRecord(XMLEventReader reader, String previousName) throws Exception {
        Record record = new Record();
        record.setName(previousName);
        while (reader.hasNext()) {
            XMLEvent se;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && new QName(SERVICES_NAMESPACE, "record").equals((se = event.asEndElement()).getName())) {
                return record;
            }
            if (!event.isStartElement()) continue;
            se = event.asStartElement();
            if (new QName(SERVICES_NAMESPACE, "name").equals(se.getName())) {
                record.setName(Generator.readContent(reader));
                continue;
            }
            if (new QName(SERVICES_NAMESPACE, "protocol").equals(se.getName())) {
                record.setProtocol(Generator.readContent(reader));
                continue;
            }
            if (!new QName(SERVICES_NAMESPACE, "number").equals(se.getName())) continue;
            String number = Generator.readContent(reader);
            try {
                int port = Integer.parseInt(number);
                record.setPort(port);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        throw new IllegalStateException("Should have hit end element for record");
    }

    private static String readContent(XMLEventReader reader) throws XMLStreamException {
        XMLEvent event;
        if (reader.hasNext() && (event = reader.nextEvent()).isCharacters()) {
            return event.asCharacters().getData();
        }
        return null;
    }

    static {
        URL temp = null;
        try {
            temp = new URL("https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xml");
        }
        catch (MalformedURLException e) {
            System.exit(1);
        }
        IANA_SERVICES_URL = temp;
    }

    private static final class Record {
        private String name;
        private String protocol;
        private int port;

        Record() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getProtocol() {
            return this.protocol;
        }

        void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return "Record{name='" + this.name + '\'' + ", protocol='" + this.protocol + '\'' + ", port=" + this.port + '}';
        }
    }
}

