/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.gradle.plugin.task;

import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.FileJavaGenerator;
import io.fabric8.java.generator.URLJavaGenerator;
import io.fabric8.java.generator.gradle.plugin.JavaGeneratorPluginExtension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class JavaGeneratorCrd2JavaTask
extends DefaultTask {
    private final JavaGeneratorPluginExtension extensionClass;
    public static final String NAME = "crd2java";

    @Inject
    public JavaGeneratorCrd2JavaTask(Class<? extends JavaGeneratorPluginExtension> extensionClass) {
        this.extensionClass = (JavaGeneratorPluginExtension)this.getProject().getExtensions().getByType(extensionClass);
        this.setDescription("Generate Java model from CRDs.");
    }

    @TaskAction
    public final void runTask() {
        File source;
        Config config = this.extensionClass.getConfig();
        ArrayList<Object> runners = new ArrayList<Object>();
        List<String> urls = this.extensionClass.getUrlsOrDefault();
        if (urls != null && !urls.isEmpty()) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (String url : urls) {
                try {
                    urlList.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    throw new GradleException("URL '" + url + "' is not valid", (Throwable)e);
                }
            }
            File downloadTarget = this.extensionClass.getDownloadTargetOrDefault();
            if (!downloadTarget.isDirectory()) {
                downloadTarget.mkdirs();
            }
            runners.add(new URLJavaGenerator(config, urlList, downloadTarget));
        }
        if ((source = this.extensionClass.getSourceOrDefault()) != null) {
            runners.add(new FileJavaGenerator(config, source));
        }
        if (runners.isEmpty()) {
            throw new GradleException("No source or urls specified");
        }
        runners.forEach(r -> r.run(this.extensionClass.getTargetOrDefault()));
    }
}

