package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitHubBindingBuilder extends GitHubBindingFluent<GitHubBindingBuilder> implements VisitableBuilder<GitHubBinding,GitHubBindingBuilder>{
  public GitHubBindingBuilder() {
    this(new GitHubBinding());
  }
  
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent) {
    this(fluent, new GitHubBinding());
  }
  
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,GitHubBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitHubBindingBuilder(GitHubBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitHubBindingFluent<?> fluent;
  
  public GitHubBinding build() {
    GitHubBinding buildable = new GitHubBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}