package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitHubSourceBuilder extends GitHubSourceFluent<GitHubSourceBuilder> implements VisitableBuilder<GitHubSource,GitHubSourceBuilder>{
  public GitHubSourceBuilder() {
    this(new GitHubSource());
  }
  
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent) {
    this(fluent, new GitHubSource());
  }
  
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,GitHubSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitHubSourceBuilder(GitHubSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitHubSourceFluent<?> fluent;
  
  public GitHubSource build() {
    GitHubSource buildable = new GitHubSource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}