package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitLabBindingBuilder extends GitLabBindingFluent<GitLabBindingBuilder> implements VisitableBuilder<GitLabBinding,GitLabBindingBuilder>{
  public GitLabBindingBuilder() {
    this(new GitLabBinding());
  }
  
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent) {
    this(fluent, new GitLabBinding());
  }
  
  public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,GitLabBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitLabBindingBuilder(GitLabBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitLabBindingFluent<?> fluent;
  
  public GitLabBinding build() {
    GitLabBinding buildable = new GitLabBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}