package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BrokerSpecFluent<A extends BrokerSpecFluent<A>> extends BaseFluent<A>{
  public BrokerSpecFluent() {
  }
  
  public BrokerSpecFluent(BrokerSpec instance) {
    this.copyInstance(instance);
  }
  private KReferenceBuilder config;
  private DeliverySpecBuilder delivery;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BrokerSpec instance) {
    instance = (instance != null ? instance : new BrokerSpec());
    if (instance != null) {
          this.withConfig(instance.getConfig());
          this.withDelivery(instance.getDelivery());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public KReference buildConfig() {
    return this.config != null ? this.config.build() : null;
  }
  
  public A withConfig(KReference config) {
    this._visitables.remove("config");
    if (config != null) {
        this.config = new KReferenceBuilder(config);
        this._visitables.get("config").add(this.config);
    } else {
        this.config = null;
        this._visitables.get("config").remove(this.config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public ConfigNested<A> withNewConfig() {
    return new ConfigNested(null);
  }
  
  public ConfigNested<A> withNewConfigLike(KReference item) {
    return new ConfigNested(item);
  }
  
  public ConfigNested<A> editConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(null));
  }
  
  public ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(new KReferenceBuilder().build()));
  }
  
  public ConfigNested<A> editOrNewConfigLike(KReference item) {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(item));
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery != null ? this.delivery.build() : null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    this._visitables.remove("delivery");
    if (delivery != null) {
        this.delivery = new DeliverySpecBuilder(delivery);
        this._visitables.get("delivery").add(this.delivery);
    } else {
        this.delivery = null;
        this._visitables.get("delivery").remove(this.delivery);
    }
    return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BrokerSpecFluent that = (BrokerSpecFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(config,  delivery,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigNested<N> extends KReferenceFluent<ConfigNested<N>> implements Nested<N>{
    ConfigNested(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    KReferenceBuilder builder;
    
    public N and() {
      return (N) BrokerSpecFluent.this.withConfig(builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) BrokerSpecFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }

}