package io.fabric8.knative.internal.autoscaling.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetricSpecFluent<A extends MetricSpecFluent<A>> extends BaseFluent<A>{
  public MetricSpecFluent() {
  }
  
  public MetricSpecFluent(MetricSpec instance) {
    this.copyInstance(instance);
  }
  private Long panicWindow;
  private String scrapeTarget;
  private Long stableWindow;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MetricSpec instance) {
    instance = (instance != null ? instance : new MetricSpec());
    if (instance != null) {
          this.withPanicWindow(instance.getPanicWindow());
          this.withScrapeTarget(instance.getScrapeTarget());
          this.withStableWindow(instance.getStableWindow());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getPanicWindow() {
    return this.panicWindow;
  }
  
  public A withPanicWindow(Long panicWindow) {
    this.panicWindow = panicWindow;
    return (A) this;
  }
  
  public boolean hasPanicWindow() {
    return this.panicWindow != null;
  }
  
  public String getScrapeTarget() {
    return this.scrapeTarget;
  }
  
  public A withScrapeTarget(String scrapeTarget) {
    this.scrapeTarget = scrapeTarget;
    return (A) this;
  }
  
  public boolean hasScrapeTarget() {
    return this.scrapeTarget != null;
  }
  
  public Long getStableWindow() {
    return this.stableWindow;
  }
  
  public A withStableWindow(Long stableWindow) {
    this.stableWindow = stableWindow;
    return (A) this;
  }
  
  public boolean hasStableWindow() {
    return this.stableWindow != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetricSpecFluent that = (MetricSpecFluent) o;
    if (!java.util.Objects.equals(panicWindow, that.panicWindow)) return false;
    if (!java.util.Objects.equals(scrapeTarget, that.scrapeTarget)) return false;
    if (!java.util.Objects.equals(stableWindow, that.stableWindow)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(panicWindow,  scrapeTarget,  stableWindow,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (panicWindow != null) { sb.append("panicWindow:"); sb.append(panicWindow + ","); }
    if (scrapeTarget != null) { sb.append("scrapeTarget:"); sb.append(scrapeTarget + ","); }
    if (stableWindow != null) { sb.append("stableWindow:"); sb.append(stableWindow + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}