package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeliverySpecBuilder extends DeliverySpecFluent<DeliverySpecBuilder> implements VisitableBuilder<DeliverySpec,DeliverySpecBuilder>{
  public DeliverySpecBuilder() {
    this(new DeliverySpec());
  }
  
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent) {
    this(fluent, new DeliverySpec());
  }
  
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeliverySpecBuilder(DeliverySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeliverySpecFluent<?> fluent;
  
  public DeliverySpec build() {
    DeliverySpec buildable = new DeliverySpec(fluent.getBackoffDelay(),fluent.getBackoffPolicy(),fluent.buildDeadLetterSink(),fluent.getRetry(),fluent.getRetryAfterMax(),fluent.getTimeout());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}