package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeliverySpecFluent<A extends DeliverySpecFluent<A>> extends BaseFluent<A>{
  public DeliverySpecFluent() {
  }
  
  public DeliverySpecFluent(DeliverySpec instance) {
    this.copyInstance(instance);
  }
  private String backoffDelay;
  private String backoffPolicy;
  private DestinationBuilder deadLetterSink;
  private Integer retry;
  private String retryAfterMax;
  private String timeout;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeliverySpec instance) {
    instance = (instance != null ? instance : new DeliverySpec());
    if (instance != null) {
          this.withBackoffDelay(instance.getBackoffDelay());
          this.withBackoffPolicy(instance.getBackoffPolicy());
          this.withDeadLetterSink(instance.getDeadLetterSink());
          this.withRetry(instance.getRetry());
          this.withRetryAfterMax(instance.getRetryAfterMax());
          this.withTimeout(instance.getTimeout());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBackoffDelay() {
    return this.backoffDelay;
  }
  
  public A withBackoffDelay(String backoffDelay) {
    this.backoffDelay = backoffDelay;
    return (A) this;
  }
  
  public boolean hasBackoffDelay() {
    return this.backoffDelay != null;
  }
  
  public String getBackoffPolicy() {
    return this.backoffPolicy;
  }
  
  public A withBackoffPolicy(String backoffPolicy) {
    this.backoffPolicy = backoffPolicy;
    return (A) this;
  }
  
  public boolean hasBackoffPolicy() {
    return this.backoffPolicy != null;
  }
  
  public Destination buildDeadLetterSink() {
    return this.deadLetterSink != null ? this.deadLetterSink.build() : null;
  }
  
  public A withDeadLetterSink(Destination deadLetterSink) {
    this._visitables.remove("deadLetterSink");
    if (deadLetterSink != null) {
        this.deadLetterSink = new DestinationBuilder(deadLetterSink);
        this._visitables.get("deadLetterSink").add(this.deadLetterSink);
    } else {
        this.deadLetterSink = null;
        this._visitables.get("deadLetterSink").remove(this.deadLetterSink);
    }
    return (A) this;
  }
  
  public boolean hasDeadLetterSink() {
    return this.deadLetterSink != null;
  }
  
  public DeadLetterSinkNested<A> withNewDeadLetterSink() {
    return new DeadLetterSinkNested(null);
  }
  
  public DeadLetterSinkNested<A> withNewDeadLetterSinkLike(Destination item) {
    return new DeadLetterSinkNested(item);
  }
  
  public DeadLetterSinkNested<A> editDeadLetterSink() {
    return withNewDeadLetterSinkLike(java.util.Optional.ofNullable(buildDeadLetterSink()).orElse(null));
  }
  
  public DeadLetterSinkNested<A> editOrNewDeadLetterSink() {
    return withNewDeadLetterSinkLike(java.util.Optional.ofNullable(buildDeadLetterSink()).orElse(new DestinationBuilder().build()));
  }
  
  public DeadLetterSinkNested<A> editOrNewDeadLetterSinkLike(Destination item) {
    return withNewDeadLetterSinkLike(java.util.Optional.ofNullable(buildDeadLetterSink()).orElse(item));
  }
  
  public Integer getRetry() {
    return this.retry;
  }
  
  public A withRetry(Integer retry) {
    this.retry = retry;
    return (A) this;
  }
  
  public boolean hasRetry() {
    return this.retry != null;
  }
  
  public String getRetryAfterMax() {
    return this.retryAfterMax;
  }
  
  public A withRetryAfterMax(String retryAfterMax) {
    this.retryAfterMax = retryAfterMax;
    return (A) this;
  }
  
  public boolean hasRetryAfterMax() {
    return this.retryAfterMax != null;
  }
  
  public String getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(String timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeliverySpecFluent that = (DeliverySpecFluent) o;
    if (!java.util.Objects.equals(backoffDelay, that.backoffDelay)) return false;
    if (!java.util.Objects.equals(backoffPolicy, that.backoffPolicy)) return false;
    if (!java.util.Objects.equals(deadLetterSink, that.deadLetterSink)) return false;
    if (!java.util.Objects.equals(retry, that.retry)) return false;
    if (!java.util.Objects.equals(retryAfterMax, that.retryAfterMax)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(backoffDelay,  backoffPolicy,  deadLetterSink,  retry,  retryAfterMax,  timeout,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backoffDelay != null) { sb.append("backoffDelay:"); sb.append(backoffDelay + ","); }
    if (backoffPolicy != null) { sb.append("backoffPolicy:"); sb.append(backoffPolicy + ","); }
    if (deadLetterSink != null) { sb.append("deadLetterSink:"); sb.append(deadLetterSink + ","); }
    if (retry != null) { sb.append("retry:"); sb.append(retry + ","); }
    if (retryAfterMax != null) { sb.append("retryAfterMax:"); sb.append(retryAfterMax + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DeadLetterSinkNested<N> extends DestinationFluent<DeadLetterSinkNested<N>> implements Nested<N>{
    DeadLetterSinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) DeliverySpecFluent.this.withDeadLetterSink(builder.build());
    }
    
    public N endDeadLetterSink() {
      return and();
    }
    
  
  }

}