package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AuthStatusBuilder extends AuthStatusFluent<AuthStatusBuilder> implements VisitableBuilder<AuthStatus,AuthStatusBuilder>{
  public AuthStatusBuilder() {
    this(new AuthStatus());
  }
  
  public AuthStatusBuilder(AuthStatusFluent<?> fluent) {
    this(fluent, new AuthStatus());
  }
  
  public AuthStatusBuilder(AuthStatusFluent<?> fluent,AuthStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AuthStatusBuilder(AuthStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AuthStatusFluent<?> fluent;
  
  public AuthStatus build() {
    AuthStatus buildable = new AuthStatus(fluent.getServiceAccountName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}