package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RevisionListBuilder extends RevisionListFluent<RevisionListBuilder> implements VisitableBuilder<RevisionList,RevisionListBuilder>{
  public RevisionListBuilder() {
    this(new RevisionList());
  }
  
  public RevisionListBuilder(RevisionListFluent<?> fluent) {
    this(fluent, new RevisionList());
  }
  
  public RevisionListBuilder(RevisionListFluent<?> fluent,RevisionList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RevisionListBuilder(RevisionList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RevisionListFluent<?> fluent;
  
  public RevisionList build() {
    RevisionList buildable = new RevisionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}