package io.fabric8.knative.sources.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ApiServerSourceSpecFluent<A extends ApiServerSourceSpecFluent<A>> extends BaseFluent<A>{
  public ApiServerSourceSpecFluent() {
  }
  
  public ApiServerSourceSpecFluent(ApiServerSourceSpec instance) {
    this.copyInstance(instance);
  }
  private CloudEventOverridesBuilder ceOverrides;
  private String mode;
  private LabelSelectorBuilder namespaceSelector;
  private APIVersionKindBuilder owner;
  private ArrayList<APIVersionKindSelectorBuilder> resources = new ArrayList<APIVersionKindSelectorBuilder>();
  private String serviceAccountName;
  private DestinationBuilder sink;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ApiServerSourceSpec instance) {
    instance = (instance != null ? instance : new ApiServerSourceSpec());
    if (instance != null) {
          this.withCeOverrides(instance.getCeOverrides());
          this.withMode(instance.getMode());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withOwner(instance.getOwner());
          this.withResources(instance.getResources());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withSink(instance.getSink());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides != null ? this.ceOverrides.build() : null;
  }
  
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    this._visitables.remove("ceOverrides");
    if (ceOverrides != null) {
        this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
        this._visitables.get("ceOverrides").add(this.ceOverrides);
    } else {
        this.ceOverrides = null;
        this._visitables.get("ceOverrides").remove(this.ceOverrides);
    }
    return (A) this;
  }
  
  public boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  
  public CeOverridesNested<A> withNewCeOverrides() {
    return new CeOverridesNested(null);
  }
  
  public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new CeOverridesNested(item);
  }
  
  public CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(null));
  }
  
  public CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
  }
  
  public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(java.util.Optional.ofNullable(buildCeOverrides()).orElse(item));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public APIVersionKind buildOwner() {
    return this.owner != null ? this.owner.build() : null;
  }
  
  public A withOwner(APIVersionKind owner) {
    this._visitables.remove("owner");
    if (owner != null) {
        this.owner = new APIVersionKindBuilder(owner);
        this._visitables.get("owner").add(this.owner);
    } else {
        this.owner = null;
        this._visitables.get("owner").remove(this.owner);
    }
    return (A) this;
  }
  
  public boolean hasOwner() {
    return this.owner != null;
  }
  
  public A withNewOwner(String apiVersion,String kind) {
    return (A)withOwner(new APIVersionKind(apiVersion, kind));
  }
  
  public OwnerNested<A> withNewOwner() {
    return new OwnerNested(null);
  }
  
  public OwnerNested<A> withNewOwnerLike(APIVersionKind item) {
    return new OwnerNested(item);
  }
  
  public OwnerNested<A> editOwner() {
    return withNewOwnerLike(java.util.Optional.ofNullable(buildOwner()).orElse(null));
  }
  
  public OwnerNested<A> editOrNewOwner() {
    return withNewOwnerLike(java.util.Optional.ofNullable(buildOwner()).orElse(new APIVersionKindBuilder().build()));
  }
  
  public OwnerNested<A> editOrNewOwnerLike(APIVersionKind item) {
    return withNewOwnerLike(java.util.Optional.ofNullable(buildOwner()).orElse(item));
  }
  
  public A addToResources(int index,APIVersionKindSelector item) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").add(index, builder); resources.add(index, builder);}
    return (A)this;
  }
  
  public A setToResources(int index,APIVersionKindSelector item) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").set(index, builder); resources.set(index, builder);}
    return (A)this;
  }
  
  public A addToResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... items) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  
  public A addAllToResources(Collection<APIVersionKindSelector> items) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  
  public A removeFromResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... items) {
    if (this.resources == null) return (A)this;
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder); this.resources.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResources(Collection<APIVersionKindSelector> items) {
    if (this.resources == null) return (A)this;
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder); this.resources.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResources(Predicate<APIVersionKindSelectorBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<APIVersionKindSelectorBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      APIVersionKindSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<APIVersionKindSelector> buildResources() {
    return this.resources != null ? build(resources) : null;
  }
  
  public APIVersionKindSelector buildResource(int index) {
    return this.resources.get(index).build();
  }
  
  public APIVersionKindSelector buildFirstResource() {
    return this.resources.get(0).build();
  }
  
  public APIVersionKindSelector buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  
  public APIVersionKindSelector buildMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
      for (APIVersionKindSelectorBuilder item : resources) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
      for (APIVersionKindSelectorBuilder item : resources) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResources(List<APIVersionKindSelector> resources) {
    if (this.resources != null) {
      this._visitables.get("resources").clear();
    }
    if (resources != null) {
        this.resources = new ArrayList();
        for (APIVersionKindSelector item : resources) {
          this.addToResources(item);
        }
    } else {
      this.resources = null;
    }
    return (A) this;
  }
  
  public A withResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... resources) {
    if (this.resources != null) {
        this.resources.clear();
        _visitables.remove("resources");
    }
    if (resources != null) {
      for (APIVersionKindSelector item : resources) {
        this.addToResources(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null && !this.resources.isEmpty();
  }
  
  public ResourcesNested<A> addNewResource() {
    return new ResourcesNested(-1, null);
  }
  
  public ResourcesNested<A> addNewResourceLike(APIVersionKindSelector item) {
    return new ResourcesNested(-1, item);
  }
  
  public ResourcesNested<A> setNewResourceLike(int index,APIVersionKindSelector item) {
    return new ResourcesNested(index, item);
  }
  
  public ResourcesNested<A> editResource(int index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  
  public ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  
  public ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  
  public ResourcesNested<A> editMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public Destination buildSink() {
    return this.sink != null ? this.sink.build() : null;
  }
  
  public A withSink(Destination sink) {
    this._visitables.remove("sink");
    if (sink != null) {
        this.sink = new DestinationBuilder(sink);
        this._visitables.get("sink").add(this.sink);
    } else {
        this.sink = null;
        this._visitables.get("sink").remove(this.sink);
    }
    return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Destination item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new DestinationBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApiServerSourceSpecFluent that = (ApiServerSourceSpecFluent) o;
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(owner, that.owner)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(sink, that.sink)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ceOverrides,  mode,  namespaceSelector,  owner,  resources,  serviceAccountName,  sink,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (owner != null) { sb.append("owner:"); sb.append(owner + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CeOverridesNested<N> extends CloudEventOverridesFluent<CeOverridesNested<N>> implements Nested<N>{
    CeOverridesNested(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CloudEventOverridesBuilder builder;
    
    public N and() {
      return (N) ApiServerSourceSpecFluent.this.withCeOverrides(builder.build());
    }
    
    public N endCeOverrides() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ApiServerSourceSpecFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class OwnerNested<N> extends APIVersionKindFluent<OwnerNested<N>> implements Nested<N>{
    OwnerNested(APIVersionKind item) {
      this.builder = new APIVersionKindBuilder(this, item);
    }
    APIVersionKindBuilder builder;
    
    public N and() {
      return (N) ApiServerSourceSpecFluent.this.withOwner(builder.build());
    }
    
    public N endOwner() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends APIVersionKindSelectorFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(int index,APIVersionKindSelector item) {
      this.index = index;
      this.builder = new APIVersionKindSelectorBuilder(this, item);
    }
    APIVersionKindSelectorBuilder builder;
    int index;
    
    public N and() {
      return (N) ApiServerSourceSpecFluent.this.setToResources(index,builder.build());
    }
    
    public N endResource() {
      return and();
    }
    
  
  }
  public class SinkNested<N> extends DestinationFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) ApiServerSourceSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }

}