package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubBindingBuilder extends GitHubBindingFluentImpl<GitHubBindingBuilder> implements VisitableBuilder<GitHubBinding,GitHubBindingBuilder>{
  public GitHubBindingBuilder() {
    this(false);
  }
  public GitHubBindingBuilder(Boolean validationEnabled) {
    this(new GitHubBinding(), validationEnabled);
  }
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubBinding(), validationEnabled);
  }
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,GitHubBinding instance) {
    this(fluent, instance, false);
  }
  public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,GitHubBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitHubBindingBuilder(GitHubBinding instance) {
    this(instance,false);
  }
  public GitHubBindingBuilder(GitHubBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  GitHubBindingFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubBinding build() {
    GitHubBinding buildable = new GitHubBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}