package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBindingListBuilder extends KafkaBindingListFluentImpl<KafkaBindingListBuilder> implements VisitableBuilder<KafkaBindingList,KafkaBindingListBuilder>{
  public KafkaBindingListBuilder() {
    this(false);
  }
  public KafkaBindingListBuilder(Boolean validationEnabled) {
    this(new KafkaBindingList(), validationEnabled);
  }
  public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBindingList(), validationEnabled);
  }
  public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,KafkaBindingList instance) {
    this(fluent, instance, false);
  }
  public KafkaBindingListBuilder(KafkaBindingListFluent<?> fluent,KafkaBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBindingListBuilder(KafkaBindingList instance) {
    this(instance,false);
  }
  public KafkaBindingListBuilder(KafkaBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBindingList build() {
    KafkaBindingList buildable = new KafkaBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}