package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceStatusBuilder extends KafkaSourceStatusFluentImpl<KafkaSourceStatusBuilder> implements VisitableBuilder<KafkaSourceStatus,KafkaSourceStatusBuilder>{
  public KafkaSourceStatusBuilder() {
    this(false);
  }
  public KafkaSourceStatusBuilder(Boolean validationEnabled) {
    this(new KafkaSourceStatus(), validationEnabled);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSourceStatus(), validationEnabled);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,KafkaSourceStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,KafkaSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withCeAttributes(instance.getCeAttributes()); 
    fluent.withClaims(instance.getClaims()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConsumers(instance.getConsumers()); 
    fluent.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withPlacements(instance.getPlacements()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatus instance) {
    this(instance,false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCeAttributes(instance.getCeAttributes()); 
    this.withClaims(instance.getClaims()); 
    this.withConditions(instance.getConditions()); 
    this.withConsumers(instance.getConsumers()); 
    this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withPlacements(instance.getPlacements()); 
    this.withSelector(instance.getSelector()); 
    this.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSourceStatus build() {
    KafkaSourceStatus buildable = new KafkaSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getClaims(),fluent.getConditions(),fluent.getConsumers(),fluent.getMaxAllowedVReplicas(),fluent.getObservedGeneration(),fluent.getPlacements(),fluent.getSelector(),fluent.getSinkUri());
    return buildable;
  }
  
}