package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventTypeBuilder extends EventTypeFluentImpl<EventTypeBuilder> implements VisitableBuilder<EventType,EventTypeBuilder>{
  public EventTypeBuilder() {
    this(false);
  }
  public EventTypeBuilder(Boolean validationEnabled) {
    this(new EventType(), validationEnabled);
  }
  public EventTypeBuilder(EventTypeFluent<?> fluent) {
    this(fluent, false);
  }
  public EventTypeBuilder(EventTypeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventType(), validationEnabled);
  }
  public EventTypeBuilder(EventTypeFluent<?> fluent,EventType instance) {
    this(fluent, instance, false);
  }
  public EventTypeBuilder(EventTypeFluent<?> fluent,EventType instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventTypeBuilder(EventType instance) {
    this(instance,false);
  }
  public EventTypeBuilder(EventType instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  EventTypeFluent<?> fluent;
  Boolean validationEnabled;
  public EventType build() {
    EventType buildable = new EventType(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}