package io.fabric8.knative.serving.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceFluentImpl<A extends ServiceFluent<A>> extends BaseFluent<A> implements ServiceFluent<A>{
  public ServiceFluentImpl() {
  }
  public ServiceFluentImpl(Service instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ServiceSpecBuilder spec;
  private ServiceStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ServiceFluent.MetadataNested<A> withNewMetadata() {
    return new ServiceFluentImpl.MetadataNestedImpl();
  }
  public ServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ServiceFluentImpl.MetadataNestedImpl(item);
  }
  public ServiceFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ServiceFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ServiceSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ServiceSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ServiceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ServiceFluent.SpecNested<A> withNewSpec() {
    return new ServiceFluentImpl.SpecNestedImpl();
  }
  public ServiceFluent.SpecNested<A> withNewSpecLike(ServiceSpec item) {
    return new ServiceFluentImpl.SpecNestedImpl(item);
  }
  public ServiceFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ServiceFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceSpecBuilder().build());
  }
  public ServiceFluent.SpecNested<A> editOrNewSpecLike(ServiceSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ServiceStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ServiceStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ServiceStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ServiceFluent.StatusNested<A> withNewStatus() {
    return new ServiceFluentImpl.StatusNestedImpl();
  }
  public ServiceFluent.StatusNested<A> withNewStatusLike(ServiceStatus item) {
    return new ServiceFluentImpl.StatusNestedImpl(item);
  }
  public ServiceFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ServiceFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ServiceStatusBuilder().build());
  }
  public ServiceFluent.StatusNested<A> editOrNewStatusLike(ServiceStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceFluentImpl that = (ServiceFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceFluent.MetadataNested<N>> implements ServiceFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ServiceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ServiceSpecFluentImpl<ServiceFluent.SpecNested<N>> implements ServiceFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ServiceSpec item) {
      this.builder = new ServiceSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ServiceSpecBuilder(this);
    }
    ServiceSpecBuilder builder;
    public N and() {
      return (N) ServiceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ServiceStatusFluentImpl<ServiceFluent.StatusNested<N>> implements ServiceFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ServiceStatus item) {
      this.builder = new ServiceStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ServiceStatusBuilder(this);
    }
    ServiceStatusBuilder builder;
    public N and() {
      return (N) ServiceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}