package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceSpecBuilder extends ServiceSpecFluentImpl<ServiceSpecBuilder> implements VisitableBuilder<ServiceSpec,ServiceSpecBuilder>{
  public ServiceSpecBuilder() {
    this(false);
  }
  public ServiceSpecBuilder(Boolean validationEnabled) {
    this(new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceSpecBuilder(ServiceSpecFluent<?> fluent,ServiceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTraffic(instance.getTraffic()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceSpecBuilder(ServiceSpec instance) {
    this(instance,false);
  }
  public ServiceSpecBuilder(ServiceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withTemplate(instance.getTemplate()); 
    this.withTraffic(instance.getTraffic()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceSpec build() {
    ServiceSpec buildable = new ServiceSpec(fluent.getTemplate(),fluent.getTraffic());
    return buildable;
  }
  
}