/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.sources.v1.APIVersionKindSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class APIVersionKindSelectorFluent<A extends APIVersionKindSelectorFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private LabelSelectorBuilder selector;
    private Map<String, Object> additionalProperties;

    public APIVersionKindSelectorFluent() {
    }

    public APIVersionKindSelectorFluent(APIVersionKindSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIVersionKindSelector instance) {
        APIVersionKindSelector aPIVersionKindSelector = instance = instance != null ? instance : new APIVersionKindSelector();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withSelector(instance.getSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIVersionKindSelectorFluent that = (APIVersionKindSelectorFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.selector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(String.valueOf(this.selector) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)APIVersionKindSelectorFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

