/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.duck.v1.AuthStatus;
import io.fabric8.knative.duck.v1.AuthStatusBuilder;
import io.fabric8.knative.duck.v1.AuthStatusFluent;
import io.fabric8.knative.duck.v1.CloudEventAttributes;
import io.fabric8.knative.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.knative.duck.v1.CloudEventAttributesFluent;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.knative.sources.v1.ApiServerSourceStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ApiServerSourceStatusFluent<A extends ApiServerSourceStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private AuthStatusBuilder auth;
    private ArrayList<CloudEventAttributesBuilder> ceAttributes = new ArrayList();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private List<String> namespaces = new ArrayList<String>();
    private Long observedGeneration;
    private String sinkAudience;
    private String sinkCACerts;
    private String sinkUri;
    private Map<String, Object> additionalProperties;

    public ApiServerSourceStatusFluent() {
    }

    public ApiServerSourceStatusFluent(ApiServerSourceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ApiServerSourceStatus instance) {
        ApiServerSourceStatus apiServerSourceStatus = instance = instance != null ? instance : new ApiServerSourceStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withAuth(instance.getAuth());
            this.withCeAttributes(instance.getCeAttributes());
            this.withConditions(instance.getConditions());
            this.withNamespaces(instance.getNamespaces());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withSinkAudience(instance.getSinkAudience());
            this.withSinkCACerts(instance.getSinkCACerts());
            this.withSinkUri(instance.getSinkUri());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public AuthStatus buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public A withAuth(AuthStatus auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthStatusBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(AuthStatus item) {
        return new AuthNested(item);
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthStatusBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public A addToCeAttributes(int index, CloudEventAttributes item) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
        if (index < 0 || index >= this.ceAttributes.size()) {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        } else {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCeAttributes(int index, CloudEventAttributes item) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
        if (index < 0 || index >= this.ceAttributes.size()) {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        } else {
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCeAttributes(CloudEventAttributes ... items) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
        if (this.ceAttributes == null) {
            this.ceAttributes = new ArrayList();
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").add(builder);
            this.ceAttributes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCeAttributes(CloudEventAttributes ... items) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").remove((Object)builder);
            this.ceAttributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        for (CloudEventAttributes item : items) {
            CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
            this._visitables.get((Object)"ceAttributes").remove((Object)builder);
            this.ceAttributes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
        if (this.ceAttributes == null) {
            return (A)((Object)this);
        }
        Iterator<CloudEventAttributesBuilder> each = this.ceAttributes.iterator();
        List visitables = this._visitables.get((Object)"ceAttributes");
        while (each.hasNext()) {
            CloudEventAttributesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CloudEventAttributes> buildCeAttributes() {
        return this.ceAttributes != null ? ApiServerSourceStatusFluent.build(this.ceAttributes) : null;
    }

    public CloudEventAttributes buildCeAttribute(int index) {
        return this.ceAttributes.get(index).build();
    }

    public CloudEventAttributes buildFirstCeAttribute() {
        return this.ceAttributes.get(0).build();
    }

    public CloudEventAttributes buildLastCeAttribute() {
        return this.ceAttributes.get(this.ceAttributes.size() - 1).build();
    }

    public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item : this.ceAttributes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        for (CloudEventAttributesBuilder item : this.ceAttributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
        if (this.ceAttributes != null) {
            this._visitables.get((Object)"ceAttributes").clear();
        }
        if (ceAttributes != null) {
            this.ceAttributes = new ArrayList();
            for (CloudEventAttributes item : ceAttributes) {
                this.addToCeAttributes(item);
            }
        } else {
            this.ceAttributes = null;
        }
        return (A)((Object)this);
    }

    public A withCeAttributes(CloudEventAttributes ... ceAttributes) {
        if (this.ceAttributes != null) {
            this.ceAttributes.clear();
            this._visitables.remove((Object)"ceAttributes");
        }
        if (ceAttributes != null) {
            for (CloudEventAttributes item : ceAttributes) {
                this.addToCeAttributes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCeAttributes() {
        return this.ceAttributes != null && !this.ceAttributes.isEmpty();
    }

    public A addNewCeAttribute(String source, String type) {
        return this.addToCeAttributes(new CloudEventAttributes(source, type));
    }

    public CeAttributesNested<A> addNewCeAttribute() {
        return new CeAttributesNested(-1, null);
    }

    public CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
        return new CeAttributesNested(-1, item);
    }

    public CeAttributesNested<A> setNewCeAttributeLike(int index, CloudEventAttributes item) {
        return new CeAttributesNested(index, item);
    }

    public CeAttributesNested<A> editCeAttribute(int index) {
        if (this.ceAttributes.size() <= index) {
            throw new RuntimeException("Can't edit ceAttributes. Index exceeds size.");
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public CeAttributesNested<A> editFirstCeAttribute() {
        if (this.ceAttributes.size() == 0) {
            throw new RuntimeException("Can't edit first ceAttributes. The list is empty.");
        }
        return this.setNewCeAttributeLike(0, this.buildCeAttribute(0));
    }

    public CeAttributesNested<A> editLastCeAttribute() {
        int index = this.ceAttributes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ceAttributes. The list is empty.");
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ceAttributes.size(); ++i) {
            if (!predicate.test(this.ceAttributes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ceAttributes. No match found.");
        }
        return this.setNewCeAttributeLike(index, this.buildCeAttribute(index));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? ApiServerSourceStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)((Object)this);
    }

    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)((Object)this);
    }

    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNamespaces(String ... items) {
        if (this.namespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)((Object)this);
    }

    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove((Object)"namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getSinkAudience() {
        return this.sinkAudience;
    }

    public A withSinkAudience(String sinkAudience) {
        this.sinkAudience = sinkAudience;
        return (A)((Object)this);
    }

    public boolean hasSinkAudience() {
        return this.sinkAudience != null;
    }

    public String getSinkCACerts() {
        return this.sinkCACerts;
    }

    public A withSinkCACerts(String sinkCACerts) {
        this.sinkCACerts = sinkCACerts;
        return (A)((Object)this);
    }

    public boolean hasSinkCACerts() {
        return this.sinkCACerts != null;
    }

    public String getSinkUri() {
        return this.sinkUri;
    }

    public A withSinkUri(String sinkUri) {
        this.sinkUri = sinkUri;
        return (A)((Object)this);
    }

    public boolean hasSinkUri() {
        return this.sinkUri != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiServerSourceStatusFluent that = (ApiServerSourceStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.ceAttributes, that.ceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.sinkAudience, that.sinkAudience)) {
            return false;
        }
        if (!Objects.equals(this.sinkCACerts, that.sinkCACerts)) {
            return false;
        }
        if (!Objects.equals(this.sinkUri, that.sinkUri)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.auth, this.ceAttributes, this.conditions, this.namespaces, this.observedGeneration, this.sinkAudience, this.sinkCACerts, this.sinkUri, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.auth != null) {
            sb.append("auth:");
            sb.append(String.valueOf((Object)this.auth) + ",");
        }
        if (this.ceAttributes != null && !this.ceAttributes.isEmpty()) {
            sb.append("ceAttributes:");
            sb.append(String.valueOf(this.ceAttributes) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(String.valueOf(this.namespaces) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.sinkAudience != null) {
            sb.append("sinkAudience:");
            sb.append(this.sinkAudience + ",");
        }
        if (this.sinkCACerts != null) {
            sb.append("sinkCACerts:");
            sb.append(this.sinkCACerts + ",");
        }
        if (this.sinkUri != null) {
            sb.append("sinkUri:");
            sb.append(this.sinkUri + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CeAttributesNested<N>
    extends CloudEventAttributesFluent<CeAttributesNested<N>>
    implements Nested<N> {
        CloudEventAttributesBuilder builder;
        int index;

        CeAttributesNested(int index, CloudEventAttributes item) {
            this.index = index;
            this.builder = new CloudEventAttributesBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceStatusFluent.this.setToCeAttributes(this.index, this.builder.build());
        }

        public N endCeAttribute() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthStatusFluent<AuthNested<N>>
    implements Nested<N> {
        AuthStatusBuilder builder;

        AuthNested(AuthStatus item) {
            this.builder = new AuthStatusBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceStatusFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

