/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1alpha1;

import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.sources.v1alpha1.CouchDbSourceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CouchDbSourceSpecFluent<A extends CouchDbSourceSpecFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder credentials;
    private String database;
    private String feed;
    private String serviceAccountName;
    private DestinationBuilder sink;
    private Map<String, Object> additionalProperties;

    public CouchDbSourceSpecFluent() {
    }

    public CouchDbSourceSpecFluent(CouchDbSourceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CouchDbSourceSpec instance) {
        CouchDbSourceSpec couchDbSourceSpec = instance = instance != null ? instance : new CouchDbSourceSpec();
        if (instance != null) {
            this.withCredentials(instance.getCredentials());
            this.withDatabase(instance.getDatabase());
            this.withFeed(instance.getFeed());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSink(instance.getSink());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildCredentials() {
        return this.credentials != null ? this.credentials.build() : null;
    }

    public A withCredentials(ObjectReference credentials) {
        this._visitables.remove((Object)"credentials");
        if (credentials != null) {
            this.credentials = new ObjectReferenceBuilder(credentials);
            this._visitables.get((Object)"credentials").add(this.credentials);
        } else {
            this.credentials = null;
            this._visitables.get((Object)"credentials").remove(this.credentials);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentials() {
        return this.credentials != null;
    }

    public CredentialsNested<A> withNewCredentials() {
        return new CredentialsNested(null);
    }

    public CredentialsNested<A> withNewCredentialsLike(ObjectReference item) {
        return new CredentialsNested(item);
    }

    public CredentialsNested<A> editCredentials() {
        return this.withNewCredentialsLike(Optional.ofNullable(this.buildCredentials()).orElse(null));
    }

    public CredentialsNested<A> editOrNewCredentials() {
        return this.withNewCredentialsLike(Optional.ofNullable(this.buildCredentials()).orElse(new ObjectReferenceBuilder().build()));
    }

    public CredentialsNested<A> editOrNewCredentialsLike(ObjectReference item) {
        return this.withNewCredentialsLike(Optional.ofNullable(this.buildCredentials()).orElse(item));
    }

    public String getDatabase() {
        return this.database;
    }

    public A withDatabase(String database) {
        this.database = database;
        return (A)((Object)this);
    }

    public boolean hasDatabase() {
        return this.database != null;
    }

    public String getFeed() {
        return this.feed;
    }

    public A withFeed(String feed) {
        this.feed = feed;
        return (A)((Object)this);
    }

    public boolean hasFeed() {
        return this.feed != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public A withSink(Destination sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CouchDbSourceSpecFluent that = (CouchDbSourceSpecFluent)((Object)o);
        if (!Objects.equals(this.credentials, that.credentials)) {
            return false;
        }
        if (!Objects.equals(this.database, that.database)) {
            return false;
        }
        if (!Objects.equals(this.feed, that.feed)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credentials, this.database, this.feed, this.serviceAccountName, this.sink, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credentials != null) {
            sb.append("credentials:");
            sb.append(String.valueOf(this.credentials) + ",");
        }
        if (this.database != null) {
            sb.append("database:");
            sb.append(this.database + ",");
        }
        if (this.feed != null) {
            sb.append("feed:");
            sb.append(this.feed + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append(String.valueOf((Object)this.sink) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)CouchDbSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class CredentialsNested<N>
    extends ObjectReferenceFluent<CredentialsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        CredentialsNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)CouchDbSourceSpecFluent.this.withCredentials(this.builder.build());
        }

        public N endCredentials() {
            return this.and();
        }
    }
}

