/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.knative.eventing.v1alpha1.EventPolicySelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EventPolicySelectorFluent<A extends EventPolicySelectorFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;
    private List<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();
    private Map<String, String> matchLabels;

    public EventPolicySelectorFluent() {
    }

    public EventPolicySelectorFluent(EventPolicySelector instance) {
        this.copyInstance(instance);
    }

    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.add(index, item);
        return (A)((Object)this);
    }

    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(EventPolicySelector instance) {
        EventPolicySelector eventPolicySelector = instance = instance != null ? instance : new EventPolicySelector();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchLabels(instance.getMatchLabels());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventPolicySelectorFluent that = (EventPolicySelectorFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        if (!Objects.equals(this.matchLabels, that.matchLabels)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public LabelSelectorRequirement getFirstMatchExpression() {
        return this.matchExpressions.get(0);
    }

    public String getKind() {
        return this.kind;
    }

    public LabelSelectorRequirement getLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1);
    }

    public LabelSelectorRequirement getMatchExpression(int index) {
        return this.matchExpressions.get(index);
    }

    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public LabelSelectorRequirement getMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.matchExpressions, this.matchLabels, this.additionalProperties);
    }

    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A setToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions);
            sb.append(",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove((Object)"matchExpressions");
        }
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)((Object)this);
    }
}

