/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.client.extended.run.EditableRunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.extended.run.RunConfigUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class RunConfigUtilTest {
    RunConfigUtilTest() {
    }

    @Test
    void testGetObjectMetadataFromRunConfig() {
        EditableRunConfig config = ((RunConfigBuilder)((RunConfigBuilder)new RunConfigBuilder().withName("test")).withLabels(Collections.singletonMap("foo", "bar"))).build();
        ObjectMeta objectMeta = RunConfigUtil.getObjectMetadataFromRunConfig((RunConfig)config);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)objectMeta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)objectMeta.getName());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)objectMeta.getLabels().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", objectMeta.getLabels().get("foo"));
    }

    @Test
    void testGetPodSpecFromRunConfig() {
        EditableRunConfig config = ((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)new RunConfigBuilder().withName("test")).withImage("test:latest")).withEnv(Collections.singletonMap("TEST_KEY", "TEST_VALUE"))).withImagePullPolicy("IfNotPresent")).withLimits(this.getLimits())).build();
        PodSpec podSpec = RunConfigUtil.getPodSpecFromRunConfig((RunConfig)config);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)podSpec);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)podSpec.getContainers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)podSpec.getContainers().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)((Container)podSpec.getContainers().get(0)).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"IfNotPresent", (Object)((Container)podSpec.getContainers().get(0)).getImagePullPolicy());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test:latest", (Object)((Container)podSpec.getContainers().get(0)).getImage());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Container)podSpec.getContainers().get(0)).getEnv().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TEST_KEY", (Object)((EnvVar)((Container)podSpec.getContainers().get(0)).getEnv().get(0)).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TEST_VALUE", (Object)((EnvVar)((Container)podSpec.getContainers().get(0)).getEnv().get(0)).getValue());
    }

    @Test
    void testContainerFromConfig() {
        EditableRunConfig config = this.initMockRunConfigBuilder().build();
        Container container = RunConfigUtil.containerFromConfig((RunConfig)config);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)container);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)container.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"IfNotPresent", (Object)container.getImagePullPolicy());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test:latest", (Object)container.getImage());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)container.getArgs());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)container.getCommand());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)container.getEnv().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)container.getPorts().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)5701, (Integer)((ContainerPort)container.getPorts().get(0)).getContainerPort());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TEST_KEY", (Object)((EnvVar)container.getEnv().get(0)).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TEST_VALUE", (Object)((EnvVar)container.getEnv().get(0)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Quantity("200m"), container.getResources().getLimits().get("cpu"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Quantity("512Mi"), container.getResources().getLimits().get("memory"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Quantity("150m"), container.getResources().getRequests().get("cpu"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Quantity("64Mi"), container.getResources().getRequests().get("memory"));
    }

    @Test
    void testContainerFromConfigWithArgs() {
        EditableRunConfig runConfig = ((RunConfigBuilder)this.initMockRunConfigBuilder().withArgs(new String[]{"arg1", "arg2"})).build();
        Container result = RunConfigUtil.containerFromConfig((RunConfig)runConfig);
        ((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("command", Collections.emptyList())).extracting(Container::getArgs).asList().containsExactly(new Object[]{"arg1", "arg2"});
    }

    @Test
    void testContainerFromConfigWithCommand() {
        EditableRunConfig runConfig = ((RunConfigBuilder)this.initMockRunConfigBuilder().withCommand("/bin/sh")).build();
        Container result = RunConfigUtil.containerFromConfig((RunConfig)runConfig);
        ((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("args", Collections.emptyList())).extracting(Container::getCommand).asList().containsExactly(new Object[]{"/bin/sh"});
    }

    @Test
    void testContainerFromConfigWithCommandAndArgs() {
        EditableRunConfig runConfig = ((RunConfigBuilder)((RunConfigBuilder)this.initMockRunConfigBuilder().withCommand("/bin/sh")).withArgs(new String[]{"-c", "echo hello"})).build();
        Container result = RunConfigUtil.containerFromConfig((RunConfig)runConfig);
        ((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("args", Collections.emptyList())).extracting(Container::getCommand).asList().containsExactly(new Object[]{"/bin/sh", "-c", "echo hello"});
    }

    private Map<String, Quantity> getLimits() {
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("cpu", new Quantity("200m"));
        limits.put("memory", new Quantity("512Mi"));
        return limits;
    }

    private Map<String, Quantity> getRequests() {
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        requests.put("memory", new Quantity("64Mi"));
        requests.put("cpu", new Quantity("150m"));
        return requests;
    }

    private RunConfigBuilder initMockRunConfigBuilder() {
        return (RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)((RunConfigBuilder)new RunConfigBuilder().withName("test")).withImage("test:latest")).withEnv(Collections.singletonMap("TEST_KEY", "TEST_VALUE"))).withImagePullPolicy("IfNotPresent")).withPort(5701)).withLimits(this.getLimits())).withRequests(this.getRequests());
    }
}

