/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpPutTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="String body, should send a PUT request with body")
    public void putStringBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/put-string")).put("text/plain", "A string body").build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"PUT", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="InputStream body, should send a PUT request with body")
    public void putInputStreamBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/put-input-stream")).put("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"PUT", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }
}

