package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.io.File;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigFluentImpl<A extends ConfigFluent<A>> extends BaseFluent<A> implements ConfigFluent<A>{
  public ConfigFluentImpl() {
  }
  public ConfigFluentImpl(Config instance) {
    this.withMasterUrl(instance.getMasterUrl()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withNamespace(instance.getNamespace()); 
    this.withTrustCerts(instance.isTrustCerts()); 
    this.withDisableHostnameVerification(instance.isDisableHostnameVerification()); 
    this.withCaCertFile(instance.getCaCertFile()); 
    this.withCaCertData(instance.getCaCertData()); 
    this.withClientCertFile(instance.getClientCertFile()); 
    this.withClientCertData(instance.getClientCertData()); 
    this.withClientKeyFile(instance.getClientKeyFile()); 
    this.withClientKeyData(instance.getClientKeyData()); 
    this.withClientKeyAlgo(instance.getClientKeyAlgo()); 
    this.withClientKeyPassphrase(instance.getClientKeyPassphrase()); 
    this.withUsername(instance.getUsername()); 
    this.withPassword(instance.getPassword()); 
    this.withOauthToken(instance.getOauthToken()); 
    this.withWatchReconnectInterval(instance.getWatchReconnectInterval()); 
    this.withWatchReconnectLimit(instance.getWatchReconnectLimit()); 
    this.withConnectionTimeout(instance.getConnectionTimeout()); 
    this.withRequestTimeout(instance.getRequestTimeout()); 
    this.withScaleTimeout(instance.getScaleTimeout()); 
    this.withLoggingInterval(instance.getLoggingInterval()); 
    this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests()); 
    this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost()); 
    this.withHttp2Disable(instance.isHttp2Disable()); 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withErrorMessages(instance.getErrorMessages()); 
    this.withUserAgent(instance.getUserAgent()); 
    this.withTlsVersions(instance.getTlsVersions()); 
    this.withWebsocketTimeout(instance.getWebsocketTimeout()); 
    this.withWebsocketPingInterval(instance.getWebsocketPingInterval()); 
    this.withProxyUsername(instance.getProxyUsername()); 
    this.withProxyPassword(instance.getProxyPassword()); 
    this.withTrustStoreFile(instance.getTrustStoreFile()); 
    this.withTrustStorePassphrase(instance.getTrustStorePassphrase()); 
    this.withKeyStoreFile(instance.getKeyStoreFile()); 
    this.withKeyStorePassphrase(instance.getKeyStorePassphrase()); 
    this.withImpersonateUsername(instance.getImpersonateUsername()); 
    this.withImpersonateGroups(instance.getImpersonateGroups()); 
    this.withImpersonateExtras(instance.getImpersonateExtras()); 
    this.withOauthTokenProvider(instance.getOauthTokenProvider()); 
    this.withCustomHeaders(instance.getCustomHeaders()); 
    this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit()); 
    this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval()); 
    this.withUploadRequestTimeout(instance.getUploadRequestTimeout()); 
    this.withDefaultNamespace(instance.isDefaultNamespace());

    this.withAuthProvider(instance.getAuthProvider());

    this.withContexts(instance.getContexts());

    this.withCurrentContext(instance.getCurrentContext());

    this.withAutoConfigure(instance.getAutoConfigure());

    this.withFile(instance.getFile());

  }
  private boolean trustCerts;
  private boolean disableHostnameVerification;
  private String masterUrl;
  private String apiVersion;
  private String namespace;
  private boolean defaultNamespace;
  private String caCertFile;
  private String caCertData;
  private String clientCertFile;
  private String clientCertData;
  private String clientKeyFile;
  private String clientKeyData;
  private String clientKeyAlgo;
  private String clientKeyPassphrase;
  private String trustStoreFile;
  private String trustStorePassphrase;
  private String keyStoreFile;
  private String keyStorePassphrase;
  private AuthProviderConfig authProvider;
  private String username;
  private String password;
  private String oauthToken;
  private OAuthTokenProvider oauthTokenProvider;
  private long websocketPingInterval;
  private int connectionTimeout;
  private int maxConcurrentRequests;
  private int maxConcurrentRequestsPerHost;
  private List<NamedContext> contexts;
  private NamedContext currentContext;
  private int watchReconnectInterval;
  private int watchReconnectLimit;
  private int uploadRequestTimeout;
  private int requestRetryBackoffLimit;
  private int requestRetryBackoffInterval;
  private int requestTimeout;
  private long scaleTimeout;
  private int loggingInterval;
  private long websocketTimeout;
  private String impersonateUsername;
  private List<String> impersonateGroups;
  private Map<String,List<String>> impersonateExtras;
  private boolean http2Disable;
  private String httpProxy;
  private String httpsProxy;
  private String proxyUsername;
  private String proxyPassword;
  private List<String> noProxy;
  private String userAgent;
  private List<TlsVersion> tlsVersions;
  private Map<Integer,String> errorMessages;
  private Map<String,String> customHeaders;
  private boolean autoConfigure;
  private File file;
  public boolean isTrustCerts() {
    return this.trustCerts;
  }
  public A withTrustCerts(boolean trustCerts) {
    this.trustCerts=trustCerts; return (A) this;
  }
  public Boolean hasTrustCerts() {
    return true;
  }
  public boolean isDisableHostnameVerification() {
    return this.disableHostnameVerification;
  }
  public A withDisableHostnameVerification(boolean disableHostnameVerification) {
    this.disableHostnameVerification=disableHostnameVerification; return (A) this;
  }
  public Boolean hasDisableHostnameVerification() {
    return true;
  }
  public String getMasterUrl() {
    return this.masterUrl;
  }
  public A withMasterUrl(String masterUrl) {
    this.masterUrl=masterUrl; return (A) this;
  }
  public Boolean hasMasterUrl() {
    return this.masterUrl != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public boolean isDefaultNamespace() {
    return this.defaultNamespace;
  }
  public A withDefaultNamespace(boolean defaultNamespace) {
    this.defaultNamespace=defaultNamespace; return (A) this;
  }
  public Boolean hasDefaultNamespace() {
    return true;
  }
  public String getCaCertFile() {
    return this.caCertFile;
  }
  public A withCaCertFile(String caCertFile) {
    this.caCertFile=caCertFile; return (A) this;
  }
  public Boolean hasCaCertFile() {
    return this.caCertFile != null;
  }
  public String getCaCertData() {
    return this.caCertData;
  }
  public A withCaCertData(String caCertData) {
    this.caCertData=caCertData; return (A) this;
  }
  public Boolean hasCaCertData() {
    return this.caCertData != null;
  }
  public String getClientCertFile() {
    return this.clientCertFile;
  }
  public A withClientCertFile(String clientCertFile) {
    this.clientCertFile=clientCertFile; return (A) this;
  }
  public Boolean hasClientCertFile() {
    return this.clientCertFile != null;
  }
  public String getClientCertData() {
    return this.clientCertData;
  }
  public A withClientCertData(String clientCertData) {
    this.clientCertData=clientCertData; return (A) this;
  }
  public Boolean hasClientCertData() {
    return this.clientCertData != null;
  }
  public String getClientKeyFile() {
    return this.clientKeyFile;
  }
  public A withClientKeyFile(String clientKeyFile) {
    this.clientKeyFile=clientKeyFile; return (A) this;
  }
  public Boolean hasClientKeyFile() {
    return this.clientKeyFile != null;
  }
  public String getClientKeyData() {
    return this.clientKeyData;
  }
  public A withClientKeyData(String clientKeyData) {
    this.clientKeyData=clientKeyData; return (A) this;
  }
  public Boolean hasClientKeyData() {
    return this.clientKeyData != null;
  }
  public String getClientKeyAlgo() {
    return this.clientKeyAlgo;
  }
  public A withClientKeyAlgo(String clientKeyAlgo) {
    this.clientKeyAlgo=clientKeyAlgo; return (A) this;
  }
  public Boolean hasClientKeyAlgo() {
    return this.clientKeyAlgo != null;
  }
  public String getClientKeyPassphrase() {
    return this.clientKeyPassphrase;
  }
  public A withClientKeyPassphrase(String clientKeyPassphrase) {
    this.clientKeyPassphrase=clientKeyPassphrase; return (A) this;
  }
  public Boolean hasClientKeyPassphrase() {
    return this.clientKeyPassphrase != null;
  }
  public String getTrustStoreFile() {
    return this.trustStoreFile;
  }
  public A withTrustStoreFile(String trustStoreFile) {
    this.trustStoreFile=trustStoreFile; return (A) this;
  }
  public Boolean hasTrustStoreFile() {
    return this.trustStoreFile != null;
  }
  public String getTrustStorePassphrase() {
    return this.trustStorePassphrase;
  }
  public A withTrustStorePassphrase(String trustStorePassphrase) {
    this.trustStorePassphrase=trustStorePassphrase; return (A) this;
  }
  public Boolean hasTrustStorePassphrase() {
    return this.trustStorePassphrase != null;
  }
  public String getKeyStoreFile() {
    return this.keyStoreFile;
  }
  public A withKeyStoreFile(String keyStoreFile) {
    this.keyStoreFile=keyStoreFile; return (A) this;
  }
  public Boolean hasKeyStoreFile() {
    return this.keyStoreFile != null;
  }
  public String getKeyStorePassphrase() {
    return this.keyStorePassphrase;
  }
  public A withKeyStorePassphrase(String keyStorePassphrase) {
    this.keyStorePassphrase=keyStorePassphrase; return (A) this;
  }
  public Boolean hasKeyStorePassphrase() {
    return this.keyStorePassphrase != null;
  }
  public AuthProviderConfig getAuthProvider() {
    return this.authProvider;
  }
  public A withAuthProvider(AuthProviderConfig authProvider) {
    this.authProvider=authProvider; return (A) this;
  }
  public Boolean hasAuthProvider() {
    return this.authProvider != null;
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public String getPassword() {
    return this.password;
  }
  public A withPassword(String password) {
    this.password=password; return (A) this;
  }
  public Boolean hasPassword() {
    return this.password != null;
  }
  public String getOauthToken() {
    return this.oauthToken;
  }
  public A withOauthToken(String oauthToken) {
    this.oauthToken=oauthToken; return (A) this;
  }
  public Boolean hasOauthToken() {
    return this.oauthToken != null;
  }
  public OAuthTokenProvider getOauthTokenProvider() {
    return this.oauthTokenProvider;
  }
  public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
    this.oauthTokenProvider=oauthTokenProvider; return (A) this;
  }
  public Boolean hasOauthTokenProvider() {
    return this.oauthTokenProvider != null;
  }
  public long getWebsocketPingInterval() {
    return this.websocketPingInterval;
  }
  public A withWebsocketPingInterval(long websocketPingInterval) {
    this.websocketPingInterval=websocketPingInterval; return (A) this;
  }
  public Boolean hasWebsocketPingInterval() {
    return true;
  }
  public int getConnectionTimeout() {
    return this.connectionTimeout;
  }
  public A withConnectionTimeout(int connectionTimeout) {
    this.connectionTimeout=connectionTimeout; return (A) this;
  }
  public Boolean hasConnectionTimeout() {
    return true;
  }
  public int getMaxConcurrentRequests() {
    return this.maxConcurrentRequests;
  }
  public A withMaxConcurrentRequests(int maxConcurrentRequests) {
    this.maxConcurrentRequests=maxConcurrentRequests; return (A) this;
  }
  public Boolean hasMaxConcurrentRequests() {
    return true;
  }
  public int getMaxConcurrentRequestsPerHost() {
    return this.maxConcurrentRequestsPerHost;
  }
  public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
    this.maxConcurrentRequestsPerHost=maxConcurrentRequestsPerHost; return (A) this;
  }
  public Boolean hasMaxConcurrentRequestsPerHost() {
    return true;
  }
  public A addToContexts(Integer index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    this.contexts.add(index, item);
    return (A)this;
  }
  public A setToContexts(Integer index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    this.contexts.set(index, item); return (A)this;
  }
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    for (NamedContext item : items) {this.contexts.add(item);} return (A)this;
  }
  public A addAllToContexts(Collection<NamedContext> items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContext>();}
    for (NamedContext item : items) {this.contexts.add(item);} return (A)this;
  }
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    for (NamedContext item : items) {if (this.contexts!= null){ this.contexts.remove(item);}} return (A)this;
  }
  public A removeAllFromContexts(Collection<NamedContext> items) {
    for (NamedContext item : items) {if (this.contexts!= null){ this.contexts.remove(item);}} return (A)this;
  }
  public List<NamedContext> getContexts() {
    return this.contexts;
  }
  public NamedContext getContext(Integer index) {
    return this.contexts.get(index);
  }
  public NamedContext getFirstContext() {
    return this.contexts.get(0);
  }
  public NamedContext getLastContext() {
    return this.contexts.get(contexts.size() - 1);
  }
  public NamedContext getMatchingContext(Predicate<NamedContext> predicate) {
    for (NamedContext item: contexts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContext(Predicate<NamedContext> predicate) {
    for (NamedContext item: contexts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContexts(List<NamedContext> contexts) {
    if (contexts != null) {this.contexts = new ArrayList(); for (NamedContext item : contexts){this.addToContexts(item);}} else { this.contexts = null;} return (A) this;
  }
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
    if (this.contexts != null) {this.contexts.clear();}
    if (contexts != null) {for (NamedContext item :contexts){ this.addToContexts(item);}} return (A) this;
  }
  public Boolean hasContexts() {
    return contexts != null && !contexts.isEmpty();
  }
  public NamedContext getCurrentContext() {
    return this.currentContext;
  }
  public A withCurrentContext(NamedContext currentContext) {
    this.currentContext=currentContext; return (A) this;
  }
  public Boolean hasCurrentContext() {
    return this.currentContext != null;
  }
  public int getWatchReconnectInterval() {
    return this.watchReconnectInterval;
  }
  public A withWatchReconnectInterval(int watchReconnectInterval) {
    this.watchReconnectInterval=watchReconnectInterval; return (A) this;
  }
  public Boolean hasWatchReconnectInterval() {
    return true;
  }
  public int getWatchReconnectLimit() {
    return this.watchReconnectLimit;
  }
  public A withWatchReconnectLimit(int watchReconnectLimit) {
    this.watchReconnectLimit=watchReconnectLimit; return (A) this;
  }
  public Boolean hasWatchReconnectLimit() {
    return true;
  }
  public int getUploadRequestTimeout() {
    return this.uploadRequestTimeout;
  }
  public A withUploadRequestTimeout(int uploadRequestTimeout) {
    this.uploadRequestTimeout=uploadRequestTimeout; return (A) this;
  }
  public Boolean hasUploadRequestTimeout() {
    return true;
  }
  public int getRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit;
  }
  public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
    this.requestRetryBackoffLimit=requestRetryBackoffLimit; return (A) this;
  }
  public Boolean hasRequestRetryBackoffLimit() {
    return true;
  }
  public int getRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval;
  }
  public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
    this.requestRetryBackoffInterval=requestRetryBackoffInterval; return (A) this;
  }
  public Boolean hasRequestRetryBackoffInterval() {
    return true;
  }
  public int getRequestTimeout() {
    return this.requestTimeout;
  }
  public A withRequestTimeout(int requestTimeout) {
    this.requestTimeout=requestTimeout; return (A) this;
  }
  public Boolean hasRequestTimeout() {
    return true;
  }
  public long getScaleTimeout() {
    return this.scaleTimeout;
  }
  public A withScaleTimeout(long scaleTimeout) {
    this.scaleTimeout=scaleTimeout; return (A) this;
  }
  public Boolean hasScaleTimeout() {
    return true;
  }
  public int getLoggingInterval() {
    return this.loggingInterval;
  }
  public A withLoggingInterval(int loggingInterval) {
    this.loggingInterval=loggingInterval; return (A) this;
  }
  public Boolean hasLoggingInterval() {
    return true;
  }
  public long getWebsocketTimeout() {
    return this.websocketTimeout;
  }
  public A withWebsocketTimeout(long websocketTimeout) {
    this.websocketTimeout=websocketTimeout; return (A) this;
  }
  public Boolean hasWebsocketTimeout() {
    return true;
  }
  public String getImpersonateUsername() {
    return this.impersonateUsername;
  }
  public A withImpersonateUsername(String impersonateUsername) {
    this.impersonateUsername=impersonateUsername; return (A) this;
  }
  public Boolean hasImpersonateUsername() {
    return this.impersonateUsername != null;
  }
  public A withImpersonateGroups(java.lang.String... impersonateGroups) {
    if (this.impersonateGroups != null) {this.impersonateGroups.clear();}
    if (impersonateGroups != null) {for (String item :impersonateGroups){ this.addToImpersonateGroups(item);}} return (A) this;
  }
  public String[] getImpersonateGroups() {
    //This needs to work with primitives, so we use arrays.
int size = impersonateGroups != null ? impersonateGroups.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : impersonateGroups) {
    result[index++]=item;
}
return result;

  }
  public A addToImpersonateGroups(Integer index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.add(index, item);
    return (A)this;
  }
  public A setToImpersonateGroups(Integer index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.set(index, item); return (A)this;
  }
  public A addToImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A addAllToImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A removeFromImpersonateGroups(java.lang.String... items) {
    for (String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromImpersonateGroups(Collection<String> items) {
    for (String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
  }
  public Boolean hasImpersonateGroups() {
    return impersonateGroups != null && !impersonateGroups.isEmpty();
  }
  public A addToImpersonateExtras(String key,List<String> value) {
    if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
  }
  public A addToImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
  }
  public A removeFromImpersonateExtras(String key) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
  }
  public A removeFromImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
  }
  public Map<String,List<String>> getImpersonateExtras() {
    return this.impersonateExtras;
  }
  public <K,V>A withImpersonateExtras(Map<String,List<String>> impersonateExtras) {
    if (impersonateExtras == null) { this.impersonateExtras =  null;} else {this.impersonateExtras = new LinkedHashMap(impersonateExtras);} return (A) this;
  }
  public Boolean hasImpersonateExtras() {
    return this.impersonateExtras != null;
  }
  public boolean isHttp2Disable() {
    return this.http2Disable;
  }
  public A withHttp2Disable(boolean http2Disable) {
    this.http2Disable=http2Disable; return (A) this;
  }
  public Boolean hasHttp2Disable() {
    return true;
  }
  public String getHttpProxy() {
    return this.httpProxy;
  }
  public A withHttpProxy(String httpProxy) {
    this.httpProxy=httpProxy; return (A) this;
  }
  public Boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy=httpsProxy; return (A) this;
  }
  public Boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  public String getProxyUsername() {
    return this.proxyUsername;
  }
  public A withProxyUsername(String proxyUsername) {
    this.proxyUsername=proxyUsername; return (A) this;
  }
  public Boolean hasProxyUsername() {
    return this.proxyUsername != null;
  }
  public String getProxyPassword() {
    return this.proxyPassword;
  }
  public A withProxyPassword(String proxyPassword) {
    this.proxyPassword=proxyPassword; return (A) this;
  }
  public Boolean hasProxyPassword() {
    return this.proxyPassword != null;
  }
  public A withNoProxy(java.lang.String... noProxy) {
    if (this.noProxy != null) {this.noProxy.clear();}
    if (noProxy != null) {for (String item :noProxy){ this.addToNoProxy(item);}} return (A) this;
  }
  public String[] getNoProxy() {
    //This needs to work with primitives, so we use arrays.
int size = noProxy != null ? noProxy.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : noProxy) {
    result[index++]=item;
}
return result;

  }
  public A addToNoProxy(Integer index,String item) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    this.noProxy.add(index, item);
    return (A)this;
  }
  public A setToNoProxy(Integer index,String item) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    this.noProxy.set(index, item); return (A)this;
  }
  public A addToNoProxy(java.lang.String... items) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    for (String item : items) {this.noProxy.add(item);} return (A)this;
  }
  public A addAllToNoProxy(Collection<String> items) {
    if (this.noProxy == null) {this.noProxy = new ArrayList<String>();}
    for (String item : items) {this.noProxy.add(item);} return (A)this;
  }
  public A removeFromNoProxy(java.lang.String... items) {
    for (String item : items) {if (this.noProxy!= null){ this.noProxy.remove(item);}} return (A)this;
  }
  public A removeAllFromNoProxy(Collection<String> items) {
    for (String item : items) {if (this.noProxy!= null){ this.noProxy.remove(item);}} return (A)this;
  }
  public Boolean hasNoProxy() {
    return noProxy != null && !noProxy.isEmpty();
  }
  public String getUserAgent() {
    return this.userAgent;
  }
  public A withUserAgent(String userAgent) {
    this.userAgent=userAgent; return (A) this;
  }
  public Boolean hasUserAgent() {
    return this.userAgent != null;
  }
  public A withTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... tlsVersions) {
    if (this.tlsVersions != null) {this.tlsVersions.clear();}
    if (tlsVersions != null) {for (TlsVersion item :tlsVersions){ this.addToTlsVersions(item);}} return (A) this;
  }
  public TlsVersion[] getTlsVersions() {
    //This needs to work with primitives, so we use arrays.
int size = tlsVersions != null ? tlsVersions.size() : 0;
TlsVersion[] result = new TlsVersion[size];
if (size == 0) {
   return result;
}
int index = 0;
for (TlsVersion item : tlsVersions) {
    result[index++]=item;
}
return result;

  }
  public A addToTlsVersions(Integer index,TlsVersion item) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    this.tlsVersions.add(index, item);
    return (A)this;
  }
  public A setToTlsVersions(Integer index,TlsVersion item) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    this.tlsVersions.set(index, item); return (A)this;
  }
  public A addToTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    for (TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
  }
  public A addAllToTlsVersions(Collection<TlsVersion> items) {
    if (this.tlsVersions == null) {this.tlsVersions = new ArrayList<TlsVersion>();}
    for (TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
  }
  public A removeFromTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items) {
    for (TlsVersion item : items) {if (this.tlsVersions!= null){ this.tlsVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromTlsVersions(Collection<TlsVersion> items) {
    for (TlsVersion item : items) {if (this.tlsVersions!= null){ this.tlsVersions.remove(item);}} return (A)this;
  }
  public Boolean hasTlsVersions() {
    return tlsVersions != null && !tlsVersions.isEmpty();
  }
  public A addToErrorMessages(Integer key,String value) {
    if(this.errorMessages == null && key != null && value != null) { this.errorMessages = new LinkedHashMap(); }
    if(key != null && value != null) {this.errorMessages.put(key, value);} return (A)this;
  }
  public A addToErrorMessages(Map<Integer,String> map) {
    if(this.errorMessages == null && map != null) { this.errorMessages = new LinkedHashMap(); }
    if(map != null) { this.errorMessages.putAll(map);} return (A)this;
  }
  public A removeFromErrorMessages(Integer key) {
    if(this.errorMessages == null) { return (A) this; }
    if(key != null && this.errorMessages != null) {this.errorMessages.remove(key);} return (A)this;
  }
  public A removeFromErrorMessages(Map<Integer,String> map) {
    if(this.errorMessages == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.errorMessages != null){this.errorMessages.remove(key);}}} return (A)this;
  }
  public Map<Integer,String> getErrorMessages() {
    return this.errorMessages;
  }
  public <K,V>A withErrorMessages(Map<Integer,String> errorMessages) {
    if (errorMessages == null) { this.errorMessages =  null;} else {this.errorMessages = new LinkedHashMap(errorMessages);} return (A) this;
  }
  public Boolean hasErrorMessages() {
    return this.errorMessages != null;
  }
  public A addToCustomHeaders(String key,String value) {
    if(this.customHeaders == null && key != null && value != null) { this.customHeaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.customHeaders.put(key, value);} return (A)this;
  }
  public A addToCustomHeaders(Map<String,String> map) {
    if(this.customHeaders == null && map != null) { this.customHeaders = new LinkedHashMap(); }
    if(map != null) { this.customHeaders.putAll(map);} return (A)this;
  }
  public A removeFromCustomHeaders(String key) {
    if(this.customHeaders == null) { return (A) this; }
    if(key != null && this.customHeaders != null) {this.customHeaders.remove(key);} return (A)this;
  }
  public A removeFromCustomHeaders(Map<String,String> map) {
    if(this.customHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.customHeaders != null){this.customHeaders.remove(key);}}} return (A)this;
  }
  public Map<String,String> getCustomHeaders() {
    return this.customHeaders;
  }
  public <K,V>A withCustomHeaders(Map<String,String> customHeaders) {
    if (customHeaders == null) { this.customHeaders =  null;} else {this.customHeaders = new LinkedHashMap(customHeaders);} return (A) this;
  }
  public Boolean hasCustomHeaders() {
    return this.customHeaders != null;
  }
  public boolean isAutoConfigure() {
    return this.autoConfigure;
  }
  public A withAutoConfigure(boolean autoConfigure) {
    this.autoConfigure=autoConfigure; return (A) this;
  }
  public Boolean hasAutoConfigure() {
    return true;
  }
  public File getFile() {
    return this.file;
  }
  public A withFile(File file) {
    this.file=file; return (A) this;
  }
  public Boolean hasFile() {
    return this.file != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigFluentImpl that = (ConfigFluentImpl) o;
    if (trustCerts != that.trustCerts) return false;
    if (disableHostnameVerification != that.disableHostnameVerification) return false;
    if (masterUrl != null ? !masterUrl.equals(that.masterUrl) :that.masterUrl != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (defaultNamespace != that.defaultNamespace) return false;
    if (caCertFile != null ? !caCertFile.equals(that.caCertFile) :that.caCertFile != null) return false;
    if (caCertData != null ? !caCertData.equals(that.caCertData) :that.caCertData != null) return false;
    if (clientCertFile != null ? !clientCertFile.equals(that.clientCertFile) :that.clientCertFile != null) return false;
    if (clientCertData != null ? !clientCertData.equals(that.clientCertData) :that.clientCertData != null) return false;
    if (clientKeyFile != null ? !clientKeyFile.equals(that.clientKeyFile) :that.clientKeyFile != null) return false;
    if (clientKeyData != null ? !clientKeyData.equals(that.clientKeyData) :that.clientKeyData != null) return false;
    if (clientKeyAlgo != null ? !clientKeyAlgo.equals(that.clientKeyAlgo) :that.clientKeyAlgo != null) return false;
    if (clientKeyPassphrase != null ? !clientKeyPassphrase.equals(that.clientKeyPassphrase) :that.clientKeyPassphrase != null) return false;
    if (trustStoreFile != null ? !trustStoreFile.equals(that.trustStoreFile) :that.trustStoreFile != null) return false;
    if (trustStorePassphrase != null ? !trustStorePassphrase.equals(that.trustStorePassphrase) :that.trustStorePassphrase != null) return false;
    if (keyStoreFile != null ? !keyStoreFile.equals(that.keyStoreFile) :that.keyStoreFile != null) return false;
    if (keyStorePassphrase != null ? !keyStorePassphrase.equals(that.keyStorePassphrase) :that.keyStorePassphrase != null) return false;
    if (authProvider != null ? !authProvider.equals(that.authProvider) :that.authProvider != null) return false;
    if (username != null ? !username.equals(that.username) :that.username != null) return false;
    if (password != null ? !password.equals(that.password) :that.password != null) return false;
    if (oauthToken != null ? !oauthToken.equals(that.oauthToken) :that.oauthToken != null) return false;
    if (oauthTokenProvider != null ? !oauthTokenProvider.equals(that.oauthTokenProvider) :that.oauthTokenProvider != null) return false;
    if (websocketPingInterval != that.websocketPingInterval) return false;
    if (connectionTimeout != that.connectionTimeout) return false;
    if (maxConcurrentRequests != that.maxConcurrentRequests) return false;
    if (maxConcurrentRequestsPerHost != that.maxConcurrentRequestsPerHost) return false;
    if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
    if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
    if (watchReconnectInterval != that.watchReconnectInterval) return false;
    if (watchReconnectLimit != that.watchReconnectLimit) return false;
    if (uploadRequestTimeout != that.uploadRequestTimeout) return false;
    if (requestRetryBackoffLimit != that.requestRetryBackoffLimit) return false;
    if (requestRetryBackoffInterval != that.requestRetryBackoffInterval) return false;
    if (requestTimeout != that.requestTimeout) return false;
    if (scaleTimeout != that.scaleTimeout) return false;
    if (loggingInterval != that.loggingInterval) return false;
    if (websocketTimeout != that.websocketTimeout) return false;
    if (impersonateUsername != null ? !impersonateUsername.equals(that.impersonateUsername) :that.impersonateUsername != null) return false;
    if (impersonateGroups != null ? !impersonateGroups.equals(that.impersonateGroups) :that.impersonateGroups != null) return false;
    if (impersonateExtras != null ? !impersonateExtras.equals(that.impersonateExtras) :that.impersonateExtras != null) return false;
    if (http2Disable != that.http2Disable) return false;
    if (httpProxy != null ? !httpProxy.equals(that.httpProxy) :that.httpProxy != null) return false;
    if (httpsProxy != null ? !httpsProxy.equals(that.httpsProxy) :that.httpsProxy != null) return false;
    if (proxyUsername != null ? !proxyUsername.equals(that.proxyUsername) :that.proxyUsername != null) return false;
    if (proxyPassword != null ? !proxyPassword.equals(that.proxyPassword) :that.proxyPassword != null) return false;
    if (noProxy != null ? !noProxy.equals(that.noProxy) :that.noProxy != null) return false;
    if (userAgent != null ? !userAgent.equals(that.userAgent) :that.userAgent != null) return false;
    if (tlsVersions != null ? !tlsVersions.equals(that.tlsVersions) :that.tlsVersions != null) return false;
    if (errorMessages != null ? !errorMessages.equals(that.errorMessages) :that.errorMessages != null) return false;
    if (customHeaders != null ? !customHeaders.equals(that.customHeaders) :that.customHeaders != null) return false;
    if (autoConfigure != that.autoConfigure) return false;
    if (file != null ? !file.equals(that.file) :that.file != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(trustCerts,  disableHostnameVerification,  masterUrl,  apiVersion,  namespace,  defaultNamespace,  caCertFile,  caCertData,  clientCertFile,  clientCertData,  clientKeyFile,  clientKeyData,  clientKeyAlgo,  clientKeyPassphrase,  trustStoreFile,  trustStorePassphrase,  keyStoreFile,  keyStorePassphrase,  authProvider,  username,  password,  oauthToken,  oauthTokenProvider,  websocketPingInterval,  connectionTimeout,  maxConcurrentRequests,  maxConcurrentRequestsPerHost,  contexts,  currentContext,  watchReconnectInterval,  watchReconnectLimit,  uploadRequestTimeout,  requestRetryBackoffLimit,  requestRetryBackoffInterval,  requestTimeout,  scaleTimeout,  loggingInterval,  websocketTimeout,  impersonateUsername,  impersonateGroups,  impersonateExtras,  http2Disable,  httpProxy,  httpsProxy,  proxyUsername,  proxyPassword,  noProxy,  userAgent,  tlsVersions,  errorMessages,  customHeaders,  autoConfigure,  file,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("trustCerts:"); sb.append(trustCerts + ",");
    sb.append("disableHostnameVerification:"); sb.append(disableHostnameVerification + ",");
    if (masterUrl != null) { sb.append("masterUrl:"); sb.append(masterUrl + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    sb.append("defaultNamespace:"); sb.append(defaultNamespace + ",");
    if (caCertFile != null) { sb.append("caCertFile:"); sb.append(caCertFile + ","); }
    if (caCertData != null) { sb.append("caCertData:"); sb.append(caCertData + ","); }
    if (clientCertFile != null) { sb.append("clientCertFile:"); sb.append(clientCertFile + ","); }
    if (clientCertData != null) { sb.append("clientCertData:"); sb.append(clientCertData + ","); }
    if (clientKeyFile != null) { sb.append("clientKeyFile:"); sb.append(clientKeyFile + ","); }
    if (clientKeyData != null) { sb.append("clientKeyData:"); sb.append(clientKeyData + ","); }
    if (clientKeyAlgo != null) { sb.append("clientKeyAlgo:"); sb.append(clientKeyAlgo + ","); }
    if (clientKeyPassphrase != null) { sb.append("clientKeyPassphrase:"); sb.append(clientKeyPassphrase + ","); }
    if (trustStoreFile != null) { sb.append("trustStoreFile:"); sb.append(trustStoreFile + ","); }
    if (trustStorePassphrase != null) { sb.append("trustStorePassphrase:"); sb.append(trustStorePassphrase + ","); }
    if (keyStoreFile != null) { sb.append("keyStoreFile:"); sb.append(keyStoreFile + ","); }
    if (keyStorePassphrase != null) { sb.append("keyStorePassphrase:"); sb.append(keyStorePassphrase + ","); }
    if (authProvider != null) { sb.append("authProvider:"); sb.append(authProvider + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (oauthToken != null) { sb.append("oauthToken:"); sb.append(oauthToken + ","); }
    if (oauthTokenProvider != null) { sb.append("oauthTokenProvider:"); sb.append(oauthTokenProvider + ","); }
    sb.append("websocketPingInterval:"); sb.append(websocketPingInterval + ",");
    sb.append("connectionTimeout:"); sb.append(connectionTimeout + ",");
    sb.append("maxConcurrentRequests:"); sb.append(maxConcurrentRequests + ",");
    sb.append("maxConcurrentRequestsPerHost:"); sb.append(maxConcurrentRequestsPerHost + ",");
    if (contexts != null && !contexts.isEmpty()) { sb.append("contexts:"); sb.append(contexts + ","); }
    if (currentContext != null) { sb.append("currentContext:"); sb.append(currentContext + ","); }
    sb.append("watchReconnectInterval:"); sb.append(watchReconnectInterval + ",");
    sb.append("watchReconnectLimit:"); sb.append(watchReconnectLimit + ",");
    sb.append("uploadRequestTimeout:"); sb.append(uploadRequestTimeout + ",");
    sb.append("requestRetryBackoffLimit:"); sb.append(requestRetryBackoffLimit + ",");
    sb.append("requestRetryBackoffInterval:"); sb.append(requestRetryBackoffInterval + ",");
    sb.append("requestTimeout:"); sb.append(requestTimeout + ",");
    sb.append("scaleTimeout:"); sb.append(scaleTimeout + ",");
    sb.append("loggingInterval:"); sb.append(loggingInterval + ",");
    sb.append("websocketTimeout:"); sb.append(websocketTimeout + ",");
    if (impersonateUsername != null) { sb.append("impersonateUsername:"); sb.append(impersonateUsername + ","); }
    if (impersonateGroups != null && !impersonateGroups.isEmpty()) { sb.append("impersonateGroups:"); sb.append(impersonateGroups + ","); }
    if (impersonateExtras != null && !impersonateExtras.isEmpty()) { sb.append("impersonateExtras:"); sb.append(impersonateExtras + ","); }
    sb.append("http2Disable:"); sb.append(http2Disable + ",");
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (proxyUsername != null) { sb.append("proxyUsername:"); sb.append(proxyUsername + ","); }
    if (proxyPassword != null) { sb.append("proxyPassword:"); sb.append(proxyPassword + ","); }
    if (noProxy != null && !noProxy.isEmpty()) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (userAgent != null) { sb.append("userAgent:"); sb.append(userAgent + ","); }
    if (tlsVersions != null && !tlsVersions.isEmpty()) { sb.append("tlsVersions:"); sb.append(tlsVersions + ","); }
    if (errorMessages != null && !errorMessages.isEmpty()) { sb.append("errorMessages:"); sb.append(errorMessages + ","); }
    if (customHeaders != null && !customHeaders.isEmpty()) { sb.append("customHeaders:"); sb.append(customHeaders + ","); }
    sb.append("autoConfigure:"); sb.append(autoConfigure + ",");
    if (file != null) { sb.append("file:"); sb.append(file); }
    sb.append("}");
    return sb.toString();
  }
  public A withTrustCerts() {
    return withTrustCerts(true);
  }
  public A withDisableHostnameVerification() {
    return withDisableHostnameVerification(true);
  }
  public A withDefaultNamespace() {
    return withDefaultNamespace(true);
  }
  public A withHttp2Disable() {
    return withHttp2Disable(true);
  }
  public A withAutoConfigure() {
    return withAutoConfigure(true);
  }
  
}