package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.client.http.TlsVersion;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.io.File;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{
  public boolean isTrustCerts();
  public A withTrustCerts(boolean trustCerts);
  public Boolean hasTrustCerts();
  public boolean isDisableHostnameVerification();
  public A withDisableHostnameVerification(boolean disableHostnameVerification);
  public Boolean hasDisableHostnameVerification();
  public String getMasterUrl();
  public A withMasterUrl(String masterUrl);
  public Boolean hasMasterUrl();
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getNamespace();
  public A withNamespace(String namespace);
  public Boolean hasNamespace();
  public boolean isDefaultNamespace();
  public A withDefaultNamespace(boolean defaultNamespace);
  public Boolean hasDefaultNamespace();
  public String getCaCertFile();
  public A withCaCertFile(String caCertFile);
  public Boolean hasCaCertFile();
  public String getCaCertData();
  public A withCaCertData(String caCertData);
  public Boolean hasCaCertData();
  public String getClientCertFile();
  public A withClientCertFile(String clientCertFile);
  public Boolean hasClientCertFile();
  public String getClientCertData();
  public A withClientCertData(String clientCertData);
  public Boolean hasClientCertData();
  public String getClientKeyFile();
  public A withClientKeyFile(String clientKeyFile);
  public Boolean hasClientKeyFile();
  public String getClientKeyData();
  public A withClientKeyData(String clientKeyData);
  public Boolean hasClientKeyData();
  public String getClientKeyAlgo();
  public A withClientKeyAlgo(String clientKeyAlgo);
  public Boolean hasClientKeyAlgo();
  public String getClientKeyPassphrase();
  public A withClientKeyPassphrase(String clientKeyPassphrase);
  public Boolean hasClientKeyPassphrase();
  public String getTrustStoreFile();
  public A withTrustStoreFile(String trustStoreFile);
  public Boolean hasTrustStoreFile();
  public String getTrustStorePassphrase();
  public A withTrustStorePassphrase(String trustStorePassphrase);
  public Boolean hasTrustStorePassphrase();
  public String getKeyStoreFile();
  public A withKeyStoreFile(String keyStoreFile);
  public Boolean hasKeyStoreFile();
  public String getKeyStorePassphrase();
  public A withKeyStorePassphrase(String keyStorePassphrase);
  public Boolean hasKeyStorePassphrase();
  public AuthProviderConfig getAuthProvider();
  public A withAuthProvider(AuthProviderConfig authProvider);
  public Boolean hasAuthProvider();
  public String getUsername();
  public A withUsername(String username);
  public Boolean hasUsername();
  public String getPassword();
  public A withPassword(String password);
  public Boolean hasPassword();
  public String getOauthToken();
  public A withOauthToken(String oauthToken);
  public Boolean hasOauthToken();
  public String getAutoOAuthToken();
  public A withAutoOAuthToken(String autoOAuthToken);
  public Boolean hasAutoOAuthToken();
  public OAuthTokenProvider getOauthTokenProvider();
  public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider);
  public Boolean hasOauthTokenProvider();
  public long getWebsocketPingInterval();
  public A withWebsocketPingInterval(long websocketPingInterval);
  public Boolean hasWebsocketPingInterval();
  public int getConnectionTimeout();
  public A withConnectionTimeout(int connectionTimeout);
  public Boolean hasConnectionTimeout();
  public int getMaxConcurrentRequests();
  public A withMaxConcurrentRequests(int maxConcurrentRequests);
  public Boolean hasMaxConcurrentRequests();
  public int getMaxConcurrentRequestsPerHost();
  public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost);
  public Boolean hasMaxConcurrentRequestsPerHost();
  public A addToContexts(int index,NamedContext item);
  public A setToContexts(int index,NamedContext item);
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A addAllToContexts(Collection<NamedContext> items);
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A removeAllFromContexts(Collection<NamedContext> items);
  public List<NamedContext> getContexts();
  public NamedContext getContext(int index);
  public NamedContext getFirstContext();
  public NamedContext getLastContext();
  public NamedContext getMatchingContext(Predicate<NamedContext> predicate);
  public Boolean hasMatchingContext(Predicate<NamedContext> predicate);
  public A withContexts(List<NamedContext> contexts);
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts);
  public Boolean hasContexts();
  public NamedContext getCurrentContext();
  public A withCurrentContext(NamedContext currentContext);
  public Boolean hasCurrentContext();
  public int getWatchReconnectInterval();
  public A withWatchReconnectInterval(int watchReconnectInterval);
  public Boolean hasWatchReconnectInterval();
  public int getWatchReconnectLimit();
  public A withWatchReconnectLimit(int watchReconnectLimit);
  public Boolean hasWatchReconnectLimit();
  public int getUploadRequestTimeout();
  public A withUploadRequestTimeout(int uploadRequestTimeout);
  public Boolean hasUploadRequestTimeout();
  public int getRequestRetryBackoffLimit();
  public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit);
  public Boolean hasRequestRetryBackoffLimit();
  public int getRequestRetryBackoffInterval();
  public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval);
  public Boolean hasRequestRetryBackoffInterval();
  public int getRequestTimeout();
  public A withRequestTimeout(int requestTimeout);
  public Boolean hasRequestTimeout();
  public long getScaleTimeout();
  public A withScaleTimeout(long scaleTimeout);
  public Boolean hasScaleTimeout();
  public int getLoggingInterval();
  public A withLoggingInterval(int loggingInterval);
  public Boolean hasLoggingInterval();
  public String getImpersonateUsername();
  public A withImpersonateUsername(String impersonateUsername);
  public Boolean hasImpersonateUsername();
  public A withImpersonateGroups(java.lang.String... impersonateGroups);
  public String[] getImpersonateGroups();
  public A addToImpersonateGroups(int index,String item);
  public A setToImpersonateGroups(int index,String item);
  public A addToImpersonateGroups(java.lang.String... items);
  public A addAllToImpersonateGroups(Collection<String> items);
  public A removeFromImpersonateGroups(java.lang.String... items);
  public A removeAllFromImpersonateGroups(Collection<String> items);
  public Boolean hasImpersonateGroups();
  public A addToImpersonateExtras(String key,List<String> value);
  public A addToImpersonateExtras(Map<String,List<String>> map);
  public A removeFromImpersonateExtras(String key);
  public A removeFromImpersonateExtras(Map<String,List<String>> map);
  public Map<String,List<String>> getImpersonateExtras();
  public <K,V>A withImpersonateExtras(Map<String,List<String>> impersonateExtras);
  public Boolean hasImpersonateExtras();
  public boolean isHttp2Disable();
  public A withHttp2Disable(boolean http2Disable);
  public Boolean hasHttp2Disable();
  public String getHttpProxy();
  public A withHttpProxy(String httpProxy);
  public Boolean hasHttpProxy();
  public String getHttpsProxy();
  public A withHttpsProxy(String httpsProxy);
  public Boolean hasHttpsProxy();
  public String getProxyUsername();
  public A withProxyUsername(String proxyUsername);
  public Boolean hasProxyUsername();
  public String getProxyPassword();
  public A withProxyPassword(String proxyPassword);
  public Boolean hasProxyPassword();
  public A withNoProxy(java.lang.String... noProxy);
  public String[] getNoProxy();
  public A addToNoProxy(int index,String item);
  public A setToNoProxy(int index,String item);
  public A addToNoProxy(java.lang.String... items);
  public A addAllToNoProxy(Collection<String> items);
  public A removeFromNoProxy(java.lang.String... items);
  public A removeAllFromNoProxy(Collection<String> items);
  public Boolean hasNoProxy();
  public String getUserAgent();
  public A withUserAgent(String userAgent);
  public Boolean hasUserAgent();
  public A withTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... tlsVersions);
  public TlsVersion[] getTlsVersions();
  public A addToTlsVersions(int index,TlsVersion item);
  public A setToTlsVersions(int index,TlsVersion item);
  public A addToTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items);
  public A addAllToTlsVersions(Collection<TlsVersion> items);
  public A removeFromTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items);
  public A removeAllFromTlsVersions(Collection<TlsVersion> items);
  public Boolean hasTlsVersions();
  public A addToErrorMessages(Integer key,String value);
  public A addToErrorMessages(Map<Integer,String> map);
  public A removeFromErrorMessages(Integer key);
  public A removeFromErrorMessages(Map<Integer,String> map);
  public Map<Integer,String> getErrorMessages();
  public <K,V>A withErrorMessages(Map<Integer,String> errorMessages);
  public Boolean hasErrorMessages();
  public A addToCustomHeaders(String key,String value);
  public A addToCustomHeaders(Map<String,String> map);
  public A removeFromCustomHeaders(String key);
  public A removeFromCustomHeaders(Map<String,String> map);
  public Map<String,String> getCustomHeaders();
  public <K,V>A withCustomHeaders(Map<String,String> customHeaders);
  public Boolean hasCustomHeaders();
  public boolean isAutoConfigure();
  public A withAutoConfigure(boolean autoConfigure);
  public Boolean hasAutoConfigure();
  public File getFile();
  public A withFile(File file);
  public Boolean hasFile();
  public A withTrustCerts();
  public A withDisableHostnameVerification();
  public A withDefaultNamespace();
  public A withHttp2Disable();
  public A withAutoConfigure();
  
}